/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HtmlUtils {
    private static final String START_COMMENT = "<!--";
    private static final String END_COMMENT = "-->";

    private HtmlUtils() {
    }

    public static String stripTags(String input, String allowedTags) {
        return HtmlUtils.removeUnknownTags(HtmlUtils.removeHtmlComments(input), allowedTags);
    }

    public static String stripTags(String input) {
        return HtmlUtils.removeUnknownTags(HtmlUtils.removeHtmlComments(input), "");
    }

    private static String removeUnknownTags(String input, String knownTags) {
        List<String> knownTagList = Arrays.asList(knownTags.replaceAll("^<", "").replaceAll(">$", "").split("><"));
        return HtmlUtils.removeTags(input, knownTagList);
    }

    private static String removeTags(String input, List<String> knownTagList) {
        Pattern tag = Pattern.compile("</?([^\\s>]*)\\s*[^>]*>", 2);
        Matcher matches = tag.matcher(input);
        String result = input;
        while (matches.find()) {
            if (knownTagList.contains(matches.group(1))) continue;
            result = result.replaceAll(Pattern.quote(matches.group()), "");
        }
        return result;
    }

    private static String removeTags(String input, String startTag, String endTag) {
        String result = input;
        while (result.contains(startTag)) {
            int start = result.indexOf(startTag);
            int end = result.substring(start + startTag.length()).indexOf(endTag);
            if (end == -1) {
                result = result.substring(0, start);
                continue;
            }
            result = result.substring(0, start) + result.substring(start + startTag.length() + end + endTag.length());
        }
        return result;
    }

    private static String removeHtmlComments(String input) {
        return HtmlUtils.removeTags(input, START_COMMENT, END_COMMENT);
    }
}

