/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.property.selection;

import com.google.common.base.Optional;
import java.util.Collection;
import org.jtwig.property.resolver.EmptyPropertyResolver;
import org.jtwig.property.resolver.PropertyResolver;
import org.jtwig.property.selection.SelectionPropertyResolveService;
import org.jtwig.property.selection.SelectionPropertyResolver;
import org.jtwig.property.selection.SelectionRequest;
import org.jtwig.property.selection.SelectionResult;
import org.jtwig.property.strategy.PropertyResolverStrategy;
import org.jtwig.reflection.model.Value;
import org.jtwig.value.Undefined;

public class BaseSelectionPropertyResolver
implements SelectionPropertyResolver {
    private final Collection<PropertyResolverStrategy> strategies;
    private final SelectionPropertyResolveService selectionPropertyResolveService;

    public BaseSelectionPropertyResolver(Collection<PropertyResolverStrategy> strategies, SelectionPropertyResolveService selectionPropertyResolveService) {
        this.strategies = strategies;
        this.selectionPropertyResolveService = selectionPropertyResolveService;
    }

    @Override
    public SelectionResult resolve(SelectionRequest request) {
        Object leftValue = request.getEnvironment().getRenderEnvironment().getCalculateExpressionService().calculate(request, request.getLeftExpression());
        if (leftValue == null || leftValue == Undefined.UNDEFINED) {
            return new SelectionResult((Optional<PropertyResolver>)Optional.absent(), (Optional<Value>)Optional.absent());
        }
        PropertyResolverStrategy.Request strategyRequest = new PropertyResolverStrategy.Request(request, leftValue, request.getRightExpression());
        for (PropertyResolverStrategy strategy : this.strategies) {
            Optional<PropertyResolver> strategyResult = strategy.select(strategyRequest);
            if (!strategyResult.isPresent()) continue;
            return this.selectionPropertyResolveService.resolve((PropertyResolver)strategyResult.get(), request, leftValue);
        }
        return new SelectionResult((Optional<PropertyResolver>)Optional.of((Object)EmptyPropertyResolver.instance()), (Optional<Value>)Optional.absent());
    }
}

