/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.model.expression;

import org.jtwig.exceptions.CalculationException;
import org.jtwig.model.expression.Expression;
import org.jtwig.model.expression.InjectableExpression;
import org.jtwig.model.position.Position;
import org.jtwig.render.expression.calculator.operation.binary.BinaryOperator;
import org.jtwig.util.ErrorMessageFormatter;

public class BinaryOperationExpression
extends InjectableExpression {
    private final Expression leftOperand;
    private final BinaryOperator binaryOperator;
    private final Expression rightOperand;

    public BinaryOperationExpression(Position position, Expression leftOperand, BinaryOperator binaryOperator, Expression rightOperand) {
        super(position);
        this.leftOperand = leftOperand;
        this.binaryOperator = binaryOperator;
        this.rightOperand = rightOperand;
    }

    public Expression getLeftOperand() {
        return this.leftOperand;
    }

    public BinaryOperator getBinaryOperator() {
        return this.binaryOperator;
    }

    public Expression getRightOperand() {
        return this.rightOperand;
    }

    @Override
    public Expression inject(Expression expression) {
        if (this.leftOperand instanceof InjectableExpression) {
            Expression inject = ((InjectableExpression)this.leftOperand).inject(expression);
            return new BinaryOperationExpression(this.getPosition(), inject, this.binaryOperator, this.rightOperand);
        }
        throw new CalculationException(ErrorMessageFormatter.errorMessage(this.getPosition(), "Invalid expression, expecting a valid injectable expression (binary operator, variable or function)"));
    }
}

