/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.SwitchPoint;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.targets.Bootstrap;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class ConstantLookupSite
extends MutableCallSite {
    private static final Logger LOG = LoggerFactory.getLogger("ConstantLookupSite");
    private final String name;
    private final boolean publicOnly;
    private final MethodHandles.Lookup lookup;
    public static final Handle BOOTSTRAP = new Handle(6, CodegenUtils.p(ConstantLookupSite.class), "constLookup", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Integer.TYPE));

    public ConstantLookupSite(MethodHandles.Lookup lookup, MethodType type2, String name2, boolean publicOnly) {
        super(type2);
        this.name = name2;
        this.publicOnly = publicOnly;
        this.lookup = lookup;
    }

    public static CallSite constLookup(MethodHandles.Lookup lookup, String searchType, MethodType type2, String constName, int publicOnly) {
        ConstantLookupSite site = new ConstantLookupSite(lookup, type2, constName, publicOnly != 0);
        MethodHandle handle = Binder.from((MethodHandles.Lookup)lookup, (MethodType)type2).insert(0, new Object[]{site}).invokeVirtualQuiet(lookup, searchType);
        site.setTarget(handle);
        return site;
    }

    public IRubyObject searchConst(ThreadContext context, StaticScope staticScope) {
        Ruby runtime = context.getRuntime();
        RubyClass object = runtime.getObject();
        IRubyObject constant = staticScope == null ? object.getConstant(this.name) : staticScope.getConstantInner(this.name);
        RubyModule module = null;
        if (constant == null) {
            module = staticScope == null ? object : staticScope.getModule();
            IRubyObject iRubyObject = constant = this.publicOnly ? module.getConstantFromNoConstMissing(this.name, false) : module.getConstantNoConstMissing(this.name);
        }
        if (constant == null) {
            return module.callMethod(context, "const_missing", (IRubyObject)context.runtime.fastNewSymbol(this.name));
        }
        SwitchPoint switchPoint = (SwitchPoint)runtime.getConstantInvalidator(this.name).getData();
        MethodHandle target = Binder.from((MethodType)this.type()).drop(0, 2).constant((Object)constant);
        MethodHandle fallback = this.getTarget();
        if (fallback == null) {
            fallback = Binder.from((MethodType)this.type()).insert(0, new Object[]{this}).invokeVirtualQuiet(Bootstrap.LOOKUP, "searchConst");
        }
        this.setTarget(switchPoint.guardWithTest(target, fallback));
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_CONSTANTS.load()).booleanValue()) {
            LOG.info(this.name + "\tretrieved and cached from scope " + staticScope.getIRScope(), new Object[0]);
        }
        return constant;
    }

    public IRubyObject searchModuleForConst(ThreadContext context, IRubyObject cmVal) {
        IRubyObject constant;
        RubyModule module = (RubyModule)cmVal;
        Ruby runtime = context.getRuntime();
        IRubyObject iRubyObject = constant = this.publicOnly ? module.getConstantFromNoConstMissing(this.name, false) : module.getConstantNoConstMissing(this.name);
        if (constant == null) {
            return module.callMethod(context, "const_missing", (IRubyObject)context.runtime.fastNewSymbol(this.name));
        }
        SwitchPoint switchPoint = (SwitchPoint)runtime.getConstantInvalidator(this.name).getData();
        MethodHandle target = Binder.from((MethodType)this.type()).drop(0, 2).constant((Object)constant);
        MethodHandle fallback = this.getTarget();
        if (fallback == null) {
            fallback = Binder.from((MethodType)this.type()).insert(0, new Object[]{this}).invokeVirtualQuiet(Bootstrap.LOOKUP, "searchModuleForConst");
        }
        MethodHandle test2 = Binder.from((MethodType)this.type().changeReturnType(Boolean.TYPE)).drop(0, 1).insert(1, module.id).invokeStaticQuiet(Bootstrap.LOOKUP, Bootstrap.class, "testArg0ModuleMatch");
        target = MethodHandles.guardWithTest(test2, target, fallback);
        this.setTarget(switchPoint.guardWithTest(target, fallback));
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_CONSTANTS.load()).booleanValue()) {
            LOG.info(this.name + "\tretrieved and cached from module " + module, new Object[0]);
        }
        return constant;
    }

    public IRubyObject inheritanceSearchConst(ThreadContext context, IRubyObject cmVal) {
        IRubyObject constant;
        Ruby runtime = context.runtime;
        if (!(cmVal instanceof RubyModule)) {
            throw runtime.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        IRubyObject iRubyObject = constant = this.publicOnly ? module.getConstantFromNoConstMissing(this.name, false) : module.getConstantNoConstMissing(this.name);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        SwitchPoint switchPoint = (SwitchPoint)runtime.getConstantInvalidator(this.name).getData();
        MethodHandle target = Binder.from((MethodType)this.type()).drop(0, 2).constant((Object)constant);
        MethodHandle fallback = this.getTarget();
        if (fallback == null) {
            fallback = Binder.from((MethodType)this.type()).insert(0, new Object[]{this}).invokeVirtualQuiet(Bootstrap.LOOKUP, "inheritanceSearchConst");
        }
        MethodHandle test2 = Binder.from((MethodType)this.type().changeReturnType(Boolean.TYPE)).drop(0, 1).insert(1, module.id).invokeStaticQuiet(Bootstrap.LOOKUP, Bootstrap.class, "testArg0ModuleMatch");
        target = MethodHandles.guardWithTest(test2, target, fallback);
        this.setTarget(switchPoint.guardWithTest(target, fallback));
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_CONSTANTS.load()).booleanValue()) {
            LOG.info(this.name + "\tretrieved and cached from type " + cmVal.getMetaClass(), new Object[0]);
        }
        return constant;
    }

    public IRubyObject lexicalSearchConst(ThreadContext context, StaticScope scope) {
        Ruby runtime = context.runtime;
        IRubyObject constant = scope.getConstantInner(this.name);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        SwitchPoint switchPoint = (SwitchPoint)runtime.getConstantInvalidator(this.name).getData();
        MethodHandle target = Binder.from((MethodType)this.type()).drop(0, 2).constant((Object)constant);
        MethodHandle fallback = this.getTarget();
        if (fallback == null) {
            fallback = Binder.from((MethodType)this.type()).insert(0, new Object[]{this}).invokeVirtualQuiet(Bootstrap.LOOKUP, "lexicalSearchConst");
        }
        this.setTarget(switchPoint.guardWithTest(target, fallback));
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_CONSTANTS.load()).booleanValue()) {
            LOG.info(this.name + "\tretrieved and cached from scope " + scope.getIRScope(), new Object[0]);
        }
        return constant;
    }
}

