/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import jnr.posix.FileStat;
import org.jruby.util.JarResource;

class JarFileStat
implements FileStat {
    private final JarResource jarResource;

    public JarFileStat(JarResource jarResource) {
        this.jarResource = jarResource;
    }

    public long atime() {
        return this.jarResource.lastModified();
    }

    public long blocks() {
        return this.jarResource.length();
    }

    public long blockSize() {
        return 1L;
    }

    public long ctime() {
        return this.jarResource.lastModified();
    }

    public long dev() {
        return -1L;
    }

    public String ftype() {
        return "zip file entry";
    }

    public int gid() {
        return -1;
    }

    public boolean groupMember(int i2) {
        return false;
    }

    public long ino() {
        return -1L;
    }

    public boolean isBlockDev() {
        return false;
    }

    public boolean isCharDev() {
        return false;
    }

    public boolean isDirectory() {
        return this.jarResource.isDirectory();
    }

    public boolean isEmpty() {
        return this.jarResource.length() == 0L;
    }

    public boolean isExecutable() {
        return false;
    }

    public boolean isExecutableReal() {
        return false;
    }

    public boolean isFifo() {
        return false;
    }

    public boolean isFile() {
        return !this.jarResource.isDirectory();
    }

    public boolean isGroupOwned() {
        return false;
    }

    public boolean isIdentical(FileStat fs) {
        return fs instanceof JarFileStat && ((JarFileStat)fs).jarResource.equals(this.jarResource);
    }

    public boolean isNamedPipe() {
        return false;
    }

    public boolean isOwned() {
        return false;
    }

    public boolean isROwned() {
        return false;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isReadableReal() {
        return true;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isWritableReal() {
        return false;
    }

    public boolean isSetgid() {
        return false;
    }

    public boolean isSetuid() {
        return false;
    }

    public boolean isSocket() {
        return false;
    }

    public boolean isSticky() {
        return false;
    }

    public boolean isSymlink() {
        return false;
    }

    public int major(long l) {
        return -1;
    }

    public int minor(long l) {
        return -1;
    }

    public int mode() {
        return -1;
    }

    public long mtime() {
        return this.jarResource.lastModified();
    }

    public int nlink() {
        return -1;
    }

    public long rdev() {
        return -1L;
    }

    public long st_size() {
        return this.jarResource.length();
    }

    public int uid() {
        return 0;
    }
}

