/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;

public abstract class ReturnBase
extends Instr {
    protected Operand returnValue;

    public ReturnBase(Operation op, Operand returnValue) {
        super(op);
        this.returnValue = returnValue;
        assert (returnValue != null) : "RETURN must have returnValue operand";
    }

    public Operand getReturnValue() {
        return this.returnValue;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.returnValue};
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.returnValue + ")";
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.returnValue = this.returnValue.getSimplifiedOperand(valueMap, force);
    }
}

