/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.postgres;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Record4;
import org.jooq.Record5;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.WindowSpecification;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.tools.JooqLogger;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.AbstractDefinition;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultCheckConstraintDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultEnumDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.postgres.PostgresDSL;
import org.jooq.util.postgres.PostgresRoutineDefinition;
import org.jooq.util.postgres.PostgresTableDefinition;
import org.jooq.util.postgres.PostgresTableValuedFunction;
import org.jooq.util.postgres.PostgresUDTDefinition;
import org.jooq.util.postgres.information_schema.tables.CheckConstraints;
import org.jooq.util.postgres.information_schema.tables.Routines;
import org.jooq.util.postgres.information_schema.tables.TableConstraints;
import org.jooq.util.postgres.pg_catalog.Tables;
import org.jooq.util.postgres.pg_catalog.tables.PgClass;
import org.jooq.util.postgres.pg_catalog.tables.PgInherits;
import org.jooq.util.postgres.pg_catalog.tables.PgNamespace;

public class PostgresDatabase
extends AbstractDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(PostgresDatabase.class);
    private static Boolean is84;
    private static Boolean canCastToEnumType;

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private Result<Record4<String, String, String, String>> fetchKeys(String constraintType) {
        return this.create().select(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME, org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA, org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_NAME, org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.COLUMN_NAME).from((TableLike)org.jooq.util.postgres.information_schema.Tables.TABLE_CONSTRAINTS).join((TableLike)org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE).on(new Condition[]{org.jooq.util.postgres.information_schema.Tables.TABLE_CONSTRAINTS.CONSTRAINT_SCHEMA.equal(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_SCHEMA)}).and(org.jooq.util.postgres.information_schema.Tables.TABLE_CONSTRAINTS.CONSTRAINT_NAME.equal(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME)).where(new Condition[]{org.jooq.util.postgres.information_schema.Tables.TABLE_CONSTRAINTS.CONSTRAINT_TYPE.equal((Object)constraintType)}).and(org.jooq.util.postgres.information_schema.Tables.TABLE_CONSTRAINTS.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.asc(), org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_NAME.asc(), org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.asc(), org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.ORDINAL_POSITION.asc()).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Result result = this.create().fetch(this.getConnection().getMetaData().getExportedKeys(null, null, null)).sortAsc("key_seq").sortAsc("fk_name").sortAsc("fktable_name").sortAsc("fktable_schem");
        for (Record record : result) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.getValue("fktable_schem", String.class));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.getValue("pktable_schem", String.class));
            String foreignKey = (String)record.getValue("fk_name", String.class);
            String foreignKeyTable = (String)record.getValue("fktable_name", String.class);
            String foreignKeyColumn = (String)record.getValue("fkcolumn_name", String.class);
            String uniqueKey = (String)record.getValue("pk_name", String.class);
            TableDefinition referencingTable = this.getTable(foreignKeySchema, foreignKeyTable);
            if (referencingTable == null) continue;
            ColumnDefinition referencingColumn = referencingTable.getColumn(foreignKeyColumn);
            relations2.addForeignKey(foreignKeyTable + "__" + foreignKey, uniqueKey, referencingColumn, uniqueKeySchema);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        TableConstraints tc = org.jooq.util.postgres.information_schema.Tables.TABLE_CONSTRAINTS.as("tc");
        CheckConstraints cc = org.jooq.util.postgres.information_schema.Tables.CHECK_CONSTRAINTS.as("cc");
        for (Record record : this.create().select(tc.TABLE_SCHEMA, tc.TABLE_NAME, cc.CONSTRAINT_NAME, cc.CHECK_CLAUSE).from((TableLike)tc).join((TableLike)cc).using(new Field[]{tc.CONSTRAINT_CATALOG, tc.CONSTRAINT_SCHEMA, tc.CONSTRAINT_NAME}).where(new Condition[]{tc.TABLE_SCHEMA.in(this.getInputSchemata())}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(tc.TABLE_SCHEMA));
            TableDefinition table = this.getTable(schema, (String)record.getValue(tc.TABLE_NAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.getValue(cc.CONSTRAINT_NAME), (String)record.getValue(cc.CHECK_CLAUSE)));
        }
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        HashMap<Name, PostgresTableDefinition> map = new HashMap<Name, PostgresTableDefinition>();
        for (Record record : this.create().select(new SelectField[0]).from((TableLike)DSL.select(org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_SCHEMA, org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_NAME, (SelectField)org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_NAME.as("specific_name"), (SelectField)DSL.inline((Object)false).as("table_valued_function"), Tables.PG_DESCRIPTION.DESCRIPTION).from((TableLike)org.jooq.util.postgres.information_schema.Tables.TABLES).join((TableLike)Tables.PG_NAMESPACE).on(new Condition[]{org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_SCHEMA.eq(Tables.PG_NAMESPACE.NSPNAME)}).join((TableLike)Tables.PG_CLASS).on(new Condition[]{Tables.PG_CLASS.RELNAME.eq(org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_NAME)}).and(Tables.PG_CLASS.RELNAMESPACE.eq(PostgresDSL.oid((Table)Tables.PG_NAMESPACE))).leftOuterJoin((TableLike)Tables.PG_DESCRIPTION).on(new Condition[]{Tables.PG_DESCRIPTION.OBJOID.eq(PostgresDSL.oid((Table)Tables.PG_CLASS))}).and(Tables.PG_DESCRIPTION.OBJSUBID.eq((Object)0)).where(new Condition[]{org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_SCHEMA.in(this.getInputSchemata())}).unionAll((Select)DSL.select(org.jooq.util.postgres.information_schema.Tables.ROUTINES.ROUTINE_SCHEMA, org.jooq.util.postgres.information_schema.Tables.ROUTINES.ROUTINE_NAME, org.jooq.util.postgres.information_schema.Tables.ROUTINES.SPECIFIC_NAME, (SelectField)DSL.inline((Object)true).as("table_valued_function"), (SelectField)DSL.inline((CharSequence)"")).from((TableLike)org.jooq.util.postgres.information_schema.Tables.ROUTINES).join((TableLike)Tables.PG_NAMESPACE).on(new Condition[]{org.jooq.util.postgres.information_schema.Tables.ROUTINES.SPECIFIC_SCHEMA.eq(Tables.PG_NAMESPACE.NSPNAME)}).join((TableLike)Tables.PG_PROC).on(new Condition[]{Tables.PG_PROC.PRONAMESPACE.eq(PostgresDSL.oid((Table)Tables.PG_NAMESPACE))}).and(Tables.PG_PROC.PRONAME.concat(new String[]{"_"}).concat(new Field[]{PostgresDSL.oid((Table)Tables.PG_PROC)}).eq(org.jooq.util.postgres.information_schema.Tables.ROUTINES.SPECIFIC_NAME)).where(new Condition[]{org.jooq.util.postgres.information_schema.Tables.ROUTINES.ROUTINE_SCHEMA.in(this.getInputSchemata())}).and(Tables.PG_PROC.PRORETSET)).asTable("tables")).orderBy(new int[]{1, 2}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_SCHEMA));
            String name = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_NAME);
            boolean tableValuedFunction = (Boolean)record.getValue("table_valued_function", Boolean.TYPE);
            String comment = (String)record.getValue(Tables.PG_DESCRIPTION.DESCRIPTION, String.class);
            if (tableValuedFunction) {
                result.add(new PostgresTableValuedFunction(schema, name, (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.ROUTINES.SPECIFIC_NAME), comment));
                continue;
            }
            PostgresTableDefinition t = new PostgresTableDefinition(schema, name, comment);
            result.add(t);
            map.put(DSL.name((String[])new String[]{schema.getName(), name}), t);
        }
        PgClass ct = Tables.PG_CLASS.as("ct");
        PgNamespace cn = Tables.PG_NAMESPACE.as("cn");
        PgInherits i = Tables.PG_INHERITS.as("i");
        PgClass pt = Tables.PG_CLASS.as("pt");
        PgNamespace pn = Tables.PG_NAMESPACE.as("pn");
        if (this.is84()) {
            for (Record5 inheritance : this.create().select(cn.NSPNAME, ct.RELNAME, pn.NSPNAME, pt.RELNAME, (SelectField)DSL.max(i.INHSEQNO).over().partitionBy(new Field[]{i.INHRELID}).as("m")).from((TableLike)ct).join((TableLike)cn).on(new Condition[]{ct.RELNAMESPACE.eq(PostgresDSL.oid((Table)cn))}).join((TableLike)i).on(new Condition[]{i.INHRELID.eq(PostgresDSL.oid((Table)ct))}).join((TableLike)pt).on(new Condition[]{i.INHPARENT.eq(PostgresDSL.oid((Table)pt))}).join((TableLike)pn).on(new Condition[]{pt.RELNAMESPACE.eq(PostgresDSL.oid((Table)pn))}).where(new Condition[]{cn.NSPNAME.in(this.getInputSchemata())}).and(pn.NSPNAME.in(this.getInputSchemata())).fetch()) {
                Name child = DSL.name((String[])new String[]{(String)inheritance.value1(), (String)inheritance.value2()});
                Name parent = DSL.name((String[])new String[]{(String)inheritance.value3(), (String)inheritance.value4()});
                if ((Integer)inheritance.value5() > 1) {
                    log.info((Object)"Multiple inheritance", (Object)("Multiple inheritance is not supported by jOOQ: " + child + " inherits from " + parent));
                    continue;
                }
                PostgresTableDefinition childTable = (PostgresTableDefinition)map.get(child);
                PostgresTableDefinition parentTable = (PostgresTableDefinition)map.get(parent);
                if (childTable == null || parentTable == null) continue;
                childTable.setParentTable(parentTable);
                parentTable.getChildTables().add(childTable);
            }
        }
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (String name : this.create().select(Tables.PG_NAMESPACE.NSPNAME).from((TableLike)Tables.PG_NAMESPACE).fetch(Tables.PG_NAMESPACE.NSPNAME)) {
            result.add(new SchemaDefinition((Database)this, name, ""));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(org.jooq.util.postgres.information_schema.Tables.SEQUENCES.SEQUENCE_SCHEMA, org.jooq.util.postgres.information_schema.Tables.SEQUENCES.SEQUENCE_NAME, org.jooq.util.postgres.information_schema.Tables.SEQUENCES.DATA_TYPE, org.jooq.util.postgres.information_schema.Tables.SEQUENCES.NUMERIC_PRECISION, org.jooq.util.postgres.information_schema.Tables.SEQUENCES.NUMERIC_SCALE).from((TableLike)org.jooq.util.postgres.information_schema.Tables.SEQUENCES).where(new Condition[]{org.jooq.util.postgres.information_schema.Tables.SEQUENCES.SEQUENCE_SCHEMA.in(this.getInputSchemata())}).orderBy(org.jooq.util.postgres.information_schema.Tables.SEQUENCES.SEQUENCE_SCHEMA, org.jooq.util.postgres.information_schema.Tables.SEQUENCES.SEQUENCE_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(org.jooq.util.postgres.information_schema.Tables.SEQUENCES.SEQUENCE_SCHEMA));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.SEQUENCES.DATA_TYPE), 0, (Number)record.getValue(org.jooq.util.postgres.information_schema.Tables.SEQUENCES.NUMERIC_PRECISION), (Number)record.getValue(org.jooq.util.postgres.information_schema.Tables.SEQUENCES.NUMERIC_SCALE), false, false);
            result.add(new DefaultSequenceDefinition(schema, (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.SEQUENCES.SEQUENCE_NAME), type));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        if (this.exists((Table<?>)Tables.PG_ENUM)) {
            Result types = this.create().select(Tables.PG_NAMESPACE.NSPNAME, Tables.PG_TYPE.TYPNAME).from((TableLike)Tables.PG_TYPE).join((TableLike)Tables.PG_NAMESPACE).on(new Condition[]{Tables.PG_TYPE.TYPNAMESPACE.eq(PostgresDSL.oid((Table)Tables.PG_NAMESPACE))}).where(new Condition[]{Tables.PG_NAMESPACE.NSPNAME.in(this.getInputSchemata())}).and(PostgresDSL.oid((Table)Tables.PG_TYPE).in((Select)DSL.select(Tables.PG_ENUM.ENUMTYPID).from((TableLike)Tables.PG_ENUM))).orderBy(Tables.PG_NAMESPACE.NSPNAME, Tables.PG_TYPE.TYPNAME).fetch();
            for (Record2 type : types) {
                String nspname = (String)type.getValue(Tables.PG_NAMESPACE.NSPNAME);
                String typname = (String)type.getValue(Tables.PG_TYPE.TYPNAME);
                AbstractDefinition definition = null;
                for (String label : this.enumLabels(nspname, typname)) {
                    SchemaDefinition schema = this.getSchema(nspname);
                    String typeName = String.valueOf(typname);
                    if (definition == null || !definition.getName().equals(typeName)) {
                        definition = new DefaultEnumDefinition(schema, typeName, null);
                        result.add((EnumDefinition)((Object)definition));
                    }
                    ((DefaultEnumDefinition)definition).addLiteral(label);
                }
            }
        }
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        if (this.exists((Table<?>)org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES)) {
            for (Record record : this.create().selectDistinct(org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES.UDT_SCHEMA, org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES.UDT_NAME).from((TableLike)org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES).where(new Condition[]{org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES.UDT_SCHEMA.in(this.getInputSchemata())}).orderBy(org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES.UDT_SCHEMA, org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES.UDT_NAME).fetch()) {
                SchemaDefinition schema = this.getSchema((String)record.getValue(org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES.UDT_SCHEMA));
                String name = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES.UDT_NAME);
                result.add(new PostgresUDTDefinition(schema, name, null));
            }
        }
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        Routines r1 = org.jooq.util.postgres.information_schema.Tables.ROUTINES.as("r1");
        for (Record record : this.create().select(r1.ROUTINE_SCHEMA, r1.ROUTINE_NAME, r1.SPECIFIC_NAME, (SelectField)DSL.when((Condition)DSL.condition((String)"{0} && ARRAY['o','b']::\"char\"[]", (QueryPart[])new QueryPart[]{Tables.PG_PROC.PROARGMODES}), (Field)DSL.inline((CharSequence)"void")).otherwise(r1.DATA_TYPE).as("data_type"), r1.CHARACTER_MAXIMUM_LENGTH, r1.NUMERIC_PRECISION, r1.NUMERIC_SCALE, r1.TYPE_UDT_SCHEMA, r1.TYPE_UDT_NAME, (SelectField)DSL.when((Condition)DSL.count().over((WindowSpecification)DSL.partitionBy((Field[])new Field[]{r1.ROUTINE_SCHEMA, r1.ROUTINE_NAME})).gt(DSL.one()), (Field)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((Field[])new Field[]{r1.ROUTINE_SCHEMA, r1.ROUTINE_NAME}).orderBy(new Field[]{r1.SPECIFIC_NAME}))).as("overload"), Tables.PG_PROC.PROISAGG).from((TableLike)r1).join((TableLike)Tables.PG_NAMESPACE).on(new Condition[]{Tables.PG_NAMESPACE.NSPNAME.eq(r1.SPECIFIC_SCHEMA)}).join((TableLike)Tables.PG_PROC).on(new Condition[]{Tables.PG_PROC.PRONAMESPACE.eq(PostgresDSL.oid((Table)Tables.PG_NAMESPACE))}).and(Tables.PG_PROC.PRONAME.concat(new String[]{"_"}).concat(new Field[]{PostgresDSL.oid((Table)Tables.PG_PROC)}).eq(r1.SPECIFIC_NAME)).where(new Condition[]{r1.ROUTINE_SCHEMA.in(this.getInputSchemata())}).andNot(Tables.PG_PROC.PRORETSET).orderBy(r1.ROUTINE_SCHEMA.asc(), r1.ROUTINE_NAME.asc(), DSL.field((Name)DSL.name((String[])new String[]{"overload"})).asc()).fetch()) {
            result.add(new PostgresRoutineDefinition(this, record));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.POSTGRES);
    }

    private boolean is84() {
        if (is84 == null) {
            try {
                this.create().select((SelectField)DSL.count().over()).fetch();
                is84 = true;
            }
            catch (DataAccessException e) {
                is84 = false;
            }
        }
        return is84;
    }

    private List<String> enumLabels(String nspname, String typname) {
        Field cast = DSL.field((String)"{0}::{1}", (QueryPart[])new QueryPart[]{Tables.PG_ENUM.ENUMLABEL, DSL.name((String[])new String[]{nspname, typname})});
        if (canCastToEnumType == null) {
            try {
                canCastToEnumType = true;
                return this.enumLabels(nspname, typname, cast);
            }
            catch (DataAccessException e) {
                canCastToEnumType = false;
            }
        }
        return canCastToEnumType != false ? this.enumLabels(nspname, typname, cast) : this.enumLabels(nspname, typname, (Field<?>)Tables.PG_ENUM.ENUMLABEL);
    }

    private List<String> enumLabels(String nspname, String typname, Field<?> orderBy) {
        return this.create().select(Tables.PG_ENUM.ENUMLABEL).from((TableLike)Tables.PG_ENUM).join((TableLike)Tables.PG_TYPE).on(new Condition[]{Tables.PG_ENUM.ENUMTYPID.eq(PostgresDSL.oid((Table)Tables.PG_TYPE))}).join((TableLike)Tables.PG_NAMESPACE).on(new Condition[]{Tables.PG_TYPE.TYPNAMESPACE.eq(PostgresDSL.oid((Table)Tables.PG_NAMESPACE))}).where(new Condition[]{Tables.PG_NAMESPACE.NSPNAME.eq((Object)nspname)}).and(Tables.PG_TYPE.TYPNAME.eq((Object)typname)).orderBy(orderBy).fetch(Tables.PG_ENUM.ENUMLABEL);
    }
}

