/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.firebird;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Record3;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.firebird.FirebirdDataType;
import org.jooq.util.firebird.FirebirdRoutineDefinition;
import org.jooq.util.firebird.FirebirdTableDefinition;
import org.jooq.util.firebird.FirebirdTableValuedFunction;
import org.jooq.util.firebird.rdb.Tables;
import org.jooq.util.firebird.rdb.tables.Rdb$fields;
import org.jooq.util.firebird.rdb.tables.Rdb$indexSegments;
import org.jooq.util.firebird.rdb.tables.Rdb$refConstraints;
import org.jooq.util.firebird.rdb.tables.Rdb$relationConstraints;
import org.jooq.util.jaxb.Schema;

public class FirebirdDatabase
extends AbstractDatabase {
    public FirebirdDatabase() {
        Schema schema = new Schema();
        schema.setInputSchema("");
        schema.setOutputSchema("");
        ArrayList<Schema> schemata = new ArrayList<Schema>();
        schemata.add(schema);
        this.setConfiguredSchemata(schemata);
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations r) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            String tableName = (String)record.getValue(Tables.RDB$RELATION_CONSTRAINTS.RDB$RELATION_NAME.trim());
            String fieldName = (String)record.getValue(Tables.RDB$INDEX_SEGMENTS.RDB$FIELD_NAME.trim());
            String key = (String)record.getValue(Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_NAME.trim());
            TableDefinition td = this.getTable(this.getSchemata().get(0), tableName);
            if (td == null) continue;
            ColumnDefinition cd = td.getColumn(fieldName);
            r.addPrimaryKey(key, cd);
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations r) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            String tableName = (String)record.getValue(Tables.RDB$RELATION_CONSTRAINTS.RDB$RELATION_NAME.trim());
            String fieldName = (String)record.getValue(Tables.RDB$INDEX_SEGMENTS.RDB$FIELD_NAME.trim());
            String key = (String)record.getValue(Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_NAME.trim());
            TableDefinition td = this.getTable(this.getSchemata().get(0), tableName);
            if (td == null) continue;
            ColumnDefinition cd = td.getColumn(fieldName);
            r.addUniqueKey(key, cd);
        }
    }

    private Result<Record3<String, String, String>> fetchKeys(String constraintType) {
        return this.create().select((SelectField)Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_NAME.trim(), (SelectField)Tables.RDB$RELATION_CONSTRAINTS.RDB$RELATION_NAME.trim(), (SelectField)Tables.RDB$INDEX_SEGMENTS.RDB$FIELD_NAME.trim()).from((TableLike)Tables.RDB$RELATION_CONSTRAINTS).join((TableLike)Tables.RDB$INDEX_SEGMENTS).on(new Condition[]{Tables.RDB$INDEX_SEGMENTS.RDB$INDEX_NAME.eq(Tables.RDB$RELATION_CONSTRAINTS.RDB$INDEX_NAME)}).where(new Condition[]{Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_TYPE.eq((Object)constraintType)}).orderBy(Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_NAME.asc(), Tables.RDB$INDEX_SEGMENTS.RDB$FIELD_POSITION.asc()).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Rdb$relationConstraints pk = Tables.RDB$RELATION_CONSTRAINTS.as("pk");
        Rdb$relationConstraints fk = Tables.RDB$RELATION_CONSTRAINTS.as("fk");
        Rdb$refConstraints rc = Tables.RDB$REF_CONSTRAINTS.as("rc");
        Rdb$indexSegments isp = Tables.RDB$INDEX_SEGMENTS.as("isp");
        Rdb$indexSegments isf = Tables.RDB$INDEX_SEGMENTS.as("isf");
        for (Record record : this.create().selectDistinct((SelectField)fk.RDB$CONSTRAINT_NAME.trim().as("fk"), (SelectField)fk.RDB$RELATION_NAME.trim().as("fkTable"), (SelectField)isf.RDB$FIELD_NAME.trim().as("fkField"), (SelectField)pk.RDB$CONSTRAINT_NAME.trim().as("pk"), (SelectField)pk.RDB$RELATION_NAME.trim().as("pkTable")).from((TableLike)fk).join((TableLike)rc).on(new Condition[]{fk.RDB$CONSTRAINT_NAME.eq(rc.RDB$CONSTRAINT_NAME)}).join((TableLike)pk).on(new Condition[]{pk.RDB$CONSTRAINT_NAME.eq(rc.RDB$CONST_NAME_UQ)}).join((TableLike)isp).on(new Condition[]{isp.RDB$INDEX_NAME.eq(pk.RDB$INDEX_NAME)}).join((TableLike)isf).on(new Condition[]{isf.RDB$INDEX_NAME.eq(fk.RDB$INDEX_NAME)}).where(new Condition[]{isp.RDB$FIELD_POSITION.eq(isf.RDB$FIELD_POSITION)}).orderBy(fk.RDB$CONSTRAINT_NAME.asc(), isf.RDB$FIELD_POSITION.asc()).fetch()) {
            String pkName = (String)record.getValue("pk", String.class);
            String pkTable = (String)record.getValue("pkTable", String.class);
            String fkName = (String)record.getValue("fk", String.class);
            String fkTable = (String)record.getValue("fkTable", String.class);
            String fkField = (String)record.getValue("fkField", String.class);
            TableDefinition tdReferencing = this.getTable(this.getSchemata().get(0), fkTable, true);
            TableDefinition tdReferenced = this.getTable(this.getSchemata().get(0), pkTable, true);
            if (tdReferenced == null || tdReferencing == null) continue;
            ColumnDefinition referencingColumn = tdReferencing.getColumn(fkField);
            relations2.addForeignKey(fkName, pkName, referencingColumn, this.getSchemata().get(0));
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r) throws SQLException {
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        result.add(new SchemaDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (String sequenceName : this.create().select((SelectField)Tables.RDB$GENERATORS.RDB$GENERATOR_NAME.trim()).from((TableLike)Tables.RDB$GENERATORS).orderBy(new int[]{1}).fetch(Tables.RDB$GENERATORS.RDB$GENERATOR_NAME.trim())) {
            SchemaDefinition schema = this.getSchemata().get(0);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, FirebirdDataType.BIGINT.getTypeName());
            result.add(new DefaultSequenceDefinition(schema, sequenceName, type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record2 record : this.create().select((SelectField)Tables.RDB$RELATIONS.RDB$RELATION_NAME.trim(), (SelectField)DSL.inline((Object)false).as("table_valued_function")).from((TableLike)Tables.RDB$RELATIONS).unionAll((Select)DSL.select((SelectField)Tables.RDB$PROCEDURES.RDB$PROCEDURE_NAME.trim(), (SelectField)DSL.inline((Object)true).as("table_valued_function")).from((TableLike)Tables.RDB$PROCEDURES).where(new Condition[]{Tables.RDB$PROCEDURES.RDB$PROCEDURE_TYPE.eq((Object)1)})).orderBy(new int[]{1})) {
            if (((Boolean)record.value2()).booleanValue()) {
                result.add(new FirebirdTableValuedFunction(this.getSchemata().get(0), (String)record.value1(), ""));
                continue;
            }
            result.add(new FirebirdTableDefinition(this.getSchemata().get(0), (String)record.value1(), ""));
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (String procedureName : this.create().select((SelectField)Tables.RDB$PROCEDURES.RDB$PROCEDURE_NAME.trim()).from((TableLike)Tables.RDB$PROCEDURES).where(new Condition[]{Tables.RDB$PROCEDURES.RDB$PROCEDURE_TYPE.eq((Object)2)}).orderBy(new int[]{1}).fetch(0, String.class)) {
            result.add(new FirebirdRoutineDefinition(this.getSchemata().get(0), procedureName));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.FIREBIRD);
    }

    static Field<String> FIELD_TYPE(Rdb$fields f) {
        return DSL.decode().value(f.RDB$FIELD_TYPE).when((Object)7, DSL.decode().when(f.RDB$FIELD_SUB_TYPE.eq((Object)1), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)0).and(f.RDB$FIELD_SCALE.lt((Object)0)), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)2), (Object)"DECIMAL").otherwise((Object)"SMALLINT")).when((Object)8, DSL.decode().when(f.RDB$FIELD_SUB_TYPE.eq((Object)1), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)0).and(f.RDB$FIELD_SCALE.lt((Object)0)), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)2), (Object)"DECIMAL").otherwise((Object)"INTEGER")).when((Object)9, (Object)"QUAD").when((Object)10, (Object)"FLOAT").when((Object)11, (Object)"D_FLOAT").when((Object)12, (Object)"DATE").when((Object)13, (Object)"TIME").when((Object)14, (Object)"CHAR").when((Object)16, DSL.decode().when(f.RDB$FIELD_SUB_TYPE.eq((Object)1), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)0).and(f.RDB$FIELD_SCALE.lt((Object)0)), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)2), (Object)"DECIMAL").otherwise((Object)"BIGINT")).when((Object)27, (Object)"DOUBLE").when((Object)35, (Object)"TIMESTAMP").when((Object)37, (Object)"VARCHAR").when((Object)40, (Object)"CSTRING").when((Object)261, DSL.decode().value(f.RDB$FIELD_SUB_TYPE).when((Object)0, (Object)"BLOB").when((Object)1, (Object)"BLOB SUB_TYPE TEXT").otherwise((Object)"BLOB")).otherwise((Object)"UNKNOWN");
    }

    static Field<Short> FIELD_SCALE(Rdb$fields f) {
        return f.RDB$FIELD_SCALE.neg();
    }

    static Field<Short> CHARACTER_LENGTH(Rdb$fields f) {
        return DSL.choose(f.RDB$FIELD_TYPE).when((Object)261, (Object)0).otherwise(f.RDB$CHARACTER_LENGTH);
    }
}

