/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.DataType;
import org.jooq.SQLDialect;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.DateAsTimestampBinding;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.SQLDataType;
import org.jooq.tools.Convert;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.Definition;
import org.jooq.util.TypedElementDefinition;
import org.jooq.util.jaxb.CustomType;
import org.jooq.util.jaxb.ForcedType;

abstract class AbstractTypedElementDefinition<T extends Definition>
extends AbstractDefinition
implements TypedElementDefinition<T> {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractTypedElementDefinition.class);
    private static final Pattern LENGTH_PRECISION_SCALE_PATTERN = Pattern.compile("[\\w\\s]+(?:\\(\\s*?(\\d+)\\s*?\\)|\\(\\s*?(\\d+)\\s*?,\\s*?(\\d+)\\s*?\\))");
    private final T container;
    private final DataTypeDefinition definedType;
    private transient DataTypeDefinition type;

    public AbstractTypedElementDefinition(T container, String name, int position, DataTypeDefinition definedType, String comment) {
        super(container.getDatabase(), container.getSchema(), AbstractTypedElementDefinition.protectName(container.getName(), name, position), comment);
        this.container = container;
        this.definedType = definedType;
    }

    private static String protectName(String table, String name, int position) {
        if (name == null) {
            log.warn((Object)"Missing name", (Object)("Object " + table + " holds a column without a name at position " + position));
            return "_" + position;
        }
        return name;
    }

    @Override
    public final T getContainer() {
        return this.container;
    }

    @Override
    public List<Definition> getDefinitionPath() {
        ArrayList<Definition> result = new ArrayList<Definition>();
        result.addAll(this.getContainer().getDefinitionPath());
        result.add(this);
        return result;
    }

    @Override
    public DataTypeDefinition getType() {
        if (this.type == null) {
            this.type = AbstractTypedElementDefinition.mapDefinedType(this.container, this, this.definedType);
        }
        return this.type;
    }

    static DataTypeDefinition mapDefinedType(Definition container, Definition child, DataTypeDefinition definedType) {
        ForcedType forcedType;
        DataTypeDefinition result = definedType;
        Database db = container.getDatabase();
        log.debug((Object)"Type mapping", (Object)(child + " with type " + definedType.getType()));
        if (db.dateAsTimestamp()) {
            DataType dataType = null;
            try {
                dataType = DefaultDataType.getDataType((SQLDialect)db.getDialect(), (String)result.getType(), (int)0, (int)0);
            }
            catch (SQLDialectNotSupportedException ignore) {
                // empty catch block
            }
            if (dataType != null && dataType.getSQLType() == 91) {
                DataType forcedDataType = DefaultDataType.getDataType((SQLDialect)db.getDialect(), (String)SQLDataType.TIMESTAMP.getTypeName(), (int)0, (int)0);
                result = new DefaultDataTypeDefinition(db, child.getSchema(), forcedDataType.getTypeName(), 0, 0, 0, result.isNullable(), result.isDefaulted(), null, null, DateAsTimestampBinding.class.getName());
            }
        }
        if ((forcedType = db.getConfiguredForcedType(child, definedType)) != null) {
            String type = forcedType.getName();
            String converter = null;
            String binding = result.getBinding();
            CustomType customType = AbstractTypedElementDefinition.customType(db, forcedType.getName());
            if (customType != null) {
                String string = type = !StringUtils.isBlank((String)customType.getType()) ? customType.getType() : customType.getName();
                if (!StringUtils.isBlank((String)customType.getConverter())) {
                    converter = customType.getConverter();
                }
                if (!StringUtils.isBlank((String)customType.getBinding())) {
                    binding = customType.getBinding();
                }
            }
            log.info((Object)"Forcing type", (Object)(child + " with type " + definedType.getType() + " into " + type + (converter != null ? " using converter " + converter : "")));
            DataType forcedDataType = null;
            boolean n = result.isNullable();
            boolean d = result.isDefaulted();
            int l = 0;
            int p = 0;
            int s = 0;
            Matcher matcher = LENGTH_PRECISION_SCALE_PATTERN.matcher(type);
            if (matcher.find()) {
                if (!StringUtils.isEmpty((String)matcher.group(1))) {
                    l = p = ((Integer)Convert.convert((Object)matcher.group(1), Integer.TYPE)).intValue();
                } else {
                    p = (Integer)Convert.convert((Object)matcher.group(2), Integer.TYPE);
                    s = (Integer)Convert.convert((Object)matcher.group(3), Integer.TYPE);
                }
            }
            try {
                forcedDataType = DefaultDataType.getDataType((SQLDialect)db.getDialect(), (String)type, (int)p, (int)s);
            }
            catch (SQLDialectNotSupportedException ignore) {
                // empty catch block
            }
            if (forcedDataType != null) {
                result = new DefaultDataTypeDefinition(db, child.getSchema(), type, l, p, s, n, d, null, converter, binding);
            } else {
                l = result.getLength();
                p = result.getPrecision();
                s = result.getScale();
                String t = result.getType();
                result = new DefaultDataTypeDefinition(db, child.getSchema(), t, l, p, s, n, d, type, converter, binding);
            }
        }
        return result;
    }

    static CustomType customType(Database db, String name) {
        for (CustomType type : db.getConfiguredCustomTypes()) {
            if (!name.equals(type.getName())) continue;
            return type;
        }
        return null;
    }
}

