/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.mysql;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record4;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.csv.CSVReader;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultEnumDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.mysql.MySQLRoutineDefinition;
import org.jooq.util.mysql.MySQLTableDefinition;
import org.jooq.util.mysql.information_schema.tables.Columns;
import org.jooq.util.mysql.information_schema.tables.KeyColumnUsage;
import org.jooq.util.mysql.information_schema.tables.ReferentialConstraints;
import org.jooq.util.mysql.information_schema.tables.Schemata;
import org.jooq.util.mysql.information_schema.tables.Statistics;
import org.jooq.util.mysql.information_schema.tables.Tables;
import org.jooq.util.mysql.mysql.enums.ProcType;
import org.jooq.util.mysql.mysql.tables.Proc;

public class MySQLDatabase
extends AbstractDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(MySQLDatabase.class);

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys(true)) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Statistics.TABLE_SCHEMA));
            String constraintName = (String)record.getValue(Statistics.INDEX_NAME);
            String tableName = (String)record.getValue(Statistics.TABLE_NAME);
            String columnName = (String)record.getValue(Statistics.COLUMN_NAME);
            String key = this.getKeyName(tableName, constraintName);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys(false)) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Statistics.TABLE_SCHEMA));
            String constraintName = (String)record.getValue(Statistics.INDEX_NAME);
            String tableName = (String)record.getValue(Statistics.TABLE_NAME);
            String columnName = (String)record.getValue(Statistics.COLUMN_NAME);
            String key = this.getKeyName(tableName, constraintName);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private String getKeyName(String tableName, String keyName) {
        return "KEY_" + tableName + "_" + keyName;
    }

    private Result<Record4<String, String, String, String>> fetchKeys(boolean primary) {
        return this.create().select(Statistics.TABLE_SCHEMA, Statistics.TABLE_NAME, Statistics.COLUMN_NAME, Statistics.INDEX_NAME).from(new TableLike[]{org.jooq.util.mysql.information_schema.Tables.STATISTICS}).where(new Condition[]{Statistics.TABLE_SCHEMA.in(this.getInputSchemata())}).and(primary ? Statistics.INDEX_NAME.eq((Field)DSL.inline((CharSequence)"PRIMARY")) : Statistics.INDEX_NAME.ne((Field)DSL.inline((CharSequence)"PRIMARY")).and(Statistics.NON_UNIQUE.eq((Field)DSL.inline((Object)0L)))).orderBy(Statistics.TABLE_SCHEMA, Statistics.TABLE_NAME, Statistics.INDEX_NAME, Statistics.SEQ_IN_INDEX).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.create().select(ReferentialConstraints.CONSTRAINT_SCHEMA, ReferentialConstraints.CONSTRAINT_NAME, ReferentialConstraints.TABLE_NAME, ReferentialConstraints.REFERENCED_TABLE_NAME, ReferentialConstraints.UNIQUE_CONSTRAINT_NAME, ReferentialConstraints.UNIQUE_CONSTRAINT_SCHEMA, KeyColumnUsage.COLUMN_NAME).from(new TableLike[]{org.jooq.util.mysql.information_schema.Tables.REFERENTIAL_CONSTRAINTS}).join((TableLike)org.jooq.util.mysql.information_schema.Tables.KEY_COLUMN_USAGE).on(new Condition[]{ReferentialConstraints.CONSTRAINT_SCHEMA.equal(KeyColumnUsage.CONSTRAINT_SCHEMA)}).and(ReferentialConstraints.CONSTRAINT_NAME.equal(KeyColumnUsage.CONSTRAINT_NAME)).where(new Condition[]{ReferentialConstraints.CONSTRAINT_SCHEMA.in(this.getInputSchemata())}).orderBy(KeyColumnUsage.CONSTRAINT_SCHEMA.asc(), KeyColumnUsage.CONSTRAINT_NAME.asc(), KeyColumnUsage.ORDINAL_POSITION.asc()).fetch()) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.getValue(ReferentialConstraints.CONSTRAINT_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.getValue(ReferentialConstraints.UNIQUE_CONSTRAINT_SCHEMA));
            String foreignKey = (String)record.getValue(ReferentialConstraints.CONSTRAINT_NAME);
            String foreignKeyColumn = (String)record.getValue(KeyColumnUsage.COLUMN_NAME);
            String foreignKeyTableName = (String)record.getValue(ReferentialConstraints.TABLE_NAME);
            String referencedKey = (String)record.getValue(ReferentialConstraints.UNIQUE_CONSTRAINT_NAME);
            String referencedTableName = (String)record.getValue(ReferentialConstraints.REFERENCED_TABLE_NAME);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            if (foreignKeyTable == null) continue;
            ColumnDefinition column = foreignKeyTable.getColumn(foreignKeyColumn);
            String key = this.getKeyName(referencedTableName, referencedKey);
            relations2.addForeignKey(foreignKey, key, column, uniqueKeySchema);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r) throws SQLException {
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (String name : this.create().select(Schemata.SCHEMA_NAME).from(new TableLike[]{org.jooq.util.mysql.information_schema.Tables.SCHEMATA}).fetch(Schemata.SCHEMA_NAME)) {
            result.add(new SchemaDefinition((Database)this, name, ""));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(Tables.TABLE_SCHEMA, Tables.TABLE_NAME, Tables.TABLE_COMMENT).from(new TableLike[]{org.jooq.util.mysql.information_schema.Tables.TABLES}).where(new Condition[]{Tables.TABLE_SCHEMA.in(this.getInputSchemata())}).orderBy(Tables.TABLE_SCHEMA, Tables.TABLE_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.TABLE_SCHEMA));
            String name = (String)record.getValue(Tables.TABLE_NAME);
            String comment = (String)record.getValue(Tables.TABLE_COMMENT);
            MySQLTableDefinition table = new MySQLTableDefinition(schema, name, comment);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        Result records = this.create().select(Columns.TABLE_SCHEMA, Columns.COLUMN_COMMENT, Columns.TABLE_NAME, Columns.COLUMN_NAME, Columns.COLUMN_TYPE).from(new TableLike[]{org.jooq.util.mysql.information_schema.Tables.COLUMNS}).where(new Condition[]{Columns.COLUMN_TYPE.like("enum(%)").and(Columns.TABLE_SCHEMA.in(this.getInputSchemata()))}).orderBy(Columns.TABLE_SCHEMA.asc(), Columns.TABLE_NAME.asc(), Columns.COLUMN_NAME.asc()).fetch();
        for (Record record : records) {
            ColumnDefinition columnDefinition;
            SchemaDefinition schema = this.getSchema((String)record.getValue(Columns.TABLE_SCHEMA));
            String comment = (String)record.getValue(Columns.COLUMN_COMMENT);
            String table = (String)record.getValue(Columns.TABLE_NAME);
            String column = (String)record.getValue(Columns.COLUMN_NAME);
            String name = table + "_" + column;
            String columnType = (String)record.getValue(Columns.COLUMN_TYPE);
            TableDefinition tableDefinition = this.getTable(schema, table);
            if (tableDefinition == null || (columnDefinition = tableDefinition.getColumn(column)) == null || this.getConfiguredForcedType(columnDefinition) != null) continue;
            DefaultEnumDefinition definition = new DefaultEnumDefinition(schema, name, comment);
            CSVReader reader = new CSVReader((Reader)new StringReader(columnType.replaceAll("(^enum\\()|(\\)$)", "")), ',', '\'', true);
            for (String string : reader.next()) {
                definition.addLiteral(string);
            }
            result.add(definition);
        }
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        try {
            this.create().fetchCount((Table)Proc.PROC);
        }
        catch (DataAccessException e) {
            log.warn((Object)"Table unavailable", (Object)"The `mysql`.`proc` table is unavailable. Stored procedures cannot be loaded. Check if you have sufficient grants");
            return result;
        }
        Result records = this.create().select(Proc.DB, Proc.NAME, Proc.COMMENT, Proc.PARAM_LIST, Proc.RETURNS, Proc.TYPE).from(new TableLike[]{Proc.PROC}).where(new Condition[]{Proc.DB.in(this.getInputSchemata())}).orderBy(Proc.DB, Proc.NAME).fetch();
        Map groups = records.intoGroups(new Field[]{Proc.DB, Proc.NAME});
        for (Map.Entry entry : groups.entrySet()) {
            Result overloads = (Result)entry.getValue();
            for (int i = 0; i < overloads.size(); ++i) {
                Record record = (Record)overloads.get(i);
                SchemaDefinition schema = this.getSchema((String)record.getValue(Proc.DB));
                String name = (String)record.getValue(Proc.NAME);
                String comment = (String)record.getValue(Proc.COMMENT);
                String params = new String((byte[])record.getValue(Proc.PARAM_LIST));
                String returns = new String((byte[])record.getValue(Proc.RETURNS));
                ProcType type = (ProcType)((Object)record.getValue(Proc.TYPE));
                if (overloads.size() > 1) {
                    result.add(new MySQLRoutineDefinition(schema, name, comment, params, returns, type, "_" + type.name()));
                    continue;
                }
                result.add(new MySQLRoutineDefinition(schema, name, comment, params, returns, type, null));
            }
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.MYSQL);
    }
}

