/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractTypedElementDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.EmbeddableDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.meta.jaxb.SyntheticIdentityType;
import org.jooq.tools.JooqLogger;

public class DefaultColumnDefinition
extends AbstractTypedElementDefinition<TableDefinition>
implements ColumnDefinition {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultColumnDefinition.class);
    private final int position;
    private final boolean isIdentity;
    private transient List<EmbeddableDefinition> replacedByEmbeddables;

    public DefaultColumnDefinition(TableDefinition table, String name, int position, DataTypeDefinition type, boolean isIdentity, String comment) {
        super(table, name, position, type, comment);
        this.position = position;
        boolean bl = this.isIdentity = isIdentity || DefaultColumnDefinition.isSyntheticIdentity(this);
        if (type instanceof DefaultDataTypeDefinition) {
            ((DefaultDataTypeDefinition)type).identity(this.isIdentity);
        }
    }

    private static boolean isSyntheticIdentity(DefaultColumnDefinition column) {
        AbstractDatabase db = (AbstractDatabase)column.getDatabase();
        for (SyntheticIdentityType id : db.getConfiguredSyntheticIdentities()) {
            for (TableDefinition t : db.filter(Collections.singletonList((TableDefinition)column.getContainer()), id.getTables())) {
                Iterator<DefaultColumnDefinition> iterator = db.filter(Collections.singletonList(column), id.getFields()).iterator();
                if (!iterator.hasNext()) continue;
                ColumnDefinition c = iterator.next();
                log.info((Object)"Synthetic identity", (Object)column.getQualifiedName());
                db.markUsed(id);
                return true;
            }
        }
        return false;
    }

    @Override
    public final int getPosition() {
        return this.position;
    }

    @Override
    public final UniqueKeyDefinition getPrimaryKey() {
        return this.getDatabase().getRelations().getPrimaryKey(this);
    }

    @Override
    public final List<UniqueKeyDefinition> getUniqueKeys() {
        return this.getDatabase().getRelations().getUniqueKeys(this);
    }

    @Override
    public final List<UniqueKeyDefinition> getKeys() {
        return this.getDatabase().getRelations().getKeys(this);
    }

    @Override
    public final List<ForeignKeyDefinition> getForeignKeys() {
        return this.getDatabase().getRelations().getForeignKeys(this);
    }

    @Override
    public final boolean isIdentity() {
        return this.isIdentity;
    }
}

