/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.postgres;

import java.sql.SQLException;
import java.util.Arrays;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.WindowFinalStep;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractRoutineDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultParameterDefinition;
import org.jooq.meta.InOutDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.postgres.PostgresDatabase;
import org.jooq.meta.postgres.information_schema.Tables;
import org.jooq.meta.postgres.information_schema.tables.Parameters;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public class PostgresRoutineDefinition
extends AbstractRoutineDefinition {
    private static final JooqLogger log = JooqLogger.getLogger(PostgresRoutineDefinition.class);
    private final String specificName;

    public PostgresRoutineDefinition(Database database, Record record) {
        super(database.getSchema((String)record.get(Tables.ROUTINES.ROUTINE_SCHEMA)), null, (String)record.get(Tables.ROUTINES.ROUTINE_NAME), null, (String)record.get("overload", String.class), (Boolean)record.get("is_agg", Boolean.TYPE));
        if (!Arrays.asList("void", "record").contains(record.get("data_type"))) {
            SchemaDefinition typeSchema = null;
            String schemaName = (String)record.get(Tables.ROUTINES.TYPE_UDT_SCHEMA);
            if (schemaName != null) {
                typeSchema = this.getDatabase().getSchema(schemaName);
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeSchema == null ? database.getSchema((String)record.get(Tables.ROUTINES.ROUTINE_SCHEMA)) : typeSchema, (String)record.get("data_type", String.class), (Number)record.get(Tables.ROUTINES.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(Tables.ROUTINES.NUMERIC_PRECISION), (Number)record.get(Tables.ROUTINES.NUMERIC_SCALE), null, (String)null, DSL.name((String[])new String[]{(String)record.get(Tables.ROUTINES.TYPE_UDT_SCHEMA), (String)record.get(Tables.ROUTINES.TYPE_UDT_NAME)}));
            this.returnValue = new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type);
        }
        this.specificName = (String)record.get(Tables.ROUTINES.SPECIFIC_NAME);
    }

    PostgresRoutineDefinition(Database database, String schema, String name, String specificName) {
        super(database.getSchema(schema), null, name, null, null);
        this.specificName = specificName;
    }

    @Override
    protected void init0() throws SQLException {
        Parameters p = Tables.PARAMETERS;
        WindowFinalStep count = DSL.count().filterWhere(p.PARAMETER_NAME.ne((Field)DSL.inline((String)""))).over((WindowSpecification)DSL.partitionBy((Field[])new Field[]{p.SPECIFIC_NAME, p.PARAMETER_NAME}));
        Field c = count.as("c");
        for (Record record : this.create().select(p.PARAMETER_NAME, p.DATA_TYPE, p.CHARACTER_MAXIMUM_LENGTH, p.NUMERIC_PRECISION, p.NUMERIC_SCALE, p.UDT_SCHEMA, p.UDT_NAME, p.ORDINAL_POSITION, p.PARAMETER_MODE, ((PostgresDatabase)this.getDatabase()).is94() ? p.PARAMETER_DEFAULT : DSL.inline((String)null).as(p.PARAMETER_DEFAULT), (SelectField)c).from((TableLike)p).where(p.SPECIFIC_SCHEMA.equal((Object)this.getSchema().getName())).and(p.SPECIFIC_NAME.equal((Object)this.specificName)).orderBy((OrderField)p.ORDINAL_POSITION.asc())) {
            String parameterName = (String)record.get(p.PARAMETER_NAME);
            String inOut = (String)record.get(p.PARAMETER_MODE);
            SchemaDefinition typeSchema = null;
            String schemaName = (String)record.get(p.UDT_SCHEMA);
            if (schemaName != null) {
                typeSchema = this.getDatabase().getSchema(schemaName);
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeSchema, (String)record.get(p.DATA_TYPE), (Number)record.get(p.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(p.NUMERIC_PRECISION), (Number)record.get(p.NUMERIC_SCALE), null, (String)record.get(p.PARAMETER_DEFAULT), DSL.name((String[])new String[]{(String)record.get(p.UDT_SCHEMA), (String)record.get(p.UDT_NAME)}));
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, parameterName, (Integer)record.get(p.ORDINAL_POSITION), type, record.get(p.PARAMETER_DEFAULT) != null, StringUtils.isBlank((String)parameterName), "", (Integer)record.get(c) > 1 ? (String)record.get(p.ORDINAL_POSITION, String.class) : null);
            this.addParameter(InOutDefinition.getFromString(inOut), parameter);
        }
    }
}

