/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.meta.CheckConstraintDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DefaultForeignKeyDefinition;
import org.jooq.meta.DefaultUniqueKeyDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.Relations;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.tools.JooqLogger;

public class DefaultRelations
implements Relations {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultRelations.class);
    private final Map<Key, UniqueKeyDefinition> primaryKeys = new LinkedHashMap<Key, UniqueKeyDefinition>();
    private final Map<Key, UniqueKeyDefinition> uniqueKeys = new LinkedHashMap<Key, UniqueKeyDefinition>();
    private final Map<Key, ForeignKeyDefinition> foreignKeys = new LinkedHashMap<Key, ForeignKeyDefinition>();
    private final Map<Key, CheckConstraintDefinition> checkConstraints = new LinkedHashMap<Key, CheckConstraintDefinition>();
    private final Set<Key> incompleteKeys = new HashSet<Key>();
    private transient Map<ColumnDefinition, UniqueKeyDefinition> primaryKeysByColumn;
    private transient Map<ColumnDefinition, List<UniqueKeyDefinition>> uniqueKeysByColumn;
    private transient Map<ColumnDefinition, List<ForeignKeyDefinition>> foreignKeysByColumn;
    private transient Map<TableDefinition, List<CheckConstraintDefinition>> checkConstraintsByTable;
    private Map<Key, Integer> nextUkColumnIndex = new HashMap<Key, Integer>();

    public void addPrimaryKey(String keyName, TableDefinition table, ColumnDefinition column) {
        this.addPrimaryKey(keyName, table, column, true);
    }

    public void addPrimaryKey(String keyName, TableDefinition table, ColumnDefinition column, boolean enforced) {
        Key key = DefaultRelations.key(table, keyName);
        if (column == null) {
            log.info((Object)"Ignoring primary key", (Object)(keyName + " (column unavailable)"));
            if (table != null) {
                this.incompleteKeys.add(key);
                this.primaryKeys.remove(key);
                this.uniqueKeys.remove(key);
            }
            return;
        }
        if (this.incompleteKeys.contains(key)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding primary key", (Object)(keyName + " (" + column + ")"));
        }
        UniqueKeyDefinition result = this.getUniqueKey(keyName, table, column, true, enforced);
        result.getKeyColumns().add(column);
    }

    public void addUniqueKey(String keyName, TableDefinition table, ColumnDefinition column) {
        this.addUniqueKey(keyName, table, column, true);
    }

    public void addUniqueKey(String keyName, TableDefinition table, ColumnDefinition column, boolean enforced) {
        Key key = DefaultRelations.key(table, keyName);
        if (column == null) {
            log.info((Object)"Ignoring unique key", (Object)(keyName + " (column unavailable)"));
            if (table != null) {
                this.incompleteKeys.add(key);
                this.uniqueKeys.remove(key);
            }
            return;
        }
        if (this.incompleteKeys.contains(key)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding unique key", (Object)(keyName + " (" + column + ")"));
        }
        UniqueKeyDefinition result = this.getUniqueKey(keyName, table, column, false, enforced);
        result.getKeyColumns().add(column);
    }

    public void overridePrimaryKey(UniqueKeyDefinition key) {
        Key mapKey;
        UniqueKeyDefinition old = null;
        this.primaryKeysByColumn = null;
        this.uniqueKeysByColumn = null;
        Iterator<Map.Entry<Key, UniqueKeyDefinition>> it = this.primaryKeys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Key, UniqueKeyDefinition> entry = it.next();
            if (!entry.getValue().getTable().equals(key.getTable())) continue;
            old = entry.getValue();
            it.remove();
            break;
        }
        if (this.incompleteKeys.contains(mapKey = DefaultRelations.key(key.getTable(), key.getName()))) {
            return;
        }
        this.primaryKeys.put(mapKey, key);
        this.uniqueKeys.put(mapKey, key);
        log.info((Object)"Overriding primary key", (Object)("Table : " + key.getTable() + ", previous key : " + (old == null ? "none" : old.getName()) + ", new key : " + key.getName()));
    }

    private UniqueKeyDefinition getUniqueKey(String keyName, TableDefinition table, ColumnDefinition column, boolean isPK, boolean enforced) {
        Key key = DefaultRelations.key(table, keyName);
        UniqueKeyDefinition result = this.uniqueKeys.get(key);
        if (result == null) {
            result = new DefaultUniqueKeyDefinition(column.getSchema(), keyName, table, isPK, enforced);
            this.uniqueKeys.put(key, result);
            if (isPK) {
                this.primaryKeys.put(key, result);
            }
        }
        return result;
    }

    public void addForeignKey(String foreignKeyName, TableDefinition foreignKeyTable, ColumnDefinition foreignKeyColumn, String uniqueKeyName, TableDefinition uniqueKeyTable) {
        this.addForeignKey(foreignKeyName, foreignKeyTable, foreignKeyColumn, uniqueKeyName, uniqueKeyTable, true);
    }

    public void addForeignKey(String foreignKeyName, TableDefinition foreignKeyTable, ColumnDefinition foreignKeyColumn, String uniqueKeyName, TableDefinition uniqueKeyTable, boolean enforced) {
        UniqueKeyDefinition uk = this.uniqueKeys.get(DefaultRelations.key(uniqueKeyTable, uniqueKeyName));
        Key key = DefaultRelations.key(foreignKeyTable, foreignKeyName);
        if (uk == null) {
            log.info((Object)"Ignoring foreign key", (Object)(uniqueKeyName + " (unique key unavailable)"));
            if (foreignKeyTable != null) {
                this.incompleteKeys.add(key);
                this.foreignKeys.remove(key);
            }
            return;
        }
        this.addForeignKey(foreignKeyName, foreignKeyTable, foreignKeyColumn, uniqueKeyName, uniqueKeyTable, this.getNextUkColumn(key, uk), enforced);
    }

    private ColumnDefinition getNextUkColumn(Key key, UniqueKeyDefinition uk) {
        Integer index = this.nextUkColumnIndex.get(key);
        if (index == null) {
            index = 0;
            this.nextUkColumnIndex.put(key, index);
        } else {
            index = index + 1;
            this.nextUkColumnIndex.put(key, index);
        }
        return index < uk.getKeyColumns().size() ? uk.getKeyColumns().get(index) : null;
    }

    public void addForeignKey(String foreignKeyName, TableDefinition foreignKeyTable, ColumnDefinition foreignKeyColumn, String uniqueKeyName, TableDefinition uniqueKeyTable, ColumnDefinition uniqueKeyColumn, boolean enforced) {
        UniqueKeyDefinition uniqueKey;
        Key key = DefaultRelations.key(foreignKeyTable, foreignKeyName);
        if (foreignKeyColumn == null || uniqueKeyColumn == null) {
            log.info((Object)"Ignoring foreign key", (Object)(foreignKeyColumn + " referencing " + uniqueKeyColumn + " (column unavailable)"));
            if (foreignKeyTable != null) {
                this.incompleteKeys.add(key);
                this.foreignKeys.remove(key);
            }
            return;
        }
        if (this.incompleteKeys.contains(key)) {
            return;
        }
        if (uniqueKeyTable == null) {
            log.info((Object)"Ignoring foreign key", (Object)(foreignKeyName + " (" + foreignKeyColumn + ") referencing " + uniqueKeyName + " (" + uniqueKeyColumn + ") references a schema out of scope for jooq-meta: " + uniqueKeyTable));
            return;
        }
        log.info((Object)"Adding foreign key", (Object)(foreignKeyName + " (" + foreignKeyColumn + ") referencing " + uniqueKeyName + " (" + uniqueKeyColumn + ")"));
        ForeignKeyDefinition foreignKey = this.foreignKeys.get(key);
        if (foreignKey == null && (uniqueKey = this.uniqueKeys.get(DefaultRelations.key(uniqueKeyTable, uniqueKeyName))) != null) {
            foreignKey = new DefaultForeignKeyDefinition(foreignKeyColumn.getSchema(), foreignKeyName, (TableDefinition)foreignKeyColumn.getContainer(), uniqueKey, enforced);
            this.foreignKeys.put(key, foreignKey);
            uniqueKey.getForeignKeys().add(foreignKey);
        }
        if (foreignKey != null) {
            foreignKey.getKeyColumns().add(foreignKeyColumn);
            foreignKey.getReferencedColumns().add(uniqueKeyColumn);
        }
    }

    public void addCheckConstraint(TableDefinition table, CheckConstraintDefinition constraint) {
        this.checkConstraints.put(DefaultRelations.key(table, constraint.getName()), constraint);
    }

    @Override
    public UniqueKeyDefinition getPrimaryKey(ColumnDefinition column) {
        if (this.primaryKeysByColumn == null) {
            this.primaryKeysByColumn = new LinkedHashMap<ColumnDefinition, UniqueKeyDefinition>();
            for (UniqueKeyDefinition primaryKey : this.primaryKeys.values()) {
                for (ColumnDefinition keyColumn : primaryKey.getKeyColumns()) {
                    this.primaryKeysByColumn.put(keyColumn, primaryKey);
                }
            }
        }
        return this.primaryKeysByColumn.get(column);
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys(ColumnDefinition column) {
        List<UniqueKeyDefinition> list;
        if (this.uniqueKeysByColumn == null) {
            this.uniqueKeysByColumn = new LinkedHashMap<ColumnDefinition, List<UniqueKeyDefinition>>();
            for (UniqueKeyDefinition uniqueKey : this.uniqueKeys.values()) {
                for (ColumnDefinition keyColumn : uniqueKey.getKeyColumns()) {
                    List<UniqueKeyDefinition> list2 = this.uniqueKeysByColumn.get(keyColumn);
                    if (list2 == null) {
                        list2 = new ArrayList<UniqueKeyDefinition>();
                        this.uniqueKeysByColumn.put(keyColumn, list2);
                    }
                    list2.add(uniqueKey);
                }
            }
        }
        return (list = this.uniqueKeysByColumn.get(column)) != null ? list : Collections.emptyList();
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys(TableDefinition table) {
        LinkedHashSet<UniqueKeyDefinition> result = new LinkedHashSet<UniqueKeyDefinition>();
        for (ColumnDefinition column : table.getColumns()) {
            result.addAll(this.getUniqueKeys(column));
        }
        return new ArrayList<UniqueKeyDefinition>(result);
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys(SchemaDefinition schema) {
        LinkedHashSet<UniqueKeyDefinition> result = new LinkedHashSet<UniqueKeyDefinition>();
        for (TableDefinition table : schema.getDatabase().getTables(schema)) {
            result.addAll(this.getUniqueKeys(table));
        }
        return new ArrayList<UniqueKeyDefinition>(result);
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys() {
        return new ArrayList<UniqueKeyDefinition>(this.uniqueKeys.values());
    }

    @Override
    public List<ForeignKeyDefinition> getForeignKeys(ColumnDefinition column) {
        List<ForeignKeyDefinition> list;
        if (this.foreignKeysByColumn == null) {
            this.foreignKeysByColumn = new LinkedHashMap<ColumnDefinition, List<ForeignKeyDefinition>>();
            for (ForeignKeyDefinition foreignKey : this.foreignKeys.values()) {
                for (ColumnDefinition keyColumn : foreignKey.getKeyColumns()) {
                    List<ForeignKeyDefinition> list2 = this.foreignKeysByColumn.get(keyColumn);
                    if (list2 == null) {
                        list2 = new ArrayList<ForeignKeyDefinition>();
                        this.foreignKeysByColumn.put(keyColumn, list2);
                    }
                    list2.add(foreignKey);
                }
            }
        }
        return (list = this.foreignKeysByColumn.get(column)) != null ? list : Collections.emptyList();
    }

    @Override
    public List<ForeignKeyDefinition> getForeignKeys(TableDefinition table) {
        LinkedHashSet<ForeignKeyDefinition> result = new LinkedHashSet<ForeignKeyDefinition>();
        for (ColumnDefinition column : table.getColumns()) {
            result.addAll(this.getForeignKeys(column));
        }
        return new ArrayList<ForeignKeyDefinition>(result);
    }

    @Override
    public List<CheckConstraintDefinition> getCheckConstraints(TableDefinition table) {
        List<CheckConstraintDefinition> list;
        if (this.checkConstraintsByTable == null) {
            this.checkConstraintsByTable = new LinkedHashMap<TableDefinition, List<CheckConstraintDefinition>>();
            for (Map.Entry<Key, CheckConstraintDefinition> entry : this.checkConstraints.entrySet()) {
                List<CheckConstraintDefinition> list2 = this.checkConstraintsByTable.get(entry.getKey().table);
                if (list2 == null) {
                    list2 = new ArrayList<CheckConstraintDefinition>();
                    this.checkConstraintsByTable.put(entry.getKey().table, list2);
                }
                list2.add(entry.getValue());
            }
            for (List list2 : this.checkConstraintsByTable.values()) {
                table.getDatabase().sort(list2);
            }
        }
        return (list = this.checkConstraintsByTable.get(table)) != null ? list : Collections.emptyList();
    }

    private static Key key(TableDefinition definition, String keyName) {
        return new Key(definition, keyName);
    }

    private static class Key {
        final TableDefinition table;
        final String keyName;

        Key(TableDefinition table, String keyName) {
            this.table = table;
            this.keyName = keyName;
        }

        public String toString() {
            return "Key [table=" + this.table + ", keyName=" + this.keyName + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.keyName == null ? 0 : this.keyName.hashCode());
            result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName)) {
                return false;
            }
            return !(this.table == null ? other.table != null : !this.table.equals(other.table));
        }
    }
}

