/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.Log;
import org.jooq.SQLDialect;
import org.jooq.codegen.ConstantCatalogVersionProvider;
import org.jooq.codegen.ConstantSchemaVersionProvider;
import org.jooq.codegen.Constants;
import org.jooq.codegen.DefaultGeneratorStrategy;
import org.jooq.codegen.Generator;
import org.jooq.codegen.GeneratorException;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.codegen.JavaGenerator;
import org.jooq.codegen.MatcherStrategy;
import org.jooq.codegen.SQLCatalogVersionProvider;
import org.jooq.codegen.SQLSchemaVersionProvider;
import org.jooq.impl.DSL;
import org.jooq.meta.CatalogVersionProvider;
import org.jooq.meta.Databases;
import org.jooq.meta.SchemaVersionProvider;
import org.jooq.meta.jaxb.CatalogMappingType;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Database;
import org.jooq.meta.jaxb.Generate;
import org.jooq.meta.jaxb.Jdbc;
import org.jooq.meta.jaxb.Logging;
import org.jooq.meta.jaxb.Matchers;
import org.jooq.meta.jaxb.OnError;
import org.jooq.meta.jaxb.Property;
import org.jooq.meta.jaxb.SchemaMappingType;
import org.jooq.meta.jaxb.Strategy;
import org.jooq.meta.jaxb.Target;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.util.jaxb.tools.MiniJAXB;

public class GenerationTool {
    public static final String DEFAULT_TARGET_ENCODING = "UTF-8";
    public static final String DEFAULT_TARGET_DIRECTORY = "target/generated-sources/jooq";
    public static final String DEFAULT_TARGET_PACKAGENAME = "org.jooq.generated";
    private static final JooqLogger log = JooqLogger.getLogger(GenerationTool.class);
    private static final JooqLogger unusedLogger = JooqLogger.getLogger(Unused.class);
    private ClassLoader loader;
    private DataSource dataSource;
    private Connection connection;
    private DSLContext ctx;
    private Boolean autoCommit;
    private boolean close;

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.ctx = DSL.using((Connection)connection);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String[] files;
        JooqLogger.initSimpleFormatter();
        if (args.length > 0) {
            files = args;
        } else {
            String property = System.getProperty("jooq.codegen.configurationFile");
            if (property != null) {
                files = new String[]{property};
            } else {
                log.error((Object)"Usage : GenerationTool <configuration-file>");
                System.exit(-1);
                return;
            }
        }
        for (String file : files) {
            try (InputStream in = GenerationTool.class.getResourceAsStream(file);){
                if (in == null && !file.startsWith("/")) {
                    in = GenerationTool.class.getResourceAsStream("/" + file);
                }
                if (in == null && new File(file).exists()) {
                    in = new FileInputStream(file);
                }
                if (in == null) {
                    log.error((Object)("Cannot find " + file + " on classpath, or in directory " + new File(".").getCanonicalPath()));
                    log.error((Object)"-----------");
                    log.error((Object)"Please be sure it is located");
                    log.error((Object)"  - on the classpath and qualified as a classpath location.");
                    log.error((Object)"  - in the local directory or at a global path in the file system.");
                    System.exit(-1);
                    return;
                }
                Configuration configuration = GenerationTool.load(in);
                GenerationTool.setGlobalLoggingThreshold(configuration);
                log.info((Object)"Initialising properties", (Object)file);
                GenerationTool.generate(configuration);
            }
        }
    }

    @Deprecated
    public static void main(Configuration configuration) throws Exception {
        new GenerationTool().run(configuration);
    }

    public static void generate(String xml) throws Exception {
        new GenerationTool().run(GenerationTool.load(new ByteArrayInputStream(xml.getBytes(DEFAULT_TARGET_ENCODING))));
    }

    public static void generate(Configuration configuration) throws Exception {
        new GenerationTool().run(configuration);
    }

    public void run(Configuration configuration) throws Exception {
        try {
            this.run0(configuration);
        }
        catch (Exception e) {
            OnError onError = configuration.getOnError();
            if (onError == null) {
                onError = OnError.FAIL;
            }
            switch (onError) {
                case SILENT: {
                    break;
                }
                case LOG: {
                    log.warn((Object)"Code generation failed", (Throwable)e);
                    break;
                }
                case FAIL: {
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run0(Configuration configuration) throws Exception {
        if (configuration.getLogging() != null) {
            GenerationTool.setGlobalLoggingThreshold(configuration);
        } else {
            String property = System.getProperty("jooq.codegen.logging");
            if (property != null) {
                try {
                    Logging.valueOf((String)property);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)"Unsupported property", (Object)("Unsupported value for system property jooq.codegen.logging: " + property + ". Supported values include: " + Arrays.asList(Logging.values())));
                }
            }
        }
        if (Boolean.getBoolean("jooq.codegen.skip")) {
            log.info((Object)"Skipping jOOQ code generation");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Input configuration", (Object)("" + configuration));
        }
        if (configuration.getBasedir() == null) {
            configuration.setBasedir(new File(".").getAbsolutePath());
        }
        Jdbc j = configuration.getJdbc();
        org.jooq.meta.jaxb.Generator g = configuration.getGenerator();
        if (g == null) {
            throw new GeneratorException("The <generator/> tag is mandatory. For details, see http://www.jooq.org/xsd/jooq-codegen-3.15.0.xsd");
        }
        if (g.getDatabase() == null) {
            g.setDatabase(new Database());
        }
        Database d = g.getDatabase();
        String databaseName = GenerationTool.trim(d.getName());
        if (g.getGenerate() == null) {
            g.setGenerate(new Generate());
        }
        if (g.getStrategy() == null) {
            g.setStrategy(new Strategy());
        }
        if (g.getTarget() == null) {
            g.setTarget(new Target());
        }
        Locale locale = Locale.getDefault();
        if (!StringUtils.isBlank((String)g.getTarget().getLocale())) {
            locale = Locale.forLanguageTag(g.getTarget().getLocale());
        }
        org.jooq.meta.Database database = null;
        try {
            GeneratorStrategy strategy;
            if (this.connection == null) {
                this.close = true;
                if (this.dataSource != null) {
                    this.setConnection(this.dataSource.getConnection());
                } else {
                    String url = System.getProperty("jooq.codegen.jdbc.url");
                    if (url != null) {
                        String a;
                        if ((j = (Jdbc)StringUtils.defaultIfNull((Object)j, (Object)new Jdbc())).getDriver() == null) {
                            j.setDriver(System.getProperty("jooq.codegen.jdbc.driver"));
                        }
                        if (j.getUrl() == null) {
                            j.setUrl(url);
                        }
                        if (j.getUser() == null) {
                            j.setUser(System.getProperty("jooq.codegen.jdbc.user"));
                        }
                        if (j.getUsername() == null) {
                            j.setUsername(System.getProperty("jooq.codegen.jdbc.username"));
                        }
                        if (j.getPassword() == null) {
                            j.setPassword(System.getProperty("jooq.codegen.jdbc.password"));
                        }
                        if (j.isAutoCommit() == null && (a = System.getProperty("jooq.codegen.jdbc.autoCommit")) != null) {
                            j.setAutoCommit(Boolean.valueOf(a));
                        }
                    }
                    if (j != null) {
                        try {
                            Class<?> driver = this.loadClass(this.driverClass(j));
                            Properties properties = this.properties(j.getProperties());
                            if (!properties.containsKey("user")) {
                                properties.put("user", StringUtils.defaultString((String)StringUtils.defaultString((String)j.getUser(), (String)j.getUsername())));
                            }
                            if (!properties.containsKey("password")) {
                                properties.put("password", StringUtils.defaultString((String)j.getPassword()));
                            }
                            this.setConnection(((Driver)driver.newInstance()).connect(StringUtils.defaultString((String)j.getUrl()), properties));
                        }
                        catch (Exception e) {
                            if (databaseName != null && (databaseName.contains("DDLDatabase") || databaseName.contains("XMLDatabase") || databaseName.contains("JPADatabase"))) {
                                log.warn((Object)"Error while connecting to database. Note that file based database implementations do not need a <jdbc/> configuration in the code generator.", (Throwable)e);
                            }
                            throw e;
                        }
                    }
                }
            }
            j = (Jdbc)StringUtils.defaultIfNull((Object)j, (Object)new Jdbc());
            if (this.connection != null && j.isAutoCommit() != null) {
                this.autoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(j.isAutoCommit());
            }
            Class<JavaGenerator> generatorClass = !StringUtils.isBlank((String)g.getName()) ? this.loadClass(GenerationTool.trim(g.getName())) : JavaGenerator.class;
            Generator generator = (Generator)generatorClass.newInstance();
            Matchers matchers = g.getStrategy().getMatchers();
            if (matchers != null) {
                strategy = new MatcherStrategy(matchers);
                if (g.getStrategy().getName() != null) {
                    if (!DefaultGeneratorStrategy.class.getName().equals(g.getStrategy().getName())) {
                        log.warn((Object)("WARNING: Matchers take precedence over custom strategy. Strategy ignored: " + g.getStrategy().getName()));
                    }
                    g.getStrategy().setName(null);
                }
            } else {
                Class<DefaultGeneratorStrategy> strategyClass = !StringUtils.isBlank((String)g.getStrategy().getName()) ? this.loadClass(GenerationTool.trim(g.getStrategy().getName())) : DefaultGeneratorStrategy.class;
                strategy = (GeneratorStrategy)strategyClass.newInstance();
            }
            generator.setStrategy(strategy);
            Class<?> databaseClass = !StringUtils.isBlank((String)databaseName) ? this.loadClass(databaseName) : (this.connection != null ? this.databaseClass(this.connection) : this.databaseClass(j));
            database = (org.jooq.meta.Database)databaseClass.newInstance();
            database.setBasedir(configuration.getBasedir());
            database.setProperties(this.properties(d.getProperties()));
            database.setOnError(configuration.getOnError());
            List catalogs = d.getCatalogs();
            List schemata = d.getSchemata();
            boolean catalogsEmpty = catalogs.isEmpty();
            boolean schemataEmpty = schemata.isEmpty();
            if (catalogsEmpty) {
                if (StringUtils.isBlank((String)d.getInputCatalog()) && !StringUtils.isBlank((String)d.getOutputCatalog())) {
                    log.warn((Object)"WARNING: /configuration/generator/database/outputCatalog must be paired with /configuration/generator/database/inputCatalog");
                }
                CatalogMappingType catalog = new CatalogMappingType();
                catalog.setInputCatalog(GenerationTool.trim(d.getInputCatalog()));
                catalog.setOutputCatalog(GenerationTool.trim(d.getOutputCatalog()));
                catalog.setOutputCatalogToDefault(d.isOutputCatalogToDefault());
                catalogs.add(catalog);
                if (!StringUtils.isBlank((String)catalog.getInputCatalog())) {
                    catalogsEmpty = false;
                }
                if (schemataEmpty) {
                    if (StringUtils.isBlank((String)d.getInputSchema()) && !StringUtils.isBlank((String)d.getOutputSchema())) {
                        log.warn((Object)"WARNING: /configuration/generator/database/outputSchema must be paired with /configuration/generator/database/inputSchema");
                    }
                    SchemaMappingType schema = new SchemaMappingType();
                    schema.setInputSchema(GenerationTool.trim(d.getInputSchema()));
                    schema.setOutputSchema(GenerationTool.trim(d.getOutputSchema()));
                    schema.setOutputSchemaToDefault(d.isOutputSchemaToDefault());
                    catalog.getSchemata().add(schema);
                    if (!StringUtils.isBlank((String)schema.getInputSchema())) {
                        schemataEmpty = false;
                    }
                } else {
                    catalog.getSchemata().addAll(schemata);
                    if (!StringUtils.isBlank((String)d.getInputSchema())) {
                        log.warn((Object)"WARNING: Cannot combine configuration properties /configuration/generator/database/inputSchema and /configuration/generator/database/schemata");
                    }
                    if (!StringUtils.isBlank((String)d.getOutputSchema())) {
                        log.warn((Object)"WARNING: Cannot combine configuration properties /configuration/generator/database/outputSchema and /configuration/generator/database/schemata");
                    }
                }
            } else {
                if (!StringUtils.isBlank((String)d.getInputCatalog())) {
                    log.warn((Object)"WARNING: Cannot combine configuration properties /configuration/generator/database/inputCatalog and /configuration/generator/database/catalogs");
                }
                if (!StringUtils.isBlank((String)d.getOutputCatalog())) {
                    log.warn((Object)"WARNING: Cannot combine configuration properties /configuration/generator/database/outputCatalog and /configuration/generator/database/catalogs");
                }
                if (!StringUtils.isBlank((String)d.getInputSchema())) {
                    log.warn((Object)"WARNING: Cannot combine configuration properties /configuration/generator/database/inputSchema and /configuration/generator/database/catalogs");
                }
                if (!StringUtils.isBlank((String)d.getOutputSchema())) {
                    log.warn((Object)"WARNING: Cannot combine configuration properties /configuration/generator/database/outputSchema and /configuration/generator/database/catalogs");
                }
                if (!schemataEmpty) {
                    log.warn((Object)"WARNING: Cannot combine configuration properties /configuration/generator/database/catalogs and /configuration/generator/database/schemata");
                }
            }
            for (CatalogMappingType catalog : catalogs) {
                if ("".equals(catalog.getOutputCatalog())) {
                    log.warn((Object)"WARNING: Empty <outputCatalog/> should not be used to model default outputCatalogs. Use <outputCatalogToDefault>true</outputCatalogToDefault>, instead. See also: https://github.com/jOOQ/jOOQ/issues/3018");
                }
                if (Boolean.TRUE.equals(catalog.isOutputCatalogToDefault())) {
                    catalog.setOutputCatalog("");
                } else if (catalog.getOutputCatalog() == null) {
                    catalog.setOutputCatalog(GenerationTool.trim(catalog.getInputCatalog()));
                }
                for (SchemaMappingType schema : catalog.getSchemata()) {
                    if (catalogsEmpty && schemataEmpty && StringUtils.isBlank((String)schema.getInputSchema())) {
                        if (!StringUtils.isBlank((String)j.getSchema())) {
                            log.warn((Object)"WARNING: The configuration property jdbc.Schema is deprecated and will be removed in the future. Use /configuration/generator/database/inputSchema instead");
                        }
                        schema.setInputSchema(GenerationTool.trim(j.getSchema()));
                    }
                    if ("".equals(schema.getOutputSchema())) {
                        log.warn((Object)"WARNING: Empty <outputSchema/> should not be used to model default outputSchemas. Use <outputSchemaToDefault>true</outputSchemaToDefault>, instead. See also: https://github.com/jOOQ/jOOQ/issues/3018");
                    }
                    if (Boolean.TRUE.equals(schema.isOutputSchemaToDefault())) {
                        schema.setOutputSchema("");
                        continue;
                    }
                    if (schema.getOutputSchema() != null) continue;
                    schema.setOutputSchema(GenerationTool.trim(schema.getInputSchema()));
                }
            }
            if (catalogsEmpty) {
                log.info((Object)"No <inputCatalog/> was provided. Generating ALL available catalogs instead.");
            }
            if (catalogsEmpty && schemataEmpty) {
                log.info((Object)"No <inputSchema/> was provided. Generating ALL available schemata instead.");
            }
            database.setConnection(this.connection);
            database.setConfiguredCatalogs(catalogs);
            database.setConfiguredSchemata(schemata);
            database.setIncludes(new String[]{StringUtils.defaultString((String)d.getIncludes())});
            database.setExcludes(new String[]{StringUtils.defaultString((String)d.getExcludes())});
            database.setIncludeExcludeColumns(Boolean.TRUE.equals(d.isIncludeExcludeColumns()));
            database.setIncludeExcludePackageRoutines(Boolean.TRUE.equals(d.isIncludeExcludePackageRoutines()));
            database.setIncludeForeignKeys(!Boolean.FALSE.equals(d.isIncludeForeignKeys()));
            database.setIncludePackages(!Boolean.FALSE.equals(d.isIncludePackages()));
            database.setIncludePackageRoutines(!Boolean.FALSE.equals(d.isIncludePackageRoutines()));
            database.setIncludePackageUDTs(!Boolean.FALSE.equals(d.isIncludePackageUDTs()));
            database.setIncludePackageConstants(!Boolean.FALSE.equals(d.isIncludePackageConstants()));
            database.setIncludeIndexes(!Boolean.FALSE.equals(d.isIncludeIndexes()));
            database.setIncludeCheckConstraints(!Boolean.FALSE.equals(d.isIncludeCheckConstraints()));
            database.setIncludeSystemTables(Boolean.TRUE.equals(d.isIncludeSystemTables()));
            database.setIncludeSystemIndexes(Boolean.TRUE.equals(d.isIncludeSystemIndexes()));
            database.setIncludeSystemCheckConstraints(Boolean.TRUE.equals(d.isIncludeSystemCheckConstraints()));
            database.setIncludeSystemSequences(Boolean.TRUE.equals(d.isIncludeSystemSequences()));
            database.setIncludeSystemUDTs(Boolean.TRUE.equals(d.isIncludeSystemUDTs()));
            database.setIncludeInvisibleColumns(!Boolean.FALSE.equals(d.isIncludeInvisibleColumns()));
            database.setIncludePrimaryKeys(!Boolean.FALSE.equals(d.isIncludePrimaryKeys()));
            database.setIncludeRoutines(!Boolean.FALSE.equals(d.isIncludeRoutines()));
            database.setIncludeDomains(!Boolean.FALSE.equals(d.isIncludeDomains()));
            database.setIncludeSequences(!Boolean.FALSE.equals(d.isIncludeSequences()));
            database.setIncludeTables(!Boolean.FALSE.equals(d.isIncludeTables()));
            database.setIncludeEmbeddables(!Boolean.FALSE.equals(d.isIncludeEmbeddables()));
            database.setIncludeTriggerRoutines(Boolean.TRUE.equals(d.isIncludeTriggerRoutines()));
            database.setIncludeUDTs(!Boolean.FALSE.equals(d.isIncludeUDTs()));
            database.setIncludeUniqueKeys(!Boolean.FALSE.equals(d.isIncludeUniqueKeys()));
            database.setForceIntegerTypesOnZeroScaleDecimals(!Boolean.FALSE.equals(d.isForceIntegerTypesOnZeroScaleDecimals()));
            database.setRecordVersionFields(new String[]{StringUtils.defaultString((String)d.getRecordVersionFields())});
            database.setRecordTimestampFields(new String[]{StringUtils.defaultString((String)d.getRecordTimestampFields())});
            database.setSyntheticPrimaryKeys(new String[]{StringUtils.defaultString((String)d.getSyntheticPrimaryKeys())});
            database.setOverridePrimaryKeys(new String[]{StringUtils.defaultString((String)d.getOverridePrimaryKeys())});
            database.setSyntheticIdentities(new String[]{StringUtils.defaultString((String)d.getSyntheticIdentities())});
            database.setConfiguredCustomTypes(d.getCustomTypes());
            database.setConfiguredEnumTypes(d.getEnumTypes());
            database.setConfiguredForcedTypes(d.getForcedTypes());
            database.setConfiguredEmbeddables(d.getEmbeddables());
            database.setConfiguredComments(d.getComments());
            database.setConfiguredSyntheticObjects(d.getSyntheticObjects());
            database.setEmbeddablePrimaryKeys(d.getEmbeddablePrimaryKeys());
            database.setEmbeddableUniqueKeys(d.getEmbeddableUniqueKeys());
            database.setEmbeddableDomains(d.getEmbeddableDomains());
            database.setLogSlowQueriesAfterSeconds(((Integer)StringUtils.defaultIfNull((Object)d.getLogSlowQueriesAfterSeconds(), (Object)5)).intValue());
            database.setLogSlowResultsAfterSeconds(((Integer)StringUtils.defaultIfNull((Object)d.getLogSlowResultsAfterSeconds(), (Object)5)).intValue());
            if (d.getRegexFlags() != null) {
                database.setRegexFlags(d.getRegexFlags());
                if (strategy instanceof MatcherStrategy) {
                    ((MatcherStrategy)strategy).getPatterns().setRegexFlags(d.getRegexFlags());
                }
            }
            database.setRegexMatchesPartialQualification(!Boolean.FALSE.equals(d.isRegexMatchesPartialQualification()));
            database.setSqlMatchesPartialQualification(!Boolean.FALSE.equals(d.isSqlMatchesPartialQualification()));
            SchemaVersionProvider svp = null;
            CatalogVersionProvider cvp = null;
            if (!StringUtils.isBlank((String)d.getSchemaVersionProvider())) {
                try {
                    svp = (SchemaVersionProvider)Class.forName(d.getSchemaVersionProvider()).newInstance();
                    log.info((Object)("Using custom schema version provider : " + svp));
                }
                catch (Exception ignore) {
                    if (d.getSchemaVersionProvider().toLowerCase(locale).startsWith("select")) {
                        svp = new SQLSchemaVersionProvider(this.connection, d.getSchemaVersionProvider());
                        log.info((Object)("Using SQL schema version provider : " + d.getSchemaVersionProvider()));
                    }
                    svp = new ConstantSchemaVersionProvider(d.getSchemaVersionProvider());
                }
            }
            if (!StringUtils.isBlank((String)d.getCatalogVersionProvider())) {
                try {
                    cvp = (CatalogVersionProvider)Class.forName(d.getCatalogVersionProvider()).newInstance();
                    log.info((Object)("Using custom catalog version provider : " + cvp));
                }
                catch (Exception ignore) {
                    if (d.getCatalogVersionProvider().toLowerCase(locale).startsWith("select")) {
                        cvp = new SQLCatalogVersionProvider(this.connection, d.getCatalogVersionProvider());
                        log.info((Object)("Using SQL catalog version provider : " + d.getCatalogVersionProvider()));
                    }
                    cvp = new ConstantCatalogVersionProvider(d.getCatalogVersionProvider());
                }
            }
            if (svp == null) {
                svp = new ConstantSchemaVersionProvider(null);
            }
            if (cvp == null) {
                cvp = new ConstantCatalogVersionProvider(null);
            }
            database.setSchemaVersionProvider(svp);
            database.setCatalogVersionProvider(cvp);
            if (!StringUtils.isBlank((String)d.getOrderProvider())) {
                Class<?> orderProvider = Class.forName(d.getOrderProvider());
                if (Comparator.class.isAssignableFrom(orderProvider)) {
                    database.setOrderProvider((Comparator)orderProvider.newInstance());
                } else {
                    log.warn((Object)("Order provider must be of type java.util.Comparator: " + orderProvider));
                }
            }
            if (d.getEnumTypes().size() > 0) {
                log.warn((Object)"DEPRECATED", (Object)"The configuration property /configuration/generator/database/enumTypes is experimental and deprecated and will be removed in the future.");
            }
            if (Boolean.TRUE.equals(d.isDateAsTimestamp())) {
                log.warn((Object)"DEPRECATED", (Object)"The configuration property /configuration/generator/database/dateAsTimestamp is deprecated as it is superseded by custom bindings and converters. It will thus be removed in the future.");
            }
            if (d.isDateAsTimestamp() != null) {
                database.setDateAsTimestamp(d.isDateAsTimestamp().booleanValue());
            }
            if (g.getGenerate().isJavaTimeTypes() != null) {
                database.setJavaTimeTypes(g.getGenerate().isJavaTimeTypes().booleanValue());
            }
            if (d.isUnsignedTypes() != null) {
                database.setSupportsUnsignedTypes(d.isUnsignedTypes().booleanValue());
            }
            if (d.isIntegerDisplayWidths() != null) {
                database.setIntegerDisplayWidths(d.isIntegerDisplayWidths().booleanValue());
            }
            if (d.isIgnoreProcedureReturnValues() != null) {
                database.setIgnoreProcedureReturnValues(d.isIgnoreProcedureReturnValues().booleanValue());
            }
            if (Boolean.TRUE.equals(d.isIgnoreProcedureReturnValues())) {
                log.warn((Object)"DEPRECATED", (Object)"The <ignoreProcedureReturnValues/> flag is deprecated and used for backwards-compatibility only. It will be removed in the future.");
            }
            if (StringUtils.isBlank((String)g.getTarget().getPackageName())) {
                g.getTarget().setPackageName(DEFAULT_TARGET_PACKAGENAME);
            }
            if (StringUtils.isBlank((String)g.getTarget().getDirectory())) {
                g.getTarget().setDirectory(DEFAULT_TARGET_DIRECTORY);
            }
            if (StringUtils.isBlank((String)g.getTarget().getEncoding())) {
                g.getTarget().setEncoding(DEFAULT_TARGET_ENCODING);
            }
            if (!new File(g.getTarget().getDirectory()).isAbsolute()) {
                g.getTarget().setDirectory(new File(configuration.getBasedir(), g.getTarget().getDirectory()).getCanonicalPath());
            }
            generator.setTargetPackage(g.getTarget().getPackageName());
            generator.setTargetDirectory(g.getTarget().getDirectory());
            generator.setTargetEncoding(g.getTarget().getEncoding());
            if (g.getTarget().isClean() != null) {
                generator.setTargetClean(g.getTarget().isClean());
            }
            generator.setTargetLocale(locale);
            if (g.getGenerate().isIndexes() != null) {
                generator.setGenerateIndexes(g.getGenerate().isIndexes());
            }
            if (g.getGenerate().isRelations() != null) {
                generator.setGenerateRelations(g.getGenerate().isRelations());
            }
            if (g.getGenerate().isImplicitJoinPathsToOne() != null) {
                generator.setGenerateImplicitJoinPathsToOne(g.getGenerate().isImplicitJoinPathsToOne());
            }
            if (g.getGenerate().isDeprecated() != null) {
                generator.setGenerateDeprecated(g.getGenerate().isDeprecated());
            }
            if (g.getGenerate().isDeprecationOnUnknownTypes() != null) {
                generator.setGenerateDeprecationOnUnknownTypes(g.getGenerate().isDeprecationOnUnknownTypes());
            }
            if (g.getGenerate().isInstanceFields() != null) {
                generator.setGenerateInstanceFields(g.getGenerate().isInstanceFields());
            }
            if (g.getGenerate().getVisibilityModifier() != null) {
                generator.setGenerateVisibilityModifier(g.getGenerate().getVisibilityModifier());
            }
            if (g.getGenerate().isGeneratedAnnotation() != null) {
                generator.setGenerateGeneratedAnnotation(g.getGenerate().isGeneratedAnnotation());
            }
            if (g.getGenerate().getGeneratedAnnotationType() != null) {
                generator.setGenerateGeneratedAnnotationType(g.getGenerate().getGeneratedAnnotationType());
            }
            if (g.getGenerate().isGeneratedAnnotationDate() != null) {
                generator.setGenerateGeneratedAnnotationDate(g.getGenerate().isGeneratedAnnotationDate());
            }
            if (g.getGenerate().isNonnullAnnotation() != null) {
                generator.setGenerateNonnullAnnotation(g.getGenerate().isNonnullAnnotation());
            }
            if (g.getGenerate().getNonnullAnnotationType() != null) {
                generator.setGeneratedNonnullAnnotationType(g.getGenerate().getNonnullAnnotationType());
            }
            if (g.getGenerate().isNullableAnnotation() != null) {
                generator.setGenerateNullableAnnotation(g.getGenerate().isNullableAnnotation());
            }
            if (g.getGenerate().getNullableAnnotationType() != null) {
                generator.setGeneratedNullableAnnotationType(g.getGenerate().getNullableAnnotationType());
            }
            if (g.getGenerate().isConstructorPropertiesAnnotation() != null) {
                generator.setGenerateConstructorPropertiesAnnotation(g.getGenerate().isConstructorPropertiesAnnotation());
            }
            if (g.getGenerate().isConstructorPropertiesAnnotationOnPojos() != null) {
                generator.setGenerateConstructorPropertiesAnnotationOnPojos(g.getGenerate().isConstructorPropertiesAnnotationOnPojos());
            }
            if (g.getGenerate().isConstructorPropertiesAnnotationOnRecords() != null) {
                generator.setGenerateConstructorPropertiesAnnotationOnRecords(g.getGenerate().isConstructorPropertiesAnnotationOnRecords());
            }
            if (g.getGenerate().isRoutines() != null) {
                generator.setGenerateRoutines(g.getGenerate().isRoutines());
            }
            if (g.getGenerate().isSequences() != null) {
                generator.setGenerateSequences(g.getGenerate().isSequences());
            }
            if (g.getGenerate().isSequenceFlags() != null) {
                generator.setGenerateSequenceFlags(g.getGenerate().isSequenceFlags());
            }
            if (g.getGenerate().isUdts() != null) {
                generator.setGenerateUDTs(g.getGenerate().isUdts());
            }
            if (g.getGenerate().isTables() != null) {
                generator.setGenerateTables(g.getGenerate().isTables());
            }
            if (g.getGenerate().isEmbeddables() != null) {
                generator.setGenerateEmbeddables(g.getGenerate().isEmbeddables());
            }
            if (g.getGenerate().isRecords() != null) {
                generator.setGenerateRecords(g.getGenerate().isRecords());
            }
            if (g.getGenerate().isRecordsImplementingRecordN() != null) {
                generator.setGenerateRecordsImplementingRecordN(g.getGenerate().isRecordsImplementingRecordN());
            }
            if (g.getGenerate().isEnumsAsScalaSealedTraits() != null) {
                generator.setGenerateEnumsAsScalaSealedTraits(g.getGenerate().isEnumsAsScalaSealedTraits());
            }
            if (g.getGenerate().isPojos() != null) {
                generator.setGeneratePojos(g.getGenerate().isPojos());
            }
            if (g.getGenerate().isPojosAsJavaRecordClasses() != null) {
                generator.setGeneratePojosAsJavaRecordClasses(g.getGenerate().isPojosAsJavaRecordClasses());
            }
            if (g.getGenerate().isPojosAsScalaCaseClasses() != null) {
                generator.setGeneratePojosAsScalaCaseClasses(g.getGenerate().isPojosAsScalaCaseClasses());
            }
            if (g.getGenerate().isPojosAsKotlinDataClasses() != null) {
                generator.setGeneratePojosAsKotlinDataClasses(g.getGenerate().isPojosAsKotlinDataClasses());
            }
            if (g.getGenerate().isImmutablePojos() != null) {
                generator.setGenerateImmutablePojos(g.getGenerate().isImmutablePojos());
            }
            if (g.getGenerate().isSerializablePojos() != null) {
                generator.setGenerateSerializablePojos(g.getGenerate().isSerializablePojos());
            }
            if (g.getGenerate().isInterfaces() != null) {
                generator.setGenerateInterfaces(g.getGenerate().isInterfaces());
            }
            if (g.getGenerate().isImmutableInterfaces() != null) {
                generator.setGenerateImmutableInterfaces(g.getGenerate().isImmutableInterfaces());
            }
            if (g.getGenerate().isSerializableInterfaces() != null) {
                generator.setGenerateSerializableInterfaces(g.getGenerate().isSerializableInterfaces());
            }
            if (g.getGenerate().isDaos() != null) {
                generator.setGenerateDaos(g.getGenerate().isDaos());
            }
            if (g.getGenerate().isJpaAnnotations() != null) {
                generator.setGenerateJPAAnnotations(g.getGenerate().isJpaAnnotations());
            }
            if (g.getGenerate().getJpaVersion() != null) {
                generator.setGenerateJPAVersion(g.getGenerate().getJpaVersion());
            }
            if (g.getGenerate().isValidationAnnotations() != null) {
                generator.setGenerateValidationAnnotations(g.getGenerate().isValidationAnnotations());
            }
            if (g.getGenerate().isSpringAnnotations() != null) {
                generator.setGenerateSpringAnnotations(g.getGenerate().isSpringAnnotations());
            }
            if (g.getGenerate().isKotlinSetterJvmNameAnnotationsOnIsPrefix() != null) {
                generator.setGenerateKotlinSetterJvmNameAnnotationsOnIsPrefix(g.getGenerate().isKotlinSetterJvmNameAnnotationsOnIsPrefix());
            }
            if (g.getGenerate().getGeneratedSerialVersionUID() != null) {
                generator.setGenerateGeneratedSerialVersionUID(g.getGenerate().getGeneratedSerialVersionUID());
            }
            if (g.getGenerate().getMaxMembersPerInitialiser() != null) {
                generator.setMaxMembersPerInitialiser(g.getGenerate().getMaxMembersPerInitialiser());
            }
            if (g.getGenerate().isQueues() != null) {
                generator.setGenerateQueues(g.getGenerate().isQueues());
            }
            if (g.getGenerate().isLinks() != null) {
                generator.setGenerateLinks(g.getGenerate().isLinks());
            }
            if (g.getGenerate().isKeys() != null) {
                generator.setGenerateKeys(g.getGenerate().isKeys());
            }
            if (g.getGenerate().isGlobalObjectReferences() != null) {
                generator.setGenerateGlobalObjectReferences(g.getGenerate().isGlobalObjectReferences());
            }
            if (g.getGenerate().isGlobalCatalogReferences() != null) {
                generator.setGenerateGlobalCatalogReferences(g.getGenerate().isGlobalCatalogReferences());
            }
            if (g.getGenerate().isGlobalDomainReferences() != null) {
                generator.setGenerateGlobalDomainReferences(g.getGenerate().isGlobalDomainReferences());
            }
            if (g.getGenerate().isGlobalSchemaReferences() != null) {
                generator.setGenerateGlobalSchemaReferences(g.getGenerate().isGlobalSchemaReferences());
            }
            if (g.getGenerate().isGlobalRoutineReferences() != null) {
                generator.setGenerateGlobalRoutineReferences(g.getGenerate().isGlobalRoutineReferences());
            }
            if (g.getGenerate().isGlobalSequenceReferences() != null) {
                generator.setGenerateGlobalSequenceReferences(g.getGenerate().isGlobalSequenceReferences());
            }
            if (g.getGenerate().isGlobalTableReferences() != null) {
                generator.setGenerateGlobalTableReferences(g.getGenerate().isGlobalTableReferences());
            }
            if (g.getGenerate().isGlobalUDTReferences() != null) {
                generator.setGenerateGlobalUDTReferences(g.getGenerate().isGlobalUDTReferences());
            }
            if (g.getGenerate().isGlobalQueueReferences() != null) {
                generator.setGenerateGlobalQueueReferences(g.getGenerate().isGlobalQueueReferences());
            }
            if (g.getGenerate().isGlobalLinkReferences() != null) {
                generator.setGenerateGlobalLinkReferences(g.getGenerate().isGlobalLinkReferences());
            }
            if (g.getGenerate().isGlobalKeyReferences() != null) {
                generator.setGenerateGlobalKeyReferences(g.getGenerate().isGlobalKeyReferences());
            }
            if (g.getGenerate().isGlobalIndexReferences() != null) {
                generator.setGenerateGlobalIndexReferences(g.getGenerate().isGlobalIndexReferences());
            }
            if (g.getGenerate().isJavadoc() != null) {
                generator.setGenerateJavadoc(g.getGenerate().isJavadoc());
            }
            if (g.getGenerate().isComments() != null) {
                generator.setGenerateComments(g.getGenerate().isComments());
            }
            if (g.getGenerate().isCommentsOnAttributes() != null) {
                generator.setGenerateCommentsOnAttributes(g.getGenerate().isCommentsOnAttributes());
            }
            if (g.getGenerate().isCommentsOnCatalogs() != null) {
                generator.setGenerateCommentsOnCatalogs(g.getGenerate().isCommentsOnCatalogs());
            }
            if (g.getGenerate().isCommentsOnColumns() != null) {
                generator.setGenerateCommentsOnColumns(g.getGenerate().isCommentsOnColumns());
            }
            if (g.getGenerate().isCommentsOnKeys() != null) {
                generator.setGenerateCommentsOnKeys(g.getGenerate().isCommentsOnKeys());
            }
            if (g.getGenerate().isCommentsOnLinks() != null) {
                generator.setGenerateCommentsOnLinks(g.getGenerate().isCommentsOnLinks());
            }
            if (g.getGenerate().isCommentsOnPackages() != null) {
                generator.setGenerateCommentsOnPackages(g.getGenerate().isCommentsOnPackages());
            }
            if (g.getGenerate().isCommentsOnParameters() != null) {
                generator.setGenerateCommentsOnParameters(g.getGenerate().isCommentsOnParameters());
            }
            if (g.getGenerate().isCommentsOnQueues() != null) {
                generator.setGenerateCommentsOnQueues(g.getGenerate().isCommentsOnQueues());
            }
            if (g.getGenerate().isCommentsOnRoutines() != null) {
                generator.setGenerateCommentsOnRoutines(g.getGenerate().isCommentsOnRoutines());
            }
            if (g.getGenerate().isCommentsOnSchemas() != null) {
                generator.setGenerateCommentsOnSchemas(g.getGenerate().isCommentsOnSchemas());
            }
            if (g.getGenerate().isCommentsOnSequences() != null) {
                generator.setGenerateCommentsOnSequences(g.getGenerate().isCommentsOnSequences());
            }
            if (g.getGenerate().isCommentsOnTables() != null) {
                generator.setGenerateCommentsOnTables(g.getGenerate().isCommentsOnTables());
            }
            if (g.getGenerate().isCommentsOnEmbeddables() != null) {
                generator.setGenerateCommentsOnEmbeddables(g.getGenerate().isCommentsOnEmbeddables());
            }
            if (g.getGenerate().isCommentsOnUDTs() != null) {
                generator.setGenerateCommentsOnUDTs(g.getGenerate().isCommentsOnUDTs());
            }
            if (g.getGenerate().isSources() != null) {
                generator.setGenerateSources(g.getGenerate().isSources());
            }
            if (g.getGenerate().isSourcesOnViews() != null) {
                generator.setGenerateSourcesOnViews(g.getGenerate().isSourcesOnViews());
            }
            if (g.getGenerate().isFluentSetters() != null) {
                generator.setGenerateFluentSetters(g.getGenerate().isFluentSetters());
            }
            if (g.getGenerate().isJavaBeansGettersAndSetters() != null) {
                generator.setGenerateJavaBeansGettersAndSetters(g.getGenerate().isJavaBeansGettersAndSetters());
            }
            if (g.getGenerate().isVarargSetters() != null) {
                generator.setGenerateVarargsSetters(g.getGenerate().isVarargSetters());
            }
            if (g.getGenerate().isPojosEqualsAndHashCode() != null) {
                generator.setGeneratePojosEqualsAndHashCode(g.getGenerate().isPojosEqualsAndHashCode());
            }
            if (g.getGenerate().isPojosToString() != null) {
                generator.setGeneratePojosToString(g.getGenerate().isPojosToString());
            }
            if (g.getGenerate().getFullyQualifiedTypes() != null) {
                generator.setGenerateFullyQualifiedTypes(g.getGenerate().getFullyQualifiedTypes());
            }
            if (g.getGenerate().isJavaTimeTypes() != null) {
                generator.setGenerateJavaTimeTypes(g.getGenerate().isJavaTimeTypes());
            }
            if (g.getGenerate().isEmptyCatalogs() != null) {
                generator.setGenerateEmptyCatalogs(g.getGenerate().isEmptyCatalogs());
            }
            if (g.getGenerate().isEmptySchemas() != null) {
                generator.setGenerateEmptySchemas(g.getGenerate().isEmptySchemas());
            }
            if (g.getGenerate().getNewline() != null) {
                generator.setGenerateNewline(g.getGenerate().getNewline());
            }
            if (g.getGenerate().getIndentation() != null) {
                generator.setGenerateIndentation(g.getGenerate().getIndentation());
            }
            if (g.getGenerate().getPrintMarginForBlockComment() != null) {
                generator.setGeneratePrintMarginForBlockComment(g.getGenerate().getPrintMarginForBlockComment());
            }
            if (!StringUtils.isBlank((String)d.getSchemaVersionProvider())) {
                generator.setUseSchemaVersionProvider(true);
            }
            if (!StringUtils.isBlank((String)d.getCatalogVersionProvider())) {
                generator.setUseCatalogVersionProvider(true);
            }
            if (d.isTableValuedFunctions() != null) {
                generator.setGenerateTableValuedFunctions(d.isTableValuedFunctions());
            } else {
                generator.setGenerateTableValuedFunctions(true);
            }
            strategy.setInstanceFields(generator.generateInstanceFields());
            strategy.setJavaBeansGettersAndSetters(generator.generateJavaBeansGettersAndSetters());
            this.verifyVersions();
            generator.generate(database);
            this.logUnused("forced type", "forced types", database.getUnusedForcedTypes());
            this.logUnused("embeddable", "embeddables", database.getUnusedEmbeddables());
            this.logUnused("comment", "comments", database.getUnusedComments());
            this.logUnused("synthetic identity", "synthetic identities", database.getUnusedSyntheticIdentities());
            this.logUnused("synthetic primary key", "synthetic primary keys", database.getUnusedSyntheticPrimaryKeys());
            this.logUnused("synthetic unique key", "synthetic unique keys", database.getUnusedSyntheticUniqueKeys());
            this.logUnused("synthetic foreign key", "synthetic foreign keys", database.getUnusedSyntheticForeignKeys());
            this.logUnused("synthetic view", "synthetic views", database.getUnusedSyntheticViews());
        }
        finally {
            if (database != null) {
                try {
                    database.close();
                }
                catch (Exception e) {
                    log.error((Object)"Error while closing database", (Throwable)e);
                }
            }
            if (this.connection != null) {
                if (this.close) {
                    if (this.ctx != null && this.ctx.family() == SQLDialect.HSQLDB && this.dataSource == null) {
                        this.ctx.execute("shutdown");
                    }
                    this.connection.close();
                } else if (this.autoCommit != null) {
                    this.connection.setAutoCommit(this.autoCommit);
                }
            }
        }
    }

    private void verifyVersions() {
        try {
            Field[] f1 = org.jooq.Constants.class.getFields();
            Field[] f2 = org.jooq.meta.Constants.class.getFields();
            Field[] f3 = Constants.class.getFields();
            Arrays.sort(f1, Comparator.comparing(Field::getName));
            Arrays.sort(f2, Comparator.comparing(Field::getName));
            Arrays.sort(f3, Comparator.comparing(Field::getName));
            if (f1.length != f2.length) {
                log.warn((Object)"Version check", (Object)"org.jooq.Constants and org.jooq.meta.Constants contents mismatch. Check if you're using the same versions for org.jooq and org.jooq.meta");
            }
            if (f1.length != f3.length) {
                log.warn((Object)"Version check", (Object)"org.jooq.Constants and org.jooq.codegen.Constants contents mismatch. Check if you're using the same versions for org.jooq and org.jooq.meta");
            }
            String v1 = "3.15.5";
            String v2 = "3.15.5";
            String v3 = "3.15.5";
            for (int i = 0; i < f1.length && i < f2.length && i < f3.length; ++i) {
                Object c1 = f1[i].get(org.jooq.Constants.class);
                Object c2 = f2[i].get(org.jooq.meta.Constants.class);
                Object c3 = f3[i].get(Constants.class);
                if (!Objects.equals(c1, c2)) {
                    log.warn((Object)"Version check", (Object)("org.jooq.Constants." + f1[i].getName() + " contents mismatch: " + c1 + " vs " + c2 + ". Check if you're using the same versions for org.jooq (" + v1 + ") and org.jooq.meta (" + v2 + ")"));
                }
                if (Objects.equals(c1, c3)) continue;
                log.warn((Object)"Version check", (Object)("org.jooq.Constants." + f1[i].getName() + " contents mismatch: " + c1 + " vs " + c3 + ". Check if you're using the same versions for org.jooq (" + v1 + ") and org.jooq.codegen (" + v3 + ")"));
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Version check", (Object)"Something went wrong when comparing versions of org.jooq, org.jooq.meta, and org.jooq.codegen", e);
        }
    }

    private void logUnused(String objectType, String objectTypes, List<?> list) {
        if (!list.isEmpty() && Boolean.parseBoolean(System.getProperty("jooq.codegen.logunused", "true"))) {
            unusedLogger.warn((Object)("Unused " + objectTypes), (Object)("There are unused " + objectTypes + ", which have not been used by this generation run.\nThis can be because of misconfigurations, such as, for example:\n- case sensitive regular expressions\n- regular expressions depending on whitespace (Pattern.COMMENTS is turned on!)\n- missing or inadequate object qualification\n- the object to which the configuration was applied in the past has been dropped\nTry turning on DEBUG logging (-X in Maven, and <logging/> in jOOQ) to get additional info about the schema"));
            for (Object o : list) {
                unusedLogger.warn((Object)("Unused " + objectType), o);
            }
        }
    }

    private static void setGlobalLoggingThreshold(Configuration configuration) {
        if (configuration.getLogging() != null) {
            switch (configuration.getLogging()) {
                case TRACE: {
                    JooqLogger.globalThreshold((Log.Level)Log.Level.TRACE);
                    break;
                }
                case DEBUG: {
                    JooqLogger.globalThreshold((Log.Level)Log.Level.DEBUG);
                    break;
                }
                case INFO: {
                    JooqLogger.globalThreshold((Log.Level)Log.Level.INFO);
                    break;
                }
                case WARN: {
                    JooqLogger.globalThreshold((Log.Level)Log.Level.WARN);
                    break;
                }
                case ERROR: {
                    JooqLogger.globalThreshold((Log.Level)Log.Level.ERROR);
                    break;
                }
                case FATAL: {
                    JooqLogger.globalThreshold((Log.Level)Log.Level.FATAL);
                }
            }
        }
    }

    private Properties properties(List<Property> properties) {
        Properties result = new Properties();
        for (Property p : properties) {
            result.put(p.getKey(), p.getValue());
        }
        return result;
    }

    private String driverClass(Jdbc j) {
        String result = j.getDriver();
        if (result == null) {
            result = JDBCUtils.driver((String)j.getUrl());
            log.info((Object)"Database", (Object)("Inferring driver " + result + " from URL " + j.getUrl()));
        }
        return result;
    }

    private Class<? extends org.jooq.meta.Database> databaseClass(Jdbc j) {
        return this.databaseClass(j.getUrl());
    }

    private Class<? extends org.jooq.meta.Database> databaseClass(Connection c) {
        try {
            return this.databaseClass(c.getMetaData().getURL());
        }
        catch (SQLException e) {
            throw new GeneratorException("Error when reading URL from JDBC connection", e);
        }
    }

    private Class<? extends org.jooq.meta.Database> databaseClass(String url) {
        if (StringUtils.isBlank((String)url)) {
            throw new GeneratorException("No JDBC URL configured.");
        }
        Class result = Databases.databaseClass((SQLDialect)JDBCUtils.dialect((String)url));
        log.info((Object)"Database", (Object)("Inferring database " + result.getName() + " from URL " + url));
        return result;
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            if (this.loader == null) {
                return this.loadClass0(className);
            }
            return this.loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            String message = null;
            if (className.startsWith("org.jooq.util.")) {
                String alternative = null;
                for (String pkg : new String[]{"org.jooq.meta", "org.jooq.meta.extensions", "org.jooq.codegen", "org.jooq.codegen.maven"}) {
                    try {
                        alternative = this.loadClass0(className.replace("org.jooq.util", pkg)).getName();
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
                message = "Your configured " + className + " type was not found.\n" + (String)(alternative != null ? "Did you mean " + alternative + "?\n" : "") + "Do note that in jOOQ 3.11, jOOQ-meta and jOOQ-codegen packages have been renamed. New package names are:\n- org.jooq.meta\n- org.jooq.meta.extensions\n- org.jooq.codegen\n- org.jooq.codegen.maven\nSee https://github.com/jOOQ/jOOQ/issues/7419 for details";
                log.warn((Object)"Type not found", (Object)message);
            } else if (className.equals("org.jooq.meta.extensions.liquibase.LiquibaseDatabase")) {
                message = "Your configured database type was not found: " + className + ".\n- Please make sure the jooq-meta-extensions-liquibase dependency is on your classpath.\n- In jOOQ 3.14, the dependency name has changed, see https://github.com/jOOQ/jOOQ/issues/10331";
                log.warn((Object)"Type not found", (Object)message);
            } else if (className.equals("org.jooq.meta.extensions.jpa.JPADatabase")) {
                message = "Your configured database type was not found: " + className + ".\n- Please make sure the jooq-meta-extensions-hibernate dependency is on your classpath.\n- In jOOQ 3.14, the dependency name has changed, see https://github.com/jOOQ/jOOQ/issues/10331";
                log.warn((Object)"Type not found", (Object)message);
            } else if (className.startsWith("org.jooq.meta.") && className.endsWith("Database")) {
                message = "Your configured database type was not found: " + className + ". This can have several reasons:\n- You want to use a commercial jOOQ Edition, but you pulled the Open Source Edition from Maven Central.\n- You have mis-typed your class name.";
                log.warn((Object)"Type not found", (Object)message);
            }
            if (message == null) {
                throw e;
            }
            throw new ClassNotFoundException(message, e);
        }
    }

    private Class<?> loadClass0(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
    }

    private static String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static Configuration load(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GenerationTool.copyLarge(in, out);
        String xml = out.toString();
        xml = xml.replaceAll("<(\\w+:)?configuration xmlns(:\\w+)?=\"http://www.jooq.org/xsd/jooq-codegen-\\d+\\.\\d+\\.\\d+.xsd\">", "<$1configuration xmlns$2=\"http://www.jooq.org/xsd/jooq-codegen-3.15.0.xsd\">");
        return (Configuration)MiniJAXB.unmarshal((String)xml, Configuration.class);
    }

    private static class Unused {
        private Unused() {
        }
    }
}

