/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.geom;

import com.jogamp.graph.math.VectorUtil;

public class AABBox
implements Cloneable {
    private float[] low = new float[3];
    private float[] high = new float[3];
    private float[] center = new float[3];

    public AABBox() {
        this.reset();
    }

    public AABBox(float f, float f2, float f3, float f4, float f5, float f6) {
        this.reset();
        this.resize(f, f2, f3);
        this.resize(f4, f5, f6);
        this.computeCenter();
    }

    public AABBox(float[] fArray, float[] fArray2) {
        this.reset();
        this.resize(fArray[0], fArray[1], fArray[2]);
        this.resize(fArray2[0], fArray2[1], fArray2[2]);
        this.computeCenter();
    }

    public final void reset() {
        this.setLow(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.setHigh(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        this.center[0] = 0.0f;
        this.center[1] = 0.0f;
        this.center[2] = 0.0f;
    }

    public final float[] getHigh() {
        return this.high;
    }

    private final void setHigh(float f, float f2, float f3) {
        this.high[0] = f;
        this.high[1] = f2;
        this.high[2] = f3;
    }

    public final float[] getLow() {
        return this.low;
    }

    private final void setLow(float f, float f2, float f3) {
        this.low[0] = f;
        this.low[1] = f2;
        this.low[2] = f3;
    }

    public final void resize(AABBox aABBox) {
        float[] fArray = aABBox.getLow();
        float[] fArray2 = aABBox.getHigh();
        if (fArray[0] < this.low[0]) {
            this.low[0] = fArray[0];
        }
        if (fArray[1] < this.low[1]) {
            this.low[1] = fArray[1];
        }
        if (fArray[2] < this.low[2]) {
            this.low[2] = fArray[2];
        }
        if (fArray2[0] > this.high[0]) {
            this.high[0] = fArray2[0];
        }
        if (fArray2[1] > this.high[1]) {
            this.high[1] = fArray2[1];
        }
        if (fArray2[2] > this.high[2]) {
            this.high[2] = fArray2[2];
        }
        this.computeCenter();
    }

    private final void computeCenter() {
        this.center[0] = (this.high[0] + this.low[0]) / 2.0f;
        this.center[1] = (this.high[1] + this.low[1]) / 2.0f;
        this.center[2] = (this.high[2] + this.low[2]) / 2.0f;
    }

    public final void resize(float f, float f2, float f3) {
        if (f < this.low[0]) {
            this.low[0] = f;
        }
        if (f2 < this.low[1]) {
            this.low[1] = f2;
        }
        if (f3 < this.low[2]) {
            this.low[2] = f3;
        }
        if (f > this.high[0]) {
            this.high[0] = f;
        }
        if (f2 > this.high[1]) {
            this.high[1] = f2;
        }
        if (f3 > this.high[2]) {
            this.high[2] = f3;
        }
        this.computeCenter();
    }

    public final void resize(float[] fArray, int n) {
        this.resize(fArray[0 + n], fArray[1 + n], fArray[2 + n]);
    }

    public final boolean contains(float f, float f2) {
        if (f < this.low[0] || f > this.high[0]) {
            return false;
        }
        return !(f2 < this.low[1]) && !(f2 > this.high[1]);
    }

    public final boolean contains(float f, float f2, float f3) {
        if (f < this.low[0] || f > this.high[0]) {
            return false;
        }
        if (f2 < this.low[1] || f2 > this.high[1]) {
            return false;
        }
        return !(f3 < this.low[2]) && !(f3 > this.high[2]);
    }

    public final boolean intersects(float f, float f2, float f3, float f4) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return false;
        }
        float f5 = this.getWidth();
        float f6 = this.getHeight();
        if (f5 <= 0.0f || f6 <= 0.0f) {
            return false;
        }
        float f7 = this.getMinX();
        float f8 = this.getMinY();
        return f + f3 > f7 && f2 + f4 > f8 && f < f7 + f5 && f2 < f8 + f6;
    }

    public final float getSize() {
        return VectorUtil.computeLength(this.low, this.high);
    }

    public final float[] getCenter() {
        return this.center;
    }

    public final void scale(float f) {
        float[] fArray = new float[]{this.high[0] - this.center[0], this.high[1] - this.center[1], this.high[2] - this.center[2]};
        fArray = VectorUtil.scale(fArray, f);
        float[] fArray2 = new float[]{this.low[0] - this.center[0], this.low[1] - this.center[1], this.low[2] - this.center[2]};
        fArray2 = VectorUtil.scale(fArray2, f);
        this.high = VectorUtil.vectorAdd(this.center, fArray);
        this.low = VectorUtil.vectorAdd(this.center, fArray2);
    }

    public final float getMinX() {
        return this.low[0];
    }

    public final float getMinY() {
        return this.low[1];
    }

    public final float getWidth() {
        return this.high[0] - this.low[0];
    }

    public final float getHeight() {
        return this.high[1] - this.low[1];
    }

    public final float getDepth() {
        return this.high[2] - this.low[2];
    }

    public final AABBox clone() {
        return new AABBox(this.low, this.high);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof AABBox)) {
            return false;
        }
        AABBox aABBox = (AABBox)object;
        return VectorUtil.checkEquality(this.low, aABBox.low) && VectorUtil.checkEquality(this.high, aABBox.high);
    }

    public final String toString() {
        return "[ " + this.low[0] + "/" + this.low[1] + "/" + this.low[1] + " .. " + this.high[0] + "/" + this.high[0] + "/" + this.high[0] + ", ctr " + this.center[0] + "/" + this.center[1] + "/" + this.center[1] + " ]";
    }
}

