/*
 * Decompiled with CFR 0.152.
 */
package jodd.system;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;

abstract class HostInfo {
    private static HostInfoLazy hostInfoLazy;

    HostInfo() {
    }

    public final String getHostName() {
        if (hostInfoLazy == null) {
            hostInfoLazy = new HostInfoLazy();
        }
        return hostInfoLazy.HOST_NAME;
    }

    public final String getHostAddress() {
        if (hostInfoLazy == null) {
            hostInfoLazy = new HostInfoLazy();
        }
        return hostInfoLazy.HOST_ADDRESS;
    }

    protected String nosep(String in) {
        if (in.endsWith(File.separator)) {
            return in.substring(0, in.length() - 1);
        }
        return in;
    }

    public String toString() {
        return "\nHost name:    " + this.getHostName() + "\nHost address: " + this.getHostAddress();
    }

    private static class HostInfoLazy {
        private final String HOST_NAME;
        private final String HOST_ADDRESS;

        public HostInfoLazy() {
            String hostAddress;
            String hostName;
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                hostName = localhost.getHostName();
                hostAddress = localhost.getHostAddress();
            }
            catch (UnknownHostException uhex) {
                hostName = "localhost";
                hostAddress = "127.0.0.1";
            }
            this.HOST_NAME = hostName;
            this.HOST_ADDRESS = hostAddress;
        }
    }
}

