/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.StringUtil;
import jodd.util.TimeUtil;

public class LocalTimeConverter
implements TypeConverter<LocalTime> {
    @Override
    public LocalTime convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalTime();
        }
        if (value instanceof Calendar) {
            return TimeUtil.fromCalendar((Calendar)((Calendar)value)).toLocalTime();
        }
        if (value instanceof Timestamp) {
            return TimeUtil.fromMilliseconds((long)((Timestamp)value).getTime()).toLocalTime();
        }
        if (value instanceof Date) {
            return TimeUtil.fromDate((Date)((Date)value)).toLocalTime();
        }
        if (value instanceof Number) {
            return TimeUtil.fromMilliseconds((long)((Number)value).longValue()).toLocalTime();
        }
        if (value instanceof LocalDate) {
            throw new TypeConversionException("Can't convert to time just from date: " + value);
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits((CharSequence)stringValue)) {
            return LocalTime.parse(stringValue);
        }
        try {
            return TimeUtil.fromMilliseconds((long)Long.parseLong(stringValue)).toLocalTime();
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

