/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import org.jodconverter.office.RetryTimeoutException;
import org.jodconverter.office.TemporaryException;

abstract class AbstractRetryable {
    protected AbstractRetryable() {
    }

    protected abstract void attempt() throws Exception;

    public void execute(long interval, long timeout) throws Exception {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                this.attempt();
                return;
            }
            catch (TemporaryException temporaryEx) {
                if (System.currentTimeMillis() - start < timeout) {
                    Thread.sleep(interval);
                    continue;
                }
                throw new RetryTimeoutException(temporaryEx.getCause());
            }
            break;
        }
    }
}

