/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.Validate;
import org.jodconverter.office.AbstractOfficeManager;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.office.OfficeManagerPoolConfig;
import org.jodconverter.task.OfficeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractOfficeManagerPool
extends AbstractOfficeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOfficeManagerPool.class);
    private static final int POOL_STOPPED = 0;
    private static final int POOL_STARTED = 1;
    private static final int POOL_SHUTDOWN = 2;
    private final AtomicInteger poolState = new AtomicInteger(0);
    protected final OfficeManagerPoolConfig config;
    private final BlockingQueue<OfficeManager> pool;
    private OfficeManager[] entries;

    protected AbstractOfficeManagerPool(int poolSize, OfficeManagerPoolConfig config) {
        super(config);
        this.config = config;
        this.pool = new ArrayBlockingQueue<OfficeManager>(poolSize);
    }

    protected abstract OfficeManager[] createPoolEntries();

    @Override
    public void execute(OfficeTask task) throws OfficeException {
        if (!this.isRunning()) {
            throw new IllegalStateException("This office manager is not running.");
        }
        OfficeManager entry = null;
        try {
            entry = this.acquireManager();
            entry.execute(task);
        }
        finally {
            if (entry != null) {
                this.releaseManager(entry);
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.poolState.get() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws OfficeException {
        AbstractOfficeManagerPool abstractOfficeManagerPool = this;
        synchronized (abstractOfficeManagerPool) {
            if (this.poolState.get() == 2) {
                throw new IllegalStateException("This office manager has been shutdown.");
            }
            if (this.poolState.get() == 1) {
                throw new IllegalStateException("This office manager is already running.");
            }
            this.entries = this.createPoolEntries();
            this.doStart();
            this.makeTempDir();
            this.poolState.set(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws OfficeException {
        AbstractOfficeManagerPool abstractOfficeManagerPool = this;
        synchronized (abstractOfficeManagerPool) {
            if (this.poolState.get() == 2) {
                return;
            }
            this.poolState.set(2);
            try {
                this.doStop();
            }
            finally {
                this.deleteTempDir();
            }
        }
    }

    private OfficeManager acquireManager() throws OfficeException {
        try {
            OfficeManager manager = this.pool.poll(this.config.getTaskQueueTimeout(), TimeUnit.MILLISECONDS);
            if (manager == null) {
                throw new OfficeException("No office manager available after " + this.config.getTaskQueueTimeout() + " millisec.");
            }
            return manager;
        }
        catch (InterruptedException interruptedEx) {
            throw new OfficeException("Thread has been interrupted while waiting for a manager to become available.", interruptedEx);
        }
    }

    private void releaseManager(OfficeManager manager) throws OfficeException {
        try {
            this.pool.put(manager);
        }
        catch (InterruptedException interruptedEx) {
            throw new OfficeException("interrupted", interruptedEx);
        }
    }

    protected void doStart() throws OfficeException {
        for (OfficeManager manager : this.entries) {
            manager.start();
            this.releaseManager(manager);
        }
    }

    private void doStop() throws OfficeException {
        LOGGER.info("Stopping the office manager pool...");
        this.pool.clear();
        OfficeException firstException = null;
        for (OfficeManager manager : this.entries) {
            try {
                manager.stop();
            }
            catch (OfficeException ex) {
                if (firstException != null) continue;
                firstException = ex;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
        LOGGER.info("Office manager stopped");
    }

    public static abstract class AbstractOfficeManagerPoolBuilder<B extends AbstractOfficeManagerPoolBuilder<B>>
    extends AbstractOfficeManager.AbstractOfficeManagerBuilder<B> {
        protected long taskExecutionTimeout = 120000L;
        protected long taskQueueTimeout = 30000L;

        protected AbstractOfficeManagerPoolBuilder() {
        }

        public B taskExecutionTimeout(long taskExecutionTimeout) {
            Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)taskExecutionTimeout, (String)String.format("The taskExecutionTimeout %s must greater than or equal to 0", taskExecutionTimeout));
            this.taskExecutionTimeout = taskExecutionTimeout;
            return (B)this;
        }

        public B taskQueueTimeout(long taskQueueTimeout) {
            Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)taskQueueTimeout, (String)String.format("The taskQueueTimeout %s must greater than or equal to 0", taskQueueTimeout));
            this.taskQueueTimeout = taskQueueTimeout;
            return (B)this;
        }

        @Override
        protected abstract AbstractOfficeManagerPool build();
    }
}

