/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.document;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jodconverter.document.DocumentFamily;
import org.jodconverter.document.DocumentFormat;
import org.jodconverter.document.DocumentFormatProperties;
import org.jodconverter.document.SimpleDocumentFormatRegistry;

public class JsonDocumentFormatRegistry
extends SimpleDocumentFormatRegistry {
    public static JsonDocumentFormatRegistry create(InputStream source) throws IOException {
        return JsonDocumentFormatRegistry.create(source, null);
    }

    public static JsonDocumentFormatRegistry create(InputStream source, Map<String, DocumentFormatProperties> customProperties) throws IOException {
        return JsonDocumentFormatRegistry.create(IOUtils.toString((InputStream)source, (String)"UTF-8"), customProperties);
    }

    public static JsonDocumentFormatRegistry create(String source) {
        return JsonDocumentFormatRegistry.create(source, null);
    }

    public static JsonDocumentFormatRegistry create(String source, Map<String, DocumentFormatProperties> customProperties) {
        JsonDocumentFormatRegistry registry = new JsonDocumentFormatRegistry();
        registry.readJsonArray(source, customProperties);
        return registry;
    }

    protected JsonDocumentFormatRegistry() {
    }

    protected void readJsonArray(String source, Map<String, DocumentFormatProperties> customProperties) {
        Gson gson = new Gson();
        Type collectionType = new TypeToken<Collection<DocumentFormat>>(){}.getType();
        Collection formats = (Collection)gson.fromJson(source, collectionType);
        formats.stream().map(fmt -> {
            if (customProperties == null || !customProperties.containsKey(fmt.getExtension())) {
                return DocumentFormat.unmodifiableCopy(fmt);
            }
            DocumentFormatProperties props = (DocumentFormatProperties)customProperties.get(fmt.getExtension());
            DocumentFormat.Builder builder = DocumentFormat.builder().from((DocumentFormat)fmt).unmodifiable(true);
            props.getLoad().forEach(builder::loadProperty);
            props.getStore().forEach((family, storeProps) -> storeProps.forEach((name, value) -> builder.storeProperty((DocumentFamily)((Object)((Object)family)), (String)name, value)));
            return builder.build();
        }).forEach(this::addFormat);
    }
}

