/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.specifics;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.alg.util.UnorderedPair;
import org.jgrapht.graph.EdgeSetFactory;
import org.jgrapht.graph.specifics.ArrayUnenforcedSetEdgeSetFactory;
import org.jgrapht.graph.specifics.UndirectedEdgeContainer;
import org.jgrapht.graph.specifics.UndirectedSpecifics;

public class FastLookupUndirectedSpecifics<V, E>
extends UndirectedSpecifics<V, E> {
    private static final long serialVersionUID = 225772727571597846L;
    protected Map<Pair<V, V>, Set<E>> touchingVerticesToEdgeMap;

    @Deprecated
    public FastLookupUndirectedSpecifics(Graph<V, E> graph) {
        this(graph, new LinkedHashMap(), new ArrayUnenforcedSetEdgeSetFactory());
    }

    @Deprecated
    public FastLookupUndirectedSpecifics(Graph<V, E> graph, Map<V, UndirectedEdgeContainer<V, E>> vertexMap) {
        this(graph, vertexMap, new ArrayUnenforcedSetEdgeSetFactory());
    }

    @Deprecated
    public FastLookupUndirectedSpecifics(Graph<V, E> graph, Map<V, UndirectedEdgeContainer<V, E>> vertexMap, EdgeSetFactory<V, E> edgeSetFactory) {
        this(graph, vertexMap, new HashMap<Pair<V, V>, Set<E>>(), edgeSetFactory);
    }

    public FastLookupUndirectedSpecifics(Graph<V, E> graph, Map<V, UndirectedEdgeContainer<V, E>> vertexMap, Map<Pair<V, V>, Set<E>> touchingVerticesToEdgeMap, EdgeSetFactory<V, E> edgeSetFactory) {
        super(graph, vertexMap, edgeSetFactory);
        this.touchingVerticesToEdgeMap = Objects.requireNonNull(touchingVerticesToEdgeMap);
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        if (this.graph.containsVertex(sourceVertex) && this.graph.containsVertex(targetVertex)) {
            Set<E> edges = this.touchingVerticesToEdgeMap.get(new UnorderedPair<V, V>(sourceVertex, targetVertex));
            if (edges == null) {
                return Collections.emptySet();
            }
            Set<E> edgeSet = this.edgeSetFactory.createEdgeSet(sourceVertex);
            edgeSet.addAll(edges);
            return edgeSet;
        }
        return null;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        Set<E> edges = this.touchingVerticesToEdgeMap.get(new UnorderedPair<V, V>(sourceVertex, targetVertex));
        if (edges == null || edges.isEmpty()) {
            return null;
        }
        return edges.iterator().next();
    }

    @Override
    public void addEdgeToTouchingVertices(E e) {
        Object source = this.graph.getEdgeSource(e);
        Object target = this.graph.getEdgeTarget(e);
        this.getEdgeContainer(source).addEdge(e);
        UnorderedPair vertexPair = new UnorderedPair(source, target);
        Set<E> edgeSet = this.touchingVerticesToEdgeMap.get(vertexPair);
        if (edgeSet != null) {
            edgeSet.add(e);
        } else {
            edgeSet = this.edgeSetFactory.createEdgeSet(source);
            edgeSet.add(e);
            this.touchingVerticesToEdgeMap.put(vertexPair, edgeSet);
        }
        if (!source.equals(target)) {
            this.getEdgeContainer(target).addEdge(e);
        }
    }

    @Override
    public void removeEdgeFromTouchingVertices(E e) {
        UnorderedPair vertexPair;
        Set<E> edgeSet;
        Object source = this.graph.getEdgeSource(e);
        Object target = this.graph.getEdgeTarget(e);
        this.getEdgeContainer(source).removeEdge(e);
        if (!source.equals(target)) {
            this.getEdgeContainer(target).removeEdge(e);
        }
        if ((edgeSet = this.touchingVerticesToEdgeMap.get(vertexPair = new UnorderedPair(source, target))) != null) {
            edgeSet.remove(e);
            if (edgeSet.isEmpty()) {
                this.touchingVerticesToEdgeMap.remove(vertexPair);
            }
        }
    }
}

