/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.file;

import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;
import org.jetbrains.kotlin.konan.file.FileSystemRefCounter;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u0012\u0010\b\u001a\u00020\u0005*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\b\u001a\u00020\u0005*\u00020\t2\u0006\u0010\b\u001a\u00020\u0005\u001a\u0014\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r*\u00020\u0005H\u0002\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\r2\u0006\u0010\u0011\u001a\u00020\r\u001a)\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u0013*\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\u0010\u0016\u001a)\u0010\u0017\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u0013*\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\u0010\u0016\u001a3\u0010\u0017\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u0013*\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\u0010\u001a\u001a\u0012\u0010\u001b\u001a\u00020\u0010*\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005\u001a\u0014\u0010\u001d\u001a\u00020\t*\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u0019\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0004\u001a\u00020\u0002*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"fileSystems", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/net/URI;", "Lorg/jetbrains/kotlin/konan/file/FileSystemRefCounter;", "zipUri", "Lorg/jetbrains/kotlin/konan/file/File;", "getZipUri", "(Lorg/jetbrains/kotlin/konan/file/File;)Ljava/net/URI;", "file", "Ljava/nio/file/FileSystem;", "path", "", "toPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "unzipTo", "", "directory", "withMutableZipFileSystem", "T", "action", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/konan/file/File;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withZipFileSystem", "mutable", "", "(Lorg/jetbrains/kotlin/konan/file/File;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "zipDirAs", "unixFile", "zipFileSystem", "kotlin-util-io"})
public final class ZipUtilKt {
    private static final ConcurrentHashMap<URI, FileSystemRefCounter> fileSystems = new ConcurrentHashMap();

    private static final URI getZipUri(@NotNull File $this$zipUri) {
        URI uRI = URI.create("jar:" + ZipUtilKt.toPath($this$zipUri.getCanonicalFile()).toUri());
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(\"jar:${canoni\u2026lFile.toPath().toUri()}\")");
        return uRI;
    }

    @NotNull
    public static final FileSystem zipFileSystem(@NotNull File $this$zipFileSystem, boolean mutable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$zipFileSystem, (String)"$this$zipFileSystem");
        URI zipUri = ZipUtilKt.getZipUri($this$zipFileSystem);
        HashMap attributes = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"create", (Object)String.valueOf(mutable))});
        FileSystemRefCounter fileSystemRefCounter = fileSystems.compute(zipUri, new BiFunction<URI, FileSystemRefCounter, FileSystemRefCounter>(attributes){
            final /* synthetic */ HashMap $attributes;

            @Nullable
            public final FileSystemRefCounter apply(@NotNull URI key, @Nullable FileSystemRefCounter value) {
                FileSystemRefCounter fileSystemRefCounter;
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                if (value == null) {
                    FileSystem fileSystem = FileSystems.newFileSystem(key, (Map)this.$attributes, null);
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileSystem, (String)"FileSystems.newFileSystem(key, attributes, null)");
                    fileSystemRefCounter = new FileSystemRefCounter(fileSystem, 1);
                } else {
                    fileSystemRefCounter = new FileSystemRefCounter(value.getFileSystem(), value.getCounter() + 1);
                }
                return fileSystemRefCounter;
            }
            {
                this.$attributes = hashMap;
            }
        });
        if (fileSystemRefCounter == null) {
            Intrinsics.throwNpe();
        }
        return fileSystemRefCounter.getFileSystem();
    }

    public static /* synthetic */ FileSystem zipFileSystem$default(File file, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ZipUtilKt.zipFileSystem(file, bl);
    }

    @NotNull
    public static final File file(@NotNull FileSystem $this$file, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)$this$file, (String)"$this$file");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Path path = $this$file.getPath(file.getPath(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"this.getPath(file.path)");
        return new File(path);
    }

    @NotNull
    public static final File file(@NotNull FileSystem $this$file, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)$this$file, (String)"$this$file");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Path path2 = $this$file.getPath(path, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"this.getPath(path)");
        return new File(path2);
    }

    private static final Path toPath(@NotNull File $this$toPath) {
        return Paths.get($this$toPath.getPath(), new String[0]);
    }

    public static final void zipDirAs(@NotNull File $this$zipDirAs, @NotNull File unixFile) {
        Intrinsics.checkParameterIsNotNull((Object)$this$zipDirAs, (String)"$this$zipDirAs");
        Intrinsics.checkParameterIsNotNull((Object)unixFile, (String)"unixFile");
        ZipUtilKt.withMutableZipFileSystem(unixFile, (Function1)new Function1<FileSystem, Unit>($this$zipDirAs){
            final /* synthetic */ File $this_zipDirAs;

            public final void invoke(@NotNull FileSystem it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$this_zipDirAs.recursiveCopyTo(ZipUtilKt.file(it, "/"));
            }
            {
                this.$this_zipDirAs = file;
                super(1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unzipTo(@NotNull Path $this$unzipTo, @NotNull Path directory) {
        Intrinsics.checkParameterIsNotNull((Object)$this$unzipTo, (String)"$this$unzipTo");
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        URI zipUri = URI.create("jar:" + $this$unzipTo.toUri());
        AutoCloseable $this$use$iv = FileSystems.newFileSystem(zipUri, MapsKt.emptyMap(), null);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            Path zipPath;
            FileSystem zipfs = (FileSystem)$this$use$iv;
            boolean bl = false;
            Path path = zipPath = zipfs.getPath("/", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"zipPath");
            FileKt.recursiveCopyTo(path, directory);
            zipfs = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw (Throwable)e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withZipFileSystem(@NotNull File $this$withZipFileSystem, boolean mutable, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$this$withZipFileSystem, (String)"$this$withZipFileSystem");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        FileSystem zipFileSystem2 = ZipUtilKt.zipFileSystem($this$withZipFileSystem, mutable);
        try {
            object = action.invoke((Object)zipFileSystem2);
        }
        finally {
            fileSystems.compute(ZipUtilKt.getZipUri($this$withZipFileSystem), withZipFileSystem.1.INSTANCE);
        }
        return (T)object;
    }

    public static /* synthetic */ Object withZipFileSystem$default(File file, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ZipUtilKt.withZipFileSystem(file, bl, function1);
    }

    public static final <T> T withZipFileSystem(@NotNull File $this$withZipFileSystem, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Intrinsics.checkParameterIsNotNull((Object)$this$withZipFileSystem, (String)"$this$withZipFileSystem");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        return ZipUtilKt.withZipFileSystem($this$withZipFileSystem, false, action);
    }

    public static final <T> T withMutableZipFileSystem(@NotNull File $this$withMutableZipFileSystem, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Intrinsics.checkParameterIsNotNull((Object)$this$withMutableZipFileSystem, (String)"$this$withMutableZipFileSystem");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        return ZipUtilKt.withZipFileSystem($this$withMutableZipFileSystem, true, action);
    }
}

