/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.repl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.UninitializedPropertyAccessException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.CompiledReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ILineId;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplHistory;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.NoScopeRecordCliBindingTrace;
import org.jetbrains.kotlin.cli.jvm.compiler.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.lazy.FileScopeFactory;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProviderKt;
import org.jetbrains.kotlin.resolve.lazy.FileScopes;
import org.jetbrains.kotlin.resolve.lazy.FileScopesCustomizer;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.CombinedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.DelegatePackageMemberDeclarationProvider;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.ReplCodeAnalyzer;
import org.jetbrains.kotlin.scripting.definitions.ScriptPriorities;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003&'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ$\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010\u001b\u001a\u00020\u001cJ&\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001fJ\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001f2\u0006\u0010$\u001a\u00020%R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer;", "", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)V", "module", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "getModule", "()Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "replState", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState;", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "scriptDeclarationFactory", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ScriptMutableDeclarationProviderFactory;", "topDownAnalysisContext", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "topDownAnalyzer", "Lorg/jetbrains/kotlin/resolve/LazyTopDownAnalyzer;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTraceContext;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTraceContext;", "analyzeReplLine", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ReplLineAnalysisResult;", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "analyzeReplLineWithImportedScripts", "importedScripts", "", "doAnalyze", "linePsi", "reset", "resetToLine", "lineId", "Lorg/jetbrains/kotlin/cli/common/repl/ILineId;", "ReplLineAnalysisResult", "ResettableAnalyzerState", "ScriptMutableDeclarationProviderFactory", "kotlin-scripting-compiler"})
public final class ReplCodeAnalyzer {
    private final TopDownAnalysisContext topDownAnalysisContext;
    private final LazyTopDownAnalyzer topDownAnalyzer;
    private final ResolveSession resolveSession;
    private final ScriptMutableDeclarationProviderFactory scriptDeclarationFactory;
    private final ResettableAnalyzerState replState;
    @NotNull
    private final ModuleDescriptorImpl module;
    @NotNull
    private final BindingTraceContext trace;

    @NotNull
    public final ModuleDescriptorImpl getModule() {
        return this.module;
    }

    @NotNull
    public final BindingTraceContext getTrace() {
        return this.trace;
    }

    @NotNull
    public final List<ReplCodeLine> resetToLine(@NotNull ILineId lineId) {
        Intrinsics.checkParameterIsNotNull((Object)lineId, (String)"lineId");
        return this.replState.resetToLine(lineId);
    }

    @NotNull
    public final List<ReplCodeLine> reset() {
        return this.replState.reset();
    }

    @NotNull
    public final ReplLineAnalysisResult analyzeReplLine(@NotNull KtFile psiFile, @NotNull ReplCodeLine codeLine) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        Intrinsics.checkParameterIsNotNull((Object)codeLine, (String)"codeLine");
        this.topDownAnalysisContext.getScripts().clear();
        this.trace.clearDiagnostics();
        KtScript ktScript = psiFile.getScript();
        if (ktScript == null) {
            Intrinsics.throwNpe();
        }
        ktScript.putUserData(ScriptPriorities.PRIORITY_KEY, (Object)codeLine.getNo());
        return this.doAnalyze(psiFile, CollectionsKt.emptyList(), codeLine);
    }

    @NotNull
    public final ReplLineAnalysisResult analyzeReplLineWithImportedScripts(@NotNull KtFile psiFile, @NotNull List<? extends KtFile> importedScripts, @NotNull ReplCodeLine codeLine) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        Intrinsics.checkParameterIsNotNull(importedScripts, (String)"importedScripts");
        Intrinsics.checkParameterIsNotNull((Object)codeLine, (String)"codeLine");
        this.topDownAnalysisContext.getScripts().clear();
        this.trace.clearDiagnostics();
        KtScript ktScript = psiFile.getScript();
        if (ktScript == null) {
            Intrinsics.throwNpe();
        }
        ktScript.putUserData(ScriptPriorities.PRIORITY_KEY, (Object)codeLine.getNo());
        return this.doAnalyze(psiFile, importedScripts, codeLine);
    }

    private final ReplLineAnalysisResult doAnalyze(KtFile linePsi, List<? extends KtFile> importedScripts, ReplCodeLine codeLine) {
        ReplLineAnalysisResult replLineAnalysisResult;
        boolean hasErrors;
        Diagnostics diagnostics;
        TopDownAnalysisContext context;
        block6: {
            boolean bl;
            this.scriptDeclarationFactory.setDelegateFactory((DeclarationProviderFactory)new FileBasedDeclarationProviderFactory((StorageManager)this.resolveSession.getStorageManager(), (Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)linePsi), (Iterable)importedScripts)));
            this.replState.submitLine(linePsi, codeLine);
            TopDownAnalysisMode topDownAnalysisMode = this.topDownAnalysisContext.getTopDownAnalysisMode();
            Intrinsics.checkExpressionValueIsNotNull((Object)topDownAnalysisMode, (String)"topDownAnalysisContext.topDownAnalysisMode");
            context = LazyTopDownAnalyzer.analyzeDeclarations$default((LazyTopDownAnalyzer)this.topDownAnalyzer, (TopDownAnalysisMode)topDownAnalysisMode, (Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)linePsi), (Iterable)importedScripts), null, (int)4, null);
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
            Diagnostics diagnostics2 = bindingContext.getDiagnostics();
            Intrinsics.checkExpressionValueIsNotNull((Object)diagnostics2, (String)"trace.bindingContext.diagnostics");
            diagnostics = diagnostics2;
            Iterable $this$any$iv = (Iterable)diagnostics;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSeverity() == Severity.ERROR)) continue;
                    bl = true;
                    break block6;
                }
                bl = hasErrors = false;
            }
        }
        if (hasErrors) {
            this.replState.lineFailure(linePsi, codeLine);
            replLineAnalysisResult = new ReplLineAnalysisResult.WithErrors(diagnostics);
        } else {
            Object v = context.getScripts().get(linePsi.getScript());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            ClassDescriptorWithResolutionScopes scriptDescriptor = (ClassDescriptorWithResolutionScopes)v;
            this.replState.lineSuccess(linePsi, codeLine, scriptDescriptor);
            replLineAnalysisResult = new ReplLineAnalysisResult.Successful(scriptDescriptor, diagnostics);
        }
        return replLineAnalysisResult;
    }

    public ReplCodeAnalyzer(@NotNull KotlinCoreEnvironment environment2) {
        ComponentProvider $this$get$iv;
        ComponentProvider container2;
        Intrinsics.checkParameterIsNotNull((Object)environment2, (String)"environment");
        this.replState = new ResettableAnalyzerState();
        this.trace = (BindingTraceContext)new NoScopeRecordCliBindingTrace();
        ComponentProvider componentProvider = container2 = TopDownAnalyzerFacadeForJVM.createContainer$default((TopDownAnalyzerFacadeForJVM)TopDownAnalyzerFacadeForJVM.INSTANCE, (Project)environment2.getProject(), (Collection)CollectionsKt.emptyList(), (BindingTrace)((BindingTrace)this.trace), (CompilerConfiguration)environment2.getConfiguration(), (Function1)((Function1)new Function1<GlobalSearchScope, JvmPackagePartProvider>(environment2){

            @NotNull
            public final JvmPackagePartProvider invoke(@NotNull GlobalSearchScope p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((KotlinCoreEnvironment)this.receiver).createPackagePartProvider(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(KotlinCoreEnvironment.class);
            }

            public final String getName() {
                return "createPackagePartProvider";
            }

            public final String getSignature() {
                return "createPackagePartProvider(Lcom/intellij/psi/search/GlobalSearchScope;)Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;";
            }
        }), (Function2)container.2.INSTANCE, null, null, (int)192, null);
        ReplCodeAnalyzer replCodeAnalyzer = this;
        boolean $i$f$get = false;
        Object object = DslKt.getService((ComponentProvider)$this$get$iv, ModuleDescriptorImpl.class);
        replCodeAnalyzer.module = (ModuleDescriptorImpl)object;
        $this$get$iv = container2;
        replCodeAnalyzer = this;
        $i$f$get = false;
        object = DslKt.getService((ComponentProvider)$this$get$iv, ScriptMutableDeclarationProviderFactory.class);
        replCodeAnalyzer.scriptDeclarationFactory = (ScriptMutableDeclarationProviderFactory)object;
        $this$get$iv = container2;
        replCodeAnalyzer = this;
        $i$f$get = false;
        object = DslKt.getService((ComponentProvider)$this$get$iv, ResolveSession.class);
        replCodeAnalyzer.resolveSession = (ResolveSession)object;
        this.topDownAnalysisContext = new TopDownAnalysisContext(TopDownAnalysisMode.TopLevelDeclarations, DataFlowInfoFactory.EMPTY, this.resolveSession.getDeclarationScopeProvider());
        $this$get$iv = container2;
        replCodeAnalyzer = this;
        $i$f$get = false;
        object = DslKt.getService((ComponentProvider)$this$get$iv, LazyTopDownAnalyzer.class);
        replCodeAnalyzer.topDownAnalyzer = (LazyTopDownAnalyzer)object;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0002\n\u000bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ReplLineAnalysisResult;", "", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "getScriptDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "Successful", "WithErrors", "kotlin-scripting-compiler"})
    public static interface ReplLineAnalysisResult {
        @Nullable
        public ClassDescriptorWithResolutionScopes getScriptDescriptor();

        @NotNull
        public Diagnostics getDiagnostics();

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ReplLineAnalysisResult$Successful;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ReplLineAnalysisResult;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "getScriptDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-scripting-compiler"})
        public static final class Successful
        implements ReplLineAnalysisResult {
            @NotNull
            private final ClassDescriptorWithResolutionScopes scriptDescriptor;
            @NotNull
            private final Diagnostics diagnostics;

            @Override
            @NotNull
            public ClassDescriptorWithResolutionScopes getScriptDescriptor() {
                return this.scriptDescriptor;
            }

            @Override
            @NotNull
            public Diagnostics getDiagnostics() {
                return this.diagnostics;
            }

            public Successful(@NotNull ClassDescriptorWithResolutionScopes scriptDescriptor, @NotNull Diagnostics diagnostics) {
                Intrinsics.checkParameterIsNotNull((Object)scriptDescriptor, (String)"scriptDescriptor");
                Intrinsics.checkParameterIsNotNull((Object)diagnostics, (String)"diagnostics");
                this.scriptDescriptor = scriptDescriptor;
                this.diagnostics = diagnostics;
            }

            @NotNull
            public final ClassDescriptorWithResolutionScopes component1() {
                return this.getScriptDescriptor();
            }

            @NotNull
            public final Diagnostics component2() {
                return this.getDiagnostics();
            }

            @NotNull
            public final Successful copy(@NotNull ClassDescriptorWithResolutionScopes scriptDescriptor, @NotNull Diagnostics diagnostics) {
                Intrinsics.checkParameterIsNotNull((Object)scriptDescriptor, (String)"scriptDescriptor");
                Intrinsics.checkParameterIsNotNull((Object)diagnostics, (String)"diagnostics");
                return new Successful(scriptDescriptor, diagnostics);
            }

            public static /* synthetic */ Successful copy$default(Successful successful, ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes, Diagnostics diagnostics, int n, Object object) {
                if ((n & 1) != 0) {
                    classDescriptorWithResolutionScopes = successful.getScriptDescriptor();
                }
                if ((n & 2) != 0) {
                    diagnostics = successful.getDiagnostics();
                }
                return successful.copy(classDescriptorWithResolutionScopes, diagnostics);
            }

            @NotNull
            public String toString() {
                return "Successful(scriptDescriptor=" + this.getScriptDescriptor() + ", diagnostics=" + this.getDiagnostics() + ")";
            }

            public int hashCode() {
                ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = this.getScriptDescriptor();
                Diagnostics diagnostics = this.getDiagnostics();
                return (classDescriptorWithResolutionScopes != null ? classDescriptorWithResolutionScopes.hashCode() : 0) * 31 + (diagnostics != null ? diagnostics.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Successful)) break block3;
                        Successful successful = (Successful)object;
                        if (!Intrinsics.areEqual((Object)this.getScriptDescriptor(), (Object)successful.getScriptDescriptor()) || !Intrinsics.areEqual((Object)this.getDiagnostics(), (Object)successful.getDiagnostics())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ReplLineAnalysisResult$WithErrors;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ReplLineAnalysisResult;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "getScriptDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-scripting-compiler"})
        public static final class WithErrors
        implements ReplLineAnalysisResult {
            @NotNull
            private final Diagnostics diagnostics;

            @Override
            @Nullable
            public ClassDescriptorWithResolutionScopes getScriptDescriptor() {
                return null;
            }

            @Override
            @NotNull
            public Diagnostics getDiagnostics() {
                return this.diagnostics;
            }

            public WithErrors(@NotNull Diagnostics diagnostics) {
                Intrinsics.checkParameterIsNotNull((Object)diagnostics, (String)"diagnostics");
                this.diagnostics = diagnostics;
            }

            @NotNull
            public final Diagnostics component1() {
                return this.getDiagnostics();
            }

            @NotNull
            public final WithErrors copy(@NotNull Diagnostics diagnostics) {
                Intrinsics.checkParameterIsNotNull((Object)diagnostics, (String)"diagnostics");
                return new WithErrors(diagnostics);
            }

            public static /* synthetic */ WithErrors copy$default(WithErrors withErrors, Diagnostics diagnostics, int n, Object object) {
                if ((n & 1) != 0) {
                    diagnostics = withErrors.getDiagnostics();
                }
                return withErrors.copy(diagnostics);
            }

            @NotNull
            public String toString() {
                return "WithErrors(diagnostics=" + this.getDiagnostics() + ")";
            }

            public int hashCode() {
                Diagnostics diagnostics = this.getDiagnostics();
                return diagnostics != null ? diagnostics.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof WithErrors)) break block3;
                        WithErrors withErrors = (WithErrors)object;
                        if (!Intrinsics.areEqual((Object)this.getDiagnostics(), (Object)withErrors.getDiagnostics())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ScriptMutableDeclarationProviderFactory;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/DeclarationProviderFactory;", "()V", "delegateFactory", "rootPackageProvider", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ScriptMutableDeclarationProviderFactory$AdaptablePackageMemberDeclarationProvider;", "diagnoseMissingPackageFragment", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getClassMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/ClassMemberDeclarationProvider;", "classLikeInfo", "Lorg/jetbrains/kotlin/resolve/lazy/data/KtClassLikeInfo;", "getPackageMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "packageFqName", "setDelegateFactory", "AdaptablePackageMemberDeclarationProvider", "kotlin-scripting-compiler"})
    private static final class ScriptMutableDeclarationProviderFactory
    implements DeclarationProviderFactory {
        private DeclarationProviderFactory delegateFactory;
        private AdaptablePackageMemberDeclarationProvider rootPackageProvider;

        public final void setDelegateFactory(@NotNull DeclarationProviderFactory delegateFactory) {
            Intrinsics.checkParameterIsNotNull((Object)delegateFactory, (String)"delegateFactory");
            this.delegateFactory = delegateFactory;
            PackageMemberDeclarationProvider packageMemberDeclarationProvider = delegateFactory.getPackageMemberDeclarationProvider(FqName.ROOT);
            if (packageMemberDeclarationProvider == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)packageMemberDeclarationProvider, (String)"delegateFactory.getPacka\u2026onProvider(FqName.ROOT)!!");
            PackageMemberDeclarationProvider provider = packageMemberDeclarationProvider;
            try {
                AdaptablePackageMemberDeclarationProvider adaptablePackageMemberDeclarationProvider = this.rootPackageProvider;
                if (adaptablePackageMemberDeclarationProvider == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rootPackageProvider");
                }
                adaptablePackageMemberDeclarationProvider.addDelegateProvider(provider);
            }
            catch (UninitializedPropertyAccessException e) {
                this.rootPackageProvider = new AdaptablePackageMemberDeclarationProvider(provider);
            }
        }

        @NotNull
        public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull KtClassLikeInfo classLikeInfo) {
            Intrinsics.checkParameterIsNotNull((Object)classLikeInfo, (String)"classLikeInfo");
            DeclarationProviderFactory declarationProviderFactory = this.delegateFactory;
            if (declarationProviderFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegateFactory");
            }
            ClassMemberDeclarationProvider classMemberDeclarationProvider = declarationProviderFactory.getClassMemberDeclarationProvider(classLikeInfo);
            Intrinsics.checkExpressionValueIsNotNull((Object)classMemberDeclarationProvider, (String)"delegateFactory.getClass\u2026onProvider(classLikeInfo)");
            return classMemberDeclarationProvider;
        }

        @Nullable
        public PackageMemberDeclarationProvider getPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
            Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
            if (packageFqName.isRoot()) {
                AdaptablePackageMemberDeclarationProvider adaptablePackageMemberDeclarationProvider = this.rootPackageProvider;
                if (adaptablePackageMemberDeclarationProvider == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rootPackageProvider");
                }
                return adaptablePackageMemberDeclarationProvider;
            }
            DeclarationProviderFactory declarationProviderFactory = this.delegateFactory;
            if (declarationProviderFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegateFactory");
            }
            return declarationProviderFactory.getPackageMemberDeclarationProvider(packageFqName);
        }

        public void diagnoseMissingPackageFragment(@NotNull FqName fqName, @Nullable KtFile file) {
            Intrinsics.checkParameterIsNotNull((Object)fqName, (String)"fqName");
            DeclarationProviderFactory declarationProviderFactory = this.delegateFactory;
            if (declarationProviderFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegateFactory");
            }
            declarationProviderFactory.diagnoseMissingPackageFragment(fqName, file);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ScriptMutableDeclarationProviderFactory$AdaptablePackageMemberDeclarationProvider;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/DelegatePackageMemberDeclarationProvider;", "delegateProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "(Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;)V", "addDelegateProvider", "", "provider", "kotlin-scripting-compiler"})
        public static final class AdaptablePackageMemberDeclarationProvider
        extends DelegatePackageMemberDeclarationProvider {
            private PackageMemberDeclarationProvider delegateProvider;

            public final void addDelegateProvider(@NotNull PackageMemberDeclarationProvider provider) {
                Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
                this.delegateProvider = (PackageMemberDeclarationProvider)new CombinedPackageMemberDeclarationProvider((Collection)CollectionsKt.listOf((Object[])new PackageMemberDeclarationProvider[]{provider, this.delegateProvider}));
                this.setDelegate(this.delegateProvider);
            }

            public AdaptablePackageMemberDeclarationProvider(@NotNull PackageMemberDeclarationProvider delegateProvider) {
                Intrinsics.checkParameterIsNotNull((Object)delegateProvider, (String)"delegateProvider");
                super(delegateProvider);
                this.delegateProvider = delegateProvider;
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState;", "", "()V", "submittedLines", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo;", "Lkotlin/collections/HashMap;", "successfulLines", "Lorg/jetbrains/kotlin/cli/common/repl/ReplHistory;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "computeFileScopes", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopes;", "lineInfo", "fileScopeFactory", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeFactory;", "lineFailure", "", "ktFile", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "lineSuccess", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "reset", "", "resetToLine", "lineId", "Lorg/jetbrains/kotlin/cli/common/repl/ILineId;", "submitLine", "LineInfo", "kotlin-scripting-compiler"})
    public static final class ResettableAnalyzerState {
        private final ReplHistory<LineInfo.SuccessfulLine> successfulLines = new ReplHistory(null, 1, null);
        private final HashMap<KtFile, LineInfo> submittedLines;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ReplCodeLine> resetToLine(@NotNull ILineId lineId) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)lineId, (String)"lineId");
            List removed = this.successfulLines.resetToLine(lineId.getNo());
            Iterable $this$forEach$iv = removed;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                this.submittedLines.remove(((LineInfo.SuccessfulLine)it.getSecond()).getLinePsi());
            }
            Iterable $this$map$iv = removed;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ReplCodeLine replCodeLine = (ReplCodeLine)it.getFirst();
                collection.add(replCodeLine);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ReplCodeLine> reset() {
            void $this$mapTo$iv$iv;
            this.submittedLines.clear();
            Iterable $this$map$iv = this.successfulLines.reset();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ReplCodeLine replCodeLine = (ReplCodeLine)it.getFirst();
                collection.add(replCodeLine);
            }
            return (List)destination$iv$iv;
        }

        public final void submitLine(@NotNull KtFile ktFile, @NotNull ReplCodeLine codeLine) {
            Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
            Intrinsics.checkParameterIsNotNull((Object)codeLine, (String)"codeLine");
            LineInfo.SubmittedLine line = new LineInfo.SubmittedLine(ktFile, (LineInfo.SuccessfulLine)this.successfulLines.lastValue());
            ((Map)this.submittedLines).put(ktFile, line);
            FileScopeProviderKt.setFileScopesCustomizer((KtFile)ktFile, (FileScopesCustomizer)new FileScopesCustomizer(this, ktFile){
                final /* synthetic */ ResettableAnalyzerState this$0;
                final /* synthetic */ KtFile $ktFile;

                @NotNull
                public FileScopes createFileScopes(@NotNull FileScopeFactory fileScopeFactory) {
                    LineInfo lineInfo;
                    block3: {
                        block2: {
                            Intrinsics.checkParameterIsNotNull((Object)fileScopeFactory, (String)"fileScopeFactory");
                            lineInfo = ResettableAnalyzerState.access$lineInfo(this.this$0, this.$ktFile);
                            if (lineInfo == null) break block2;
                            LineInfo lineInfo2 = lineInfo;
                            boolean bl = false;
                            boolean bl2 = false;
                            LineInfo it = lineInfo2;
                            boolean bl3 = false;
                            lineInfo = ResettableAnalyzerState.access$computeFileScopes(this.this$0, it, fileScopeFactory);
                            if (lineInfo != null) break block3;
                        }
                        lineInfo = FileScopeFactory.createScopesForFile$default((FileScopeFactory)fileScopeFactory, (KtFile)this.$ktFile, null, (int)2, null);
                    }
                    return lineInfo;
                }
                {
                    this.this$0 = $outer;
                    this.$ktFile = $captured_local_variable$1;
                }
            });
        }

        public final void lineSuccess(@NotNull KtFile ktFile, @NotNull ReplCodeLine codeLine, @NotNull ClassDescriptorWithResolutionScopes scriptDescriptor) {
            Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
            Intrinsics.checkParameterIsNotNull((Object)codeLine, (String)"codeLine");
            Intrinsics.checkParameterIsNotNull((Object)scriptDescriptor, (String)"scriptDescriptor");
            LineInfo.SuccessfulLine successfulLine = new LineInfo.SuccessfulLine(ktFile, (LineInfo.SuccessfulLine)this.successfulLines.lastValue(), scriptDescriptor);
            ((Map)this.submittedLines).put(ktFile, successfulLine);
            String string = ktFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ktFile.name");
            this.successfulLines.add(new CompiledReplCodeLine(string, codeLine), (Object)successfulLine);
        }

        public final void lineFailure(@NotNull KtFile ktFile, @NotNull ReplCodeLine codeLine) {
            Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
            Intrinsics.checkParameterIsNotNull((Object)codeLine, (String)"codeLine");
            ((Map)this.submittedLines).put(ktFile, new LineInfo.FailedLine(ktFile, (LineInfo.SuccessfulLine)this.successfulLines.lastValue()));
        }

        private final LineInfo lineInfo(KtFile ktFile) {
            return this.submittedLines.get(ktFile);
        }

        private final FileScopes computeFileScopes(LineInfo lineInfo, FileScopeFactory fileScopeFactory) {
            Object element$iv2;
            LineInfo.SuccessfulLine lexicalScopeAfterLastLine;
            block3: {
                LineInfo.SuccessfulLine successfulLine = lineInfo.getParentLine();
                if (successfulLine == null || (successfulLine = successfulLine.getLineDescriptor()) == null || (successfulLine = successfulLine.getScopeForInitializerResolution()) == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)successfulLine, (String)"lineInfo.parentLine?.lin\u2026Resolution ?: return null");
                lexicalScopeAfterLastLine = successfulLine;
                Sequence $this$first$iv = ScopeUtilsKt.getParentsWithSelf((HierarchicalScope)((HierarchicalScope)lexicalScopeAfterLastLine));
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    HierarchicalScope it = (HierarchicalScope)element$iv2;
                    boolean bl = false;
                    if (!(it instanceof ImportingScope)) continue;
                    break block3;
                }
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            Object e = element$iv2;
            if (e == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.ImportingScope");
            }
            ImportingScope lastLineImports = (ImportingScope)e;
            FileScopes scopesForThisLine = fileScopeFactory.createScopesForFile(lineInfo.getLinePsi(), lastLineImports);
            LexicalScope combinedLexicalScopes = ScopeUtilsKt.replaceImportingScopes((LexicalScope)lexicalScopeAfterLastLine, (ImportingScope)scopesForThisLine.getImportingScope());
            return new FileScopes(combinedLexicalScopes, scopesForThisLine.getImportingScope(), scopesForThisLine.getImportForceResolver());
        }

        public ResettableAnalyzerState() {
            ResettableAnalyzerState resettableAnalyzerState = this;
            boolean bl = false;
            HashMap hashMap = new HashMap();
            resettableAnalyzerState.submittedLines = hashMap;
        }

        public static final /* synthetic */ LineInfo access$lineInfo(ResettableAnalyzerState $this, KtFile ktFile) {
            return $this.lineInfo(ktFile);
        }

        public static final /* synthetic */ FileScopes access$computeFileScopes(ResettableAnalyzerState $this, LineInfo lineInfo, FileScopeFactory fileScopeFactory) {
            return $this.computeFileScopes(lineInfo, fileScopeFactory);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0003\u000e\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo;", "", "()V", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "getParentLine", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "FailedLine", "SubmittedLine", "SuccessfulLine", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$SubmittedLine;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$FailedLine;", "kotlin-scripting-compiler"})
        private static abstract class LineInfo {
            @NotNull
            public abstract KtFile getLinePsi();

            @Nullable
            public abstract SuccessfulLine getParentLine();

            private LineInfo() {
            }

            public /* synthetic */ LineInfo(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$SubmittedLine;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$SuccessfulLine;)V", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "kotlin-scripting-compiler"})
            public static final class SubmittedLine
            extends LineInfo {
                @NotNull
                private final KtFile linePsi;
                @Nullable
                private final SuccessfulLine parentLine;

                @Override
                @NotNull
                public KtFile getLinePsi() {
                    return this.linePsi;
                }

                @Override
                @Nullable
                public SuccessfulLine getParentLine() {
                    return this.parentLine;
                }

                public SubmittedLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine) {
                    Intrinsics.checkParameterIsNotNull((Object)linePsi, (String)"linePsi");
                    super(null);
                    this.linePsi = linePsi;
                    this.parentLine = parentLine;
                }
            }

            @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "lineDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$SuccessfulLine;Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;)V", "getLineDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "kotlin-scripting-compiler"})
            public static final class SuccessfulLine
            extends LineInfo {
                @NotNull
                private final KtFile linePsi;
                @Nullable
                private final SuccessfulLine parentLine;
                @NotNull
                private final ClassDescriptorWithResolutionScopes lineDescriptor;

                @Override
                @NotNull
                public KtFile getLinePsi() {
                    return this.linePsi;
                }

                @Override
                @Nullable
                public SuccessfulLine getParentLine() {
                    return this.parentLine;
                }

                @NotNull
                public final ClassDescriptorWithResolutionScopes getLineDescriptor() {
                    return this.lineDescriptor;
                }

                public SuccessfulLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine, @NotNull ClassDescriptorWithResolutionScopes lineDescriptor) {
                    Intrinsics.checkParameterIsNotNull((Object)linePsi, (String)"linePsi");
                    Intrinsics.checkParameterIsNotNull((Object)lineDescriptor, (String)"lineDescriptor");
                    super(null);
                    this.linePsi = linePsi;
                    this.parentLine = parentLine;
                    this.lineDescriptor = lineDescriptor;
                }
            }

            @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$FailedLine;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$SuccessfulLine;)V", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzer$ResettableAnalyzerState$LineInfo$SuccessfulLine;", "kotlin-scripting-compiler"})
            public static final class FailedLine
            extends LineInfo {
                @NotNull
                private final KtFile linePsi;
                @Nullable
                private final SuccessfulLine parentLine;

                @Override
                @NotNull
                public KtFile getLinePsi() {
                    return this.linePsi;
                }

                @Override
                @Nullable
                public SuccessfulLine getParentLine() {
                    return this.parentLine;
                }

                public FailedLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine) {
                    Intrinsics.checkParameterIsNotNull((Object)linePsi, (String)"linePsi");
                    super(null);
                    this.linePsi = linePsi;
                    this.parentLine = parentLine;
                }
            }
        }
    }
}

