/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.operation.AssignmentTranslator;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public final class IntrinsicAssignmentTranslator
extends AssignmentTranslator {
    private final JsExpression right;
    private final AccessTranslator accessTranslator;
    private final boolean rightExpressionTrivial;
    private final JsBlock rightBlock = new JsBlock();

    @NotNull
    public static JsExpression doTranslate(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        return new IntrinsicAssignmentTranslator(expression2, context).translate();
    }

    private IntrinsicAssignmentTranslator(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        super(expression2, context);
        this.right = this.translateRightExpression(context, expression2);
        this.rightExpressionTrivial = this.rightBlock.isEmpty();
        KtExpression left = expression2.getLeft();
        assert (left != null);
        this.accessTranslator = this.createAccessTranslator(left, !this.rightExpressionTrivial);
    }

    private JsExpression translateRightExpression(TranslationContext context, KtBinaryExpression expression2) {
        JsExpression result2 = TranslationUtils.translateRightExpression(context, expression2, this.rightBlock);
        KotlinType leftType = context.bindingContext().getType(expression2.getLeft());
        KotlinType rightType = context.bindingContext().getType(expression2.getRight());
        if (rightType != null && KotlinBuiltIns.isCharOrNullableChar(rightType)) {
            if (leftType != null && KotlinBuiltIns.isStringOrNullableString(leftType)) {
                result2 = JsAstUtils.charToString(result2);
            } else if (leftType != null && !KotlinBuiltIns.isCharOrNullableChar(leftType)) {
                result2 = TranslationUtils.charToBoxedChar(context, result2);
            }
        }
        return result2;
    }

    @NotNull
    private JsExpression translate() {
        if (PsiUtils.isAssignment(PsiUtils.getOperationToken(this.expression))) {
            return this.translateAsPlainAssignment();
        }
        return this.translateAsAssignmentOperation();
    }

    @NotNull
    private JsExpression translateAsAssignmentOperation() {
        if (TranslationUtils.isSimpleNameExpressionNotDelegatedLocalVar(this.expression.getLeft(), this.context()) && this.rightExpressionTrivial) {
            return this.translateAsPlainAssignmentOperation();
        }
        return this.translateAsAssignToCounterpart();
    }

    @NotNull
    private JsExpression translateAsAssignToCounterpart() {
        JsBinaryOperator operator = this.getCounterpartOperator();
        JsExpression oldValue = this.accessTranslator.translateAsGet();
        if (!this.rightExpressionTrivial) {
            oldValue = this.context().defineTemporary(oldValue);
        }
        JsBinaryOperation counterpartOperation = new JsBinaryOperation(operator, oldValue, this.right);
        this.context().addStatementsToCurrentBlockFrom(this.rightBlock);
        return this.accessTranslator.translateAsSet(counterpartOperation);
    }

    @NotNull
    private JsBinaryOperator getCounterpartOperator() {
        KtToken assignmentOperationToken = PsiUtils.getOperationToken(this.expression);
        assert (assignmentOperationToken instanceof KtSingleValueToken);
        assert (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(assignmentOperationToken));
        KtToken counterpartToken = (KtToken)OperatorConventions.ASSIGNMENT_OPERATION_COUNTERPARTS.get(assignmentOperationToken);
        assert (OperatorTable.hasCorrespondingBinaryOperator(counterpartToken)) : "Unsupported token encountered: " + counterpartToken.toString();
        return OperatorTable.getBinaryOperator(counterpartToken);
    }

    @NotNull
    private JsExpression translateAsPlainAssignmentOperation() {
        this.context().addStatementsToCurrentBlockFrom(this.rightBlock);
        JsBinaryOperator operator = this.getAssignmentOperator();
        return new JsBinaryOperation(operator, this.accessTranslator.translateAsGet(), this.right);
    }

    @NotNull
    private JsBinaryOperator getAssignmentOperator() {
        KtToken token = PsiUtils.getOperationToken(this.expression);
        assert (token instanceof KtSingleValueToken);
        assert (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(token));
        assert (OperatorTable.hasCorrespondingBinaryOperator(token)) : "Unsupported token encountered: " + token.toString();
        return OperatorTable.getBinaryOperator(token);
    }

    @NotNull
    private JsExpression translateAsPlainAssignment() {
        this.context().addStatementsToCurrentBlockFrom(this.rightBlock);
        return this.accessTranslator.translateAsSet(this.right);
    }
}

