/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.RuleListener;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.api.RulesEngine;
import org.jeasy.rules.core.DefaultRuleListener;
import org.jeasy.rules.core.RulesEngineParameters;
import org.jeasy.rules.core.Utils;

public final class DefaultRulesEngine
implements RulesEngine {
    private static final Logger LOGGER = Logger.getLogger(RulesEngine.class.getName());
    private RulesEngineParameters parameters;
    private List<RuleListener> ruleListeners;

    public DefaultRulesEngine() {
        this.parameters = new RulesEngineParameters();
        this.ruleListeners = new ArrayList<RuleListener>();
        this.ruleListeners.add(new DefaultRuleListener());
    }

    DefaultRulesEngine(RulesEngineParameters parameters, List<RuleListener> ruleListeners) {
        this.parameters = parameters;
        this.ruleListeners = ruleListeners;
        this.ruleListeners.add(new DefaultRuleListener());
        if (parameters.isSilentMode()) {
            Utils.muteLoggers();
        }
    }

    @Override
    public RulesEngineParameters getParameters() {
        return this.parameters;
    }

    @Override
    public List<RuleListener> getRuleListeners() {
        return this.ruleListeners;
    }

    @Override
    public void fire(Rules rules, Facts facts) {
        if (rules.isEmpty()) {
            LOGGER.warning("No rules registered! Nothing to apply");
            return;
        }
        this.sort(rules);
        this.logEngineParameters();
        this.log(rules);
        this.log(facts);
        this.apply(rules, facts);
    }

    @Override
    public Map<Rule, Boolean> check(Rules rules, Facts facts) {
        LOGGER.info("Checking rules");
        this.sort(rules);
        HashMap<Rule, Boolean> result = new HashMap<Rule, Boolean>();
        for (Rule rule : rules) {
            if (!this.shouldBeEvaluated(rule, facts)) continue;
            result.put(rule, rule.evaluate(facts));
        }
        return result;
    }

    private void sort(Rules rules) {
        rules.sort();
    }

    private void apply(Rules rules, Facts facts) {
        LOGGER.info("Rules evaluation started");
        for (Rule rule : rules) {
            String name = rule.getName();
            int priority = rule.getPriority();
            if (priority > this.parameters.getPriorityThreshold()) {
                LOGGER.log(Level.INFO, "Rule priority threshold ({0}) exceeded at rule ''{1}'' with priority={2}, next rules will be skipped", new Object[]{this.parameters.getPriorityThreshold(), name, priority});
                break;
            }
            if (!this.shouldBeEvaluated(rule, facts)) {
                LOGGER.log(Level.INFO, "Rule ''{0}'' has been skipped before being evaluated", name);
                continue;
            }
            if (rule.evaluate(facts)) {
                this.triggerListenersAfterEvaluate(rule, facts, true);
                try {
                    this.triggerListenersBeforeExecute(rule, facts);
                    rule.execute(facts);
                    this.triggerListenersOnSuccess(rule, facts);
                    if (!this.parameters.isSkipOnFirstAppliedRule()) continue;
                    LOGGER.info("Next rules will be skipped since parameter skipOnFirstAppliedRule is set");
                }
                catch (Exception exception) {
                    this.triggerListenersOnFailure(rule, exception, facts);
                    if (!this.parameters.isSkipOnFirstFailedRule()) continue;
                    LOGGER.info("Next rules will be skipped since parameter skipOnFirstFailedRule is set");
                }
                break;
            }
            this.triggerListenersAfterEvaluate(rule, facts, false);
            if (!this.parameters.isSkipOnFirstNonTriggeredRule()) continue;
            LOGGER.info("Next rules will be skipped since parameter skipOnFirstNonTriggeredRule is set");
            break;
        }
    }

    private void triggerListenersOnFailure(Rule rule, Exception exception, Facts facts) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.onFailure(rule, facts, exception);
        }
    }

    private void triggerListenersOnSuccess(Rule rule, Facts facts) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.onSuccess(rule, facts);
        }
    }

    private void triggerListenersBeforeExecute(Rule rule, Facts facts) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.beforeExecute(rule, facts);
        }
    }

    private boolean triggerListenersBeforeEvaluate(Rule rule, Facts facts) {
        for (RuleListener ruleListener : this.ruleListeners) {
            if (ruleListener.beforeEvaluate(rule, facts)) continue;
            return false;
        }
        return true;
    }

    private void triggerListenersAfterEvaluate(Rule rule, Facts facts, boolean evaluationResult) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.afterEvaluate(rule, facts, evaluationResult);
        }
    }

    private boolean shouldBeEvaluated(Rule rule, Facts facts) {
        return this.triggerListenersBeforeEvaluate(rule, facts);
    }

    private void logEngineParameters() {
        LOGGER.log(Level.INFO, "Rule priority threshold: {0}", this.parameters.getPriorityThreshold());
        LOGGER.log(Level.INFO, "Skip on first applied rule: {0}", this.parameters.isSkipOnFirstAppliedRule());
        LOGGER.log(Level.INFO, "Skip on first non triggered rule: {0}", this.parameters.isSkipOnFirstNonTriggeredRule());
        LOGGER.log(Level.INFO, "Skip on first failed rule: {0}", this.parameters.isSkipOnFirstFailedRule());
    }

    private void log(Rules rules) {
        LOGGER.log(Level.INFO, "Registered rules:");
        for (Rule rule : rules) {
            LOGGER.log(Level.INFO, String.format("Rule { name = '%s', description = '%s', priority = '%s'}", rule.getName(), rule.getDescription(), rule.getPriority()));
        }
    }

    private void log(Facts facts) {
        LOGGER.log(Level.INFO, "Known facts:");
        for (Map.Entry<String, Object> fact : facts) {
            LOGGER.log(Level.INFO, String.format("Fact { %s : %s }", fact.getKey(), fact.getValue() == null ? "null" : fact.getValue().toString()));
        }
    }
}

