/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.RuleListener;

class DefaultRuleListener
implements RuleListener {
    private static final Logger LOGGER = Logger.getLogger(DefaultRuleListener.class.getName());

    DefaultRuleListener() {
    }

    @Override
    public boolean beforeEvaluate(Rule rule, Facts facts) {
        return true;
    }

    @Override
    public void afterEvaluate(Rule rule, Facts facts, boolean evaluationResult) {
        String ruleName = rule.getName();
        if (evaluationResult) {
            LOGGER.log(Level.INFO, "Rule ''{0}'' triggered", ruleName);
        } else {
            LOGGER.log(Level.INFO, "Rule ''{0}'' has been evaluated to false, it has not been executed", ruleName);
        }
    }

    @Override
    public void beforeExecute(Rule rule, Facts facts) {
    }

    @Override
    public void onSuccess(Rule rule, Facts facts) {
        LOGGER.log(Level.INFO, "Rule ''{0}'' performed successfully", rule.getName());
    }

    @Override
    public void onFailure(Rule rule, Facts facts, Exception exception) {
        LOGGER.log(Level.SEVERE, String.format("Rule '%s' performed with error", rule.getName()), exception);
    }
}

