/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.transaction;

import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.internal.exceptions.Sneaky;
import org.jdbi.v3.core.transaction.DelegatingTransactionHandler;
import org.jdbi.v3.core.transaction.LocalTransactionHandler;
import org.jdbi.v3.core.transaction.TransactionHandler;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;

public class SerializableTransactionRunner
extends DelegatingTransactionHandler
implements TransactionHandler {
    private static final String SQLSTATE_TXN_SERIALIZATION_FAILED = "40001";

    public SerializableTransactionRunner() {
        this(LocalTransactionHandler.binding());
    }

    public SerializableTransactionRunner(TransactionHandler delegate) {
        super(delegate);
    }

    @Override
    public <R, X extends Exception> R inTransaction(Handle handle, HandleCallback<R, X> callback) throws X {
        Configuration config = handle.getConfig(Configuration.class);
        int attempts = 1 + config.maxRetries;
        ArrayDeque<Exception> failures = new ArrayDeque<Exception>();
        while (true) {
            try {
                R result = this.getDelegate().inTransaction(handle, callback);
                config.onSuccess.accept(new ArrayList(failures));
                return result;
            }
            catch (Exception last) {
                if (!this.isSqlState(config.serializationFailureSqlState, last)) {
                    throw last;
                }
                failures.addLast(last);
                config.onFailure.accept(new ArrayList(failures));
                if (--attempts > 0) continue;
                Exception toThrow = (Exception)failures.removeLast();
                while (!failures.isEmpty()) {
                    toThrow.addSuppressed((Throwable)failures.removeLast());
                }
                throw Sneaky.throwAnyway(toThrow);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R, X extends Exception> R inTransaction(Handle handle, TransactionIsolationLevel level, HandleCallback<R, X> callback) throws X {
        TransactionIsolationLevel initial = handle.getTransactionIsolationLevel();
        try {
            handle.setTransactionIsolationLevel(level);
            R r = this.inTransaction(handle, callback);
            return r;
        }
        finally {
            handle.setTransactionIsolationLevel(initial);
        }
    }

    @Override
    public TransactionHandler specialize(Handle handle) throws SQLException {
        return new SerializableTransactionRunner(this.getDelegate().specialize(handle));
    }

    protected boolean isSqlState(String expectedSqlState, Throwable throwable) {
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!(t instanceof SQLException)) continue;
            SQLException e = (SQLException)t;
            for (Throwable next : e) {
                SQLException s;
                String sqlState;
                if (!(next instanceof SQLException) || (sqlState = (s = (SQLException)next).getSQLState()) == null || !sqlState.startsWith(expectedSqlState)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static class Configuration
    implements JdbiConfig<Configuration> {
        private static final int DEFAULT_MAX_RETRIES = 5;
        private static final Consumer<List<Exception>> NOP = list -> {};
        private int maxRetries = 5;
        private String serializationFailureSqlState = "40001";
        private Consumer<List<Exception>> onFailure = NOP;
        private Consumer<List<Exception>> onSuccess = NOP;

        public Configuration() {
        }

        private Configuration(Configuration that) {
            this.maxRetries = that.maxRetries;
            this.serializationFailureSqlState = that.serializationFailureSqlState;
            this.onFailure = that.onFailure;
            this.onSuccess = that.onSuccess;
        }

        public Configuration setMaxRetries(int maxRetries) {
            if (maxRetries < 0) {
                throw new IllegalArgumentException("\"" + maxRetries + " retries\" makes no sense. Set a number >= 0 (default 5).");
            }
            this.maxRetries = maxRetries;
            return this;
        }

        public Configuration setSerializationFailureSqlState(String serializationFailureSqlState) {
            this.serializationFailureSqlState = serializationFailureSqlState;
            return this;
        }

        public Configuration setOnFailure(Consumer<List<Exception>> onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        public Configuration setOnSuccess(Consumer<List<Exception>> onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        @Override
        public Configuration createCopy() {
            return new Configuration(this);
        }
    }
}

