/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import com.google.errorprone.annotations.CheckReturnValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.argument.internal.NamedArgumentFinderFactory;
import org.jdbi.v3.core.argument.internal.TypedValue;
import org.jdbi.v3.core.internal.exceptions.CheckedConsumer;
import org.jdbi.v3.core.internal.exceptions.Sneaky;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifiers;
import org.jdbi.v3.core.statement.Binding;
import org.jdbi.v3.core.statement.DescribedArgument;
import org.jdbi.v3.core.statement.ParsedParameters;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.core.statement.internal.PreparedBinding;

class ArgumentBinder {
    final PreparedStatement stmt;
    final StatementContext ctx;
    final ParsedParameters params;
    final Map<QualifiedType<?>, Function<Object, Argument>> argumentFactoryByType = new HashMap();
    private final Argument nullArgument;

    ArgumentBinder(PreparedStatement stmt, StatementContext ctx, ParsedParameters params) {
        this.stmt = stmt;
        this.ctx = ctx;
        this.params = params;
        this.nullArgument = ctx.getConfig(Arguments.class).getUntypedNullArgument();
    }

    void bind(Binding binding) {
        if (this.params.isPositional()) {
            this.bindPositional(binding);
        } else {
            this.bindNamed(binding);
        }
    }

    void bindPositional(Binding binding) {
        boolean moreArgumentsProvidedThanDeclared;
        for (int index = 0; index < this.params.getParameterCount(); ++index) {
            if (!binding.positionals.containsKey(index)) {
                throw new UnableToCreateStatementException(String.format("Missing positional parameter %d in binding:%s", index, binding), this.ctx);
            }
            QualifiedType<?> type = this.typeOf(binding.positionals.get(index));
            try {
                this.argumentFactoryForType(type).apply(ArgumentBinder.unwrap(binding.positionals.get(index))).apply(index + 1, this.stmt, this.ctx);
                continue;
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException("Exception while binding positional param at (0 based) position " + index, e, this.ctx);
            }
        }
        boolean bl = moreArgumentsProvidedThanDeclared = binding.positionals.size() != this.params.getParameterCount();
        if (moreArgumentsProvidedThanDeclared && !this.ctx.getConfig(SqlStatements.class).isUnusedBindingAllowed()) {
            throw new UnableToCreateStatementException("Superfluous positional param at (0 based) position " + this.params.getParameterCount(), this.ctx);
        }
    }

    void bindNamed(Binding binding) {
        List<String> paramNames = this.params.getParameterNames();
        this.bindNamedCheck(binding, paramNames);
        block2: for (int i = 0; i < paramNames.size(); ++i) {
            String name = paramNames.get(i);
            try {
                Object value = binding.named.get(name);
                if (value == null) {
                    if (binding.named.containsKey(name)) {
                        this.nullArgument.apply(i + 1, this.stmt, this.ctx);
                        continue;
                    }
                    for (NamedArgumentFinder naf : binding.namedArgumentFinder) {
                        Optional<Argument> found = naf.find(name, this.ctx);
                        if (!found.isPresent()) continue;
                        found.get().apply(i + 1, this.stmt, this.ctx);
                        continue block2;
                    }
                    throw this.missingNamedParameter(name, binding);
                }
                if (value instanceof Argument) {
                    Argument argument = (Argument)value;
                    argument.apply(i + 1, this.stmt, this.ctx);
                    continue;
                }
                this.argumentFactoryForType(this.typeOf(value)).apply(ArgumentBinder.unwrap(value)).apply(i + 1, this.stmt, this.ctx);
                continue;
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException(String.format("Exception while binding named parameter '%s'", name), e, this.ctx);
            }
        }
    }

    void bindNamedCheck(Binding binding, List<String> paramNames) {
        boolean argumentsProvidedButNoneDeclared;
        boolean bl = argumentsProvidedButNoneDeclared = paramNames.isEmpty() && !binding.isEmpty();
        if (argumentsProvidedButNoneDeclared && !this.ctx.getConfig(SqlStatements.class).isUnusedBindingAllowed()) {
            throw new UnableToCreateStatementException(String.format("Superfluous named parameters provided while the query declares none: '%s'. This check may be disabled by calling getConfig(SqlStatements.class).setUnusedBindingAllowed(true) or using @AllowUnusedBindings in SQL object.", binding), this.ctx);
        }
    }

    @Nonnull
    QualifiedType<?> typeOf(@Nullable Object value) {
        QualifiedType<?> qualifiedType;
        if (value instanceof TypedValue) {
            TypedValue t = (TypedValue)value;
            qualifiedType = t.getType();
        } else {
            qualifiedType = this.ctx.getConfig(Qualifiers.class).qualifiedTypeOf(Optional.ofNullable(value).map(Object::getClass).orElse(Object.class));
        }
        return qualifiedType;
    }

    @Deprecated(since="3.11.0", forRemoval=true)
    Argument toArgument(Object found) {
        return this.argumentFactoryForType(this.typeOf(found)).apply(ArgumentBinder.unwrap(found));
    }

    Function<Object, Argument> argumentFactoryForType(QualifiedType<?> type) {
        return this.argumentFactoryByType.computeIfAbsent(type, qt -> {
            Arguments args = this.ctx.getConfig(Arguments.class);
            Function<Object, Argument> factory = args.prepareFor(type).orElse(v -> args.findFor(type, v).orElseThrow(() -> this.factoryNotFound(type, v)));
            return value -> DescribedArgument.wrap(this.ctx, (Argument)factory.apply(value), value);
        });
    }

    UnableToCreateStatementException missingNamedParameter(String name, Binding binding) {
        return new UnableToCreateStatementException(String.format("Missing named parameter '%s' in binding:%s", name, binding), this.ctx);
    }

    <T> Consumer<T> wrapCheckedConsumer(String paramName, CheckedConsumer<T> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException(String.format("Exception while binding named parameter '%s'", paramName), e, this.ctx);
            }
            catch (Exception e) {
                throw Sneaky.throwAnyway(e);
            }
        };
    }

    private UnableToCreateStatementException factoryNotFound(QualifiedType<?> qualifiedType, Object value) {
        Class clazz;
        Object[] typeVars;
        Type type = qualifiedType.getType();
        if (type instanceof Class && (typeVars = (clazz = (Class)type).getTypeParameters()).length > 0) {
            return new UnableToCreateStatementException("No type parameters found for erased type '" + String.valueOf(type) + Arrays.toString(typeVars) + "' with qualifiers '" + String.valueOf(qualifiedType.getQualifiers()) + "'. To bind a generic type, prefer using bindByType.");
        }
        return new UnableToCreateStatementException("No argument factory registered for '" + String.valueOf(value) + "' of qualified type " + String.valueOf(qualifiedType), this.ctx);
    }

    @CheckReturnValue
    static Object unwrap(@Nullable Object maybeTypedValue) {
        Object object;
        if (maybeTypedValue instanceof TypedValue) {
            TypedValue t = (TypedValue)maybeTypedValue;
            object = t.getValue();
        } else {
            object = maybeTypedValue;
        }
        return object;
    }

    static class Prepared
    extends ArgumentBinder {
        private final PreparedBatch batch;
        private final Consumer<PreparedBinding> preparedBinder;
        private final List<String> paramNames;

        Prepared(PreparedBatch batch, ParsedParameters params, PreparedBinding preparedBindingTemplate) {
            super(batch.stmt, batch.getContext(), params);
            this.batch = batch;
            this.paramNames = params.getParameterNames();
            this.preparedBinder = this.prepareBinder(preparedBindingTemplate);
        }

        private Consumer<PreparedBinding> prepareBinder(PreparedBinding preparedBindingTemplate) {
            ArrayList<Consumer<PreparedBinding>> innerBinders = new ArrayList<Consumer<PreparedBinding>>(this.paramNames.size());
            for (int i = 0; i < this.paramNames.size(); ++i) {
                int index = i;
                String name = this.paramNames.get(i);
                Object value = preparedBindingTemplate.named.get(name);
                if (value == null && !preparedBindingTemplate.named.containsKey(name)) {
                    Optional preparation = preparedBindingTemplate.prepareKeys.keySet().stream().map(pk -> new AbstractMap.SimpleImmutableEntry<NamedArgumentFinderFactory.PrepareKey, Function<String, Optional<Function<Object, Argument>>>>((NamedArgumentFinderFactory.PrepareKey)pk, this.batch.preparedFinders.get(pk))).flatMap(e -> ((Optional)((Function)e.getValue()).apply(name)).map(pf -> new AbstractMap.SimpleImmutableEntry<NamedArgumentFinderFactory.PrepareKey, Function>((NamedArgumentFinderFactory.PrepareKey)e.getKey(), (Function)pf)).stream()).findFirst();
                    if (preparation.isPresent()) {
                        Map.Entry p = (Map.Entry)preparation.get();
                        innerBinders.add(this.wrapCheckedConsumer(name, binding -> ((Argument)((Function)p.getValue()).apply(binding.prepareKeys.get(p.getKey()))).apply(index + 1, this.stmt, this.ctx)));
                        continue;
                    }
                    innerBinders.add(this.wrapCheckedConsumer(name, binding -> binding.namedArgumentFinder.stream().flatMap(naf -> naf.find(name, this.ctx).stream()).findFirst().orElseGet(() -> (Argument)binding.realizedBackupArgumentFinders.get().stream().flatMap(naf -> naf.find(name, this.ctx).stream()).findFirst().orElseThrow(() -> this.missingNamedParameter(name, (Binding)binding))).apply(index + 1, this.stmt, this.ctx)));
                    continue;
                }
                Function<Object, Argument> binder = this.argumentFactoryForType(this.typeOf(value));
                innerBinders.add(this.wrapCheckedConsumer(name, binding -> ((Argument)binder.apply(Prepared.unwrap(binding.named.get(name)))).apply(index + 1, this.stmt, this.ctx)));
            }
            return binding -> innerBinders.forEach(b -> b.accept(binding));
        }

        @Override
        void bindNamed(Binding binding) {
            this.bindNamedCheck(binding, this.paramNames);
            this.preparedBinder.accept((PreparedBinding)binding);
        }
    }
}

