/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Stream;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.mapper.reflect.ConstructorInstanceFactory;
import org.jdbi.v3.core.mapper.reflect.InstanceFactory;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;
import org.jdbi.v3.core.mapper.reflect.StaticMethodInstanceFactory;

public class JdbiConstructors {
    private JdbiConstructors() {
        throw new UtilityClassException();
    }

    static <T> InstanceFactory<T> findFactoryFor(Class<T> type) {
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        List<Constructor> explicitConstructors = Stream.of(constructors).filter(constructor -> constructor.isAnnotationPresent(JdbiConstructor.class)).filter(constructor -> !constructor.isSynthetic()).toList();
        List<Method> explicitFactoryMethods = Stream.of(type.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(JdbiConstructor.class)).toList();
        if (explicitConstructors.size() + explicitFactoryMethods.size() > 1) {
            throw new IllegalArgumentException(String.valueOf(type) + " may have at most one constructor or static factory method annotated @JdbiConstructor");
        }
        if (explicitConstructors.size() == 1) {
            return new ConstructorInstanceFactory(explicitConstructors.get(0));
        }
        if (explicitFactoryMethods.size() == 1) {
            return new StaticMethodInstanceFactory<T>(type, explicitFactoryMethods.get(0));
        }
        return new ConstructorInstanceFactory<T>(JdbiConstructors.findImplicitConstructorFor(type));
    }

    static <T> InstanceFactory<T> findFactoryFor(Class<T> factoryReturnType, Class<?> factoryMethodClass) {
        List<Method> allFactoryMethods = Stream.of(factoryMethodClass.getDeclaredMethods()).filter(method -> method.getReturnType().equals(factoryReturnType)).toList();
        List<Method> explicitFactoryMethods = allFactoryMethods.stream().filter(method -> method.isAnnotationPresent(JdbiConstructor.class)).toList();
        if (explicitFactoryMethods.size() == 1) {
            return new StaticMethodInstanceFactory<T>(factoryReturnType, explicitFactoryMethods.get(0));
        }
        if (allFactoryMethods.size() == 1) {
            return new StaticMethodInstanceFactory<T>(factoryReturnType, allFactoryMethods.get(0));
        }
        throw new IllegalArgumentException(String.format("%s must have exactly one factory method returning %s, or specify it with @JdbiConstructor", factoryMethodClass, factoryReturnType));
    }

    public static <T> Constructor<T> findConstructorFor(Class<T> type) {
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        List<Constructor> annotatedConstructors = Stream.of(constructors).filter(c -> c.isAnnotationPresent(JdbiConstructor.class)).toList();
        if (annotatedConstructors.size() > 1) {
            throw new IllegalArgumentException(String.valueOf(type) + " may have at most one constructor annotated @JdbiConstructor");
        }
        if (annotatedConstructors.size() == 1) {
            return annotatedConstructors.get(0);
        }
        return JdbiConstructors.findImplicitConstructorFor(type);
    }

    private static <T> Constructor<T> findImplicitConstructorFor(Class<T> type) {
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        List<Constructor> annotatedConstructors = Stream.of(constructors).filter(c -> c.isAnnotationPresent(ConstructorProperties.class)).toList();
        if (annotatedConstructors.size() > 1) {
            throw new IllegalArgumentException(String.valueOf(type) + " may have at most one constructor annotated @ConstructorProperties");
        }
        if (annotatedConstructors.size() == 1) {
            return annotatedConstructors.get(0);
        }
        if (constructors.length != 1) {
            throw new IllegalArgumentException(String.valueOf(type) + " must have exactly one constructor, or specify it with @JdbiConstructor or @ConstructorProperties");
        }
        return constructors[0];
    }
}

