/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.statement.ColonPrefixSqlParser;
import org.jdbi.v3.core.statement.DefinedAttributeTemplateEngine;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementContextListener;
import org.jdbi.v3.core.statement.StatementCustomizer;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.core.statement.TimingCollector;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.meta.Beta;

public final class SqlStatements
implements JdbiConfig<SqlStatements> {
    private final Map<String, Object> attributes;
    private TemplateEngine templateEngine;
    private Cache<StatementCacheKey, Function<StatementContext, String>> templateCache;
    private SqlParser sqlParser;
    private SqlLogger sqlLogger;
    private Integer queryTimeout;
    private boolean allowUnusedBindings;
    private final Collection<StatementCustomizer> customizers = new CopyOnWriteArrayList<StatementCustomizer>();
    private final Collection<StatementContextListener> contextListeners = new CopyOnWriteArraySet<StatementContextListener>();

    public SqlStatements() {
        this.attributes = Collections.synchronizedMap(new HashMap());
        this.templateEngine = new DefinedAttributeTemplateEngine();
        this.sqlParser = new ColonPrefixSqlParser();
        this.sqlLogger = SqlLogger.NOP_SQL_LOGGER;
        this.queryTimeout = null;
        this.templateCache = Caffeine.newBuilder().maximumSize(1000L).build();
    }

    private SqlStatements(SqlStatements that) {
        this.attributes = Collections.synchronizedMap(that.getAttributes());
        this.templateEngine = that.templateEngine;
        this.sqlParser = that.sqlParser;
        this.sqlLogger = that.sqlLogger;
        this.queryTimeout = that.queryTimeout;
        this.allowUnusedBindings = that.allowUnusedBindings;
        this.customizers.addAll(that.customizers);
        this.contextListeners.addAll(that.contextListeners);
        this.templateCache = that.templateCache;
    }

    public SqlStatements define(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public SqlStatements defineMap(Map<String, ?> values) {
        if (values != null) {
            this.attributes.putAll(values);
        }
        return this;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>(this.attributes);
    }

    public SqlStatements addCustomizer(StatementCustomizer customizer) {
        this.customizers.add(customizer);
        return this;
    }

    public SqlStatements addContextListener(StatementContextListener listener) {
        this.contextListeners.add(listener);
        return this;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public SqlStatements setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        return this;
    }

    @Beta
    public SqlStatements setTemplateCache(Caffeine<Object, Object> caffeineSpec) {
        this.templateCache = caffeineSpec.build();
        return this;
    }

    public SqlParser getSqlParser() {
        return this.sqlParser;
    }

    public SqlStatements setSqlParser(SqlParser sqlParser) {
        this.sqlParser = sqlParser;
        return this;
    }

    @Deprecated
    public TimingCollector getTimingCollector() {
        return (elapsed, ctx) -> this.sqlLogger.logAfterExecution(ctx);
    }

    @Deprecated
    public SqlStatements setTimingCollector(final TimingCollector timingCollector) {
        this.sqlLogger = timingCollector == null ? SqlLogger.NOP_SQL_LOGGER : new SqlLogger(){

            @Override
            public void logAfterExecution(StatementContext context) {
                timingCollector.collect(context.getElapsedTime(ChronoUnit.NANOS), context);
            }
        };
        return this;
    }

    public SqlLogger getSqlLogger() {
        return this.sqlLogger;
    }

    public SqlStatements setSqlLogger(SqlLogger sqlLogger) {
        this.sqlLogger = sqlLogger == null ? SqlLogger.NOP_SQL_LOGGER : sqlLogger;
        return this;
    }

    @Beta
    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    @Beta
    public SqlStatements setQueryTimeout(@Nullable Integer seconds) {
        if (seconds != null && seconds < 0) {
            throw new IllegalArgumentException("queryTimeout must not be < 0");
        }
        this.queryTimeout = seconds;
        return this;
    }

    public boolean isUnusedBindingAllowed() {
        return this.allowUnusedBindings;
    }

    public SqlStatements setUnusedBindingAllowed(boolean unusedBindingAllowed) {
        this.allowUnusedBindings = unusedBindingAllowed;
        return this;
    }

    void customize(Statement statement) throws SQLException {
        if (this.queryTimeout != null) {
            statement.setQueryTimeout(this.queryTimeout);
        }
    }

    @Override
    public SqlStatements createCopy() {
        return new SqlStatements(this);
    }

    Collection<StatementCustomizer> getCustomizers() {
        return this.customizers;
    }

    Collection<StatementContextListener> getContextListeners() {
        return this.contextListeners;
    }

    String preparedRender(String template, StatementContext ctx) {
        try {
            return Optional.ofNullable((Function)this.templateCache.get((Object)new StatementCacheKey(this.templateEngine, template), key -> ((StatementCacheKey)key).getTemplateEngine().parse(((StatementCacheKey)key).getTemplate(), ctx.getConfig()).orElse(null))).orElse(cx -> this.templateEngine.render(template, (StatementContext)cx)).apply(ctx);
        }
        catch (IllegalArgumentException e) {
            throw new UnableToCreateStatementException("Exception rendering SQL template", e, ctx);
        }
    }

    private static final class StatementCacheKey {
        private final TemplateEngine templateEngine;
        private final String template;

        StatementCacheKey(TemplateEngine templateEngine, String template) {
            this.templateEngine = templateEngine;
            this.template = template;
        }

        private TemplateEngine getTemplateEngine() {
            return this.templateEngine;
        }

        private String getTemplate() {
            return this.template;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatementCacheKey that = (StatementCacheKey)o;
            return this.templateEngine.equals(that.templateEngine) && this.template.equals(that.template);
        }

        public int hashCode() {
            return Objects.hash(this.templateEngine, this.template);
        }

        public String toString() {
            return new StringJoiner(", ", StatementCacheKey.class.getSimpleName() + "[", "]").add("templateEngine=" + this.templateEngine).add("template='" + this.template + "'").toString();
        }
    }
}

