/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.result;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.result.EmptyResultSet;
import org.jdbi.v3.core.result.NoResultsException;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.result.ResultProducer;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.statement.StatementContext;

public class ResultProducers
implements JdbiConfig<ResultProducers> {
    private boolean allowNoResults = false;

    public ResultProducers() {
    }

    private ResultProducers(ResultProducers that) {
        this.allowNoResults = that.allowNoResults;
    }

    public static ResultProducer<Integer> returningUpdateCount() {
        return (statementSupplier, ctx) -> {
            try (StatementContext context = ctx;){
                Integer n = ((PreparedStatement)statementSupplier.get()).getUpdateCount();
                return n;
            }
        };
    }

    public static ResultProducer<ResultBearing> returningResults() {
        return (statementSupplier, ctx) -> ResultBearing.of(ResultProducers.getResultSet(statementSupplier, ctx), ctx);
    }

    private static Supplier<ResultSet> getResultSet(Supplier<PreparedStatement> statementSupplier, StatementContext ctx) {
        return () -> {
            try {
                ResultSet resultSet = ((PreparedStatement)statementSupplier.get()).getResultSet();
                if (resultSet == null) {
                    if (ctx.getConfig(ResultProducers.class).allowNoResults) {
                        return new EmptyResultSet();
                    }
                    throw new NoResultsException("Statement returned no results", ctx);
                }
                ctx.addCleanable(resultSet::close);
                return resultSet;
            }
            catch (SQLException e) {
                throw new ResultSetException("Could not get result set", e, ctx);
            }
        };
    }

    public static ResultProducer<ResultBearing> returningGeneratedKeys(String ... generatedKeyColumnNames) {
        return (preparedStatementSupplier, ctx) -> {
            ctx.setReturningGeneratedKeys(true);
            if (generatedKeyColumnNames.length > 0) {
                ctx.setGeneratedKeysColumnNames(generatedKeyColumnNames);
            }
            return ResultBearing.of(ResultProducers.getGeneratedKeys(preparedStatementSupplier, ctx), ctx);
        };
    }

    private static Supplier<ResultSet> getGeneratedKeys(Supplier<PreparedStatement> statementSupplier, StatementContext ctx) {
        return () -> {
            try {
                ResultSet resultSet = ((PreparedStatement)statementSupplier.get()).getGeneratedKeys();
                if (resultSet == null) {
                    throw new NoResultsException("Statement returned no generated keys", ctx);
                }
                ctx.addCleanable(resultSet::close);
                return resultSet;
            }
            catch (SQLException e) {
                throw new ResultSetException("Could not get generated keys", e, ctx);
            }
        };
    }

    @Override
    public ResultProducers createCopy() {
        return new ResultProducers(this);
    }

    public ResultProducers allowNoResults(boolean allowed) {
        this.allowNoResults = allowed;
        return this;
    }
}

