/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.mapper.CaseStrategy;
import org.jdbi.v3.core.mapper.reflect.CaseInsensitiveColumnNameMatcher;
import org.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import org.jdbi.v3.core.mapper.reflect.SnakeCaseColumnNameMatcher;
import org.jdbi.v3.meta.Alpha;
import org.jdbi.v3.meta.Beta;

public class ReflectionMappers
implements JdbiConfig<ReflectionMappers> {
    private static final Consumer<AccessibleObject> FORCE_MAKE_ACCESSIBLE = accessibleObject -> accessibleObject.setAccessible(true);
    private static final Consumer<AccessibleObject> DO_NOT_MAKE_ACCESSIBLE = accessibleObject -> {};
    private List<ColumnNameMatcher> columnNameMatchers;
    private boolean strictMatching;
    private UnaryOperator<String> caseChange;
    private Consumer<AccessibleObject> makeAccessible;

    public ReflectionMappers() {
        this.columnNameMatchers = Arrays.asList(new CaseInsensitiveColumnNameMatcher(), new SnakeCaseColumnNameMatcher());
        this.strictMatching = false;
        this.caseChange = CaseStrategy.LOCALE_LOWER;
        this.makeAccessible = FORCE_MAKE_ACCESSIBLE;
    }

    private ReflectionMappers(ReflectionMappers that) {
        this.columnNameMatchers = new ArrayList<ColumnNameMatcher>(that.columnNameMatchers);
        this.strictMatching = that.strictMatching;
        this.caseChange = that.caseChange;
        this.makeAccessible = that.makeAccessible;
    }

    public List<ColumnNameMatcher> getColumnNameMatchers() {
        return Collections.unmodifiableList(this.columnNameMatchers);
    }

    public ReflectionMappers setColumnNameMatchers(List<ColumnNameMatcher> columnNameMatchers) {
        this.columnNameMatchers = new ArrayList<ColumnNameMatcher>(columnNameMatchers);
        return this;
    }

    public boolean isStrictMatching() {
        return this.strictMatching;
    }

    public ReflectionMappers setStrictMatching(boolean strictMatching) {
        this.strictMatching = strictMatching;
        return this;
    }

    @Beta
    public UnaryOperator<String> getCaseChange() {
        return this.caseChange;
    }

    @Beta
    public ReflectionMappers setCaseChange(UnaryOperator<String> caseChange) {
        this.caseChange = caseChange;
        return this;
    }

    @Alpha
    public ReflectionMappers setAccessibleObjectStrategy(Consumer<AccessibleObject> makeAccessible) {
        this.makeAccessible = makeAccessible;
        return this;
    }

    @Alpha
    public ReflectionMappers disableAccessibleObjectStrategy() {
        this.makeAccessible = DO_NOT_MAKE_ACCESSIBLE;
        return this;
    }

    @Alpha
    public <T extends AccessibleObject> T makeAccessible(T accessibleObject) {
        this.makeAccessible.accept(accessibleObject);
        return accessibleObject;
    }

    @Override
    public ReflectionMappers createCopy() {
        return new ReflectionMappers(this);
    }
}

