/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionContext;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.extension.HandleSupplier;

class ConstantHandleSupplier
implements HandleSupplier {
    private final Handle handle;
    private final Deque<ExtensionContext> extensionContexts = new LinkedList<ExtensionContext>();

    static HandleSupplier of(Handle handle) {
        return new ConstantHandleSupplier(handle);
    }

    ConstantHandleSupplier(Handle handle) {
        this.handle = handle;
    }

    @Override
    public Jdbi getJdbi() {
        return this.handle.getJdbi();
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.handle.getConfig();
    }

    @Override
    public Handle getHandle() {
        return this.handle;
    }

    @Override
    public <V> V invokeInContext(ExtensionMethod extensionMethod, ConfigRegistry config, Callable<V> task) throws Exception {
        return this.invokeInContext(new ExtensionContext(config, extensionMethod), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V invokeInContext(ExtensionContext extensionContext, Callable<V> task) throws Exception {
        try {
            this.pushExtensionContext(extensionContext);
            V v = task.call();
            return v;
        }
        finally {
            this.popExtensionContext();
        }
    }

    private void pushExtensionContext(ExtensionContext extensionContext) {
        this.extensionContexts.addFirst(extensionContext);
        this.handle.acceptExtensionContext(extensionContext);
    }

    private void popExtensionContext() {
        this.extensionContexts.pollFirst();
        this.handle.acceptExtensionContext(this.extensionContexts.peek());
    }
}

