/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.statement.ColonPrefixSqlParser;
import org.jdbi.v3.core.statement.DefinedAttributeTemplateEngine;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.core.statement.TimingCollector;

public final class SqlStatements
implements JdbiConfig<SqlStatements> {
    private final Map<String, Object> attributes;
    private TemplateEngine templateEngine;
    private SqlParser sqlParser;
    private TimingCollector timingCollector;

    public SqlStatements() {
        this.attributes = new ConcurrentHashMap<String, Object>();
        this.templateEngine = new DefinedAttributeTemplateEngine();
        this.sqlParser = new ColonPrefixSqlParser();
        this.timingCollector = TimingCollector.NOP_TIMING_COLLECTOR;
    }

    private SqlStatements(SqlStatements that) {
        this.attributes = new ConcurrentHashMap<String, Object>(that.attributes);
        this.templateEngine = that.templateEngine;
        this.sqlParser = that.sqlParser;
        this.timingCollector = that.timingCollector;
    }

    public SqlStatements define(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public SqlStatements defineMap(Map<String, ?> values) {
        if (values != null) {
            this.attributes.putAll(values);
        }
        return this;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public SqlStatements setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        return this;
    }

    public SqlParser getSqlParser() {
        return this.sqlParser;
    }

    public SqlStatements setSqlParser(SqlParser sqlParser) {
        this.sqlParser = sqlParser;
        return this;
    }

    public TimingCollector getTimingCollector() {
        return this.timingCollector;
    }

    public SqlStatements setTimingCollector(TimingCollector timingCollector) {
        this.timingCollector = timingCollector == null ? TimingCollector.NOP_TIMING_COLLECTOR : timingCollector;
        return this;
    }

    @Override
    public SqlStatements createCopy() {
        return new SqlStatements(this);
    }
}

