/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.collector;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Collector;
import org.jdbi.v3.core.collector.CollectorFactory;
import org.jdbi.v3.core.collector.OptionalCollectors;

class OptionalPrimitiveCollectorFactory
implements CollectorFactory {
    static final Map<Class<?>, Collector<?, ?, ?>> collectors = new HashMap();
    static final Map<Class<?>, Class<?>> elementTypes = new HashMap();

    OptionalPrimitiveCollectorFactory() {
        collectors.put(OptionalInt.class, OptionalCollectors.toOptionalInt());
        elementTypes.put(OptionalInt.class, Integer.class);
        collectors.put(OptionalLong.class, OptionalCollectors.toOptionalLong());
        elementTypes.put(OptionalLong.class, Long.class);
        collectors.put(OptionalDouble.class, OptionalCollectors.toOptionalDouble());
        elementTypes.put(OptionalDouble.class, Double.class);
    }

    @Override
    public boolean accepts(Type containerType) {
        return collectors.containsKey(containerType);
    }

    @Override
    public Optional<Type> elementType(Type containerType) {
        return Optional.of(elementTypes.get(containerType));
    }

    @Override
    public Collector<?, ?, ?> build(Type containerType) {
        return collectors.get(containerType);
    }
}

