/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.argument.ObjectPropertyNamedArgumentFinder;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

public class ObjectFieldArguments
extends ObjectPropertyNamedArgumentFinder {
    private static final Map<Class<?>, Map<String, Field>> CLASS_FIELDS = ExpiringMap.builder().expiration(10L, TimeUnit.MINUTES).expirationPolicy(ExpirationPolicy.ACCESSED).entryLoader(type -> Stream.of(type.getFields()).collect(Collectors.toMap(Field::getName, Function.identity()))).build();
    private final Map<String, Field> fields;

    public ObjectFieldArguments(String prefix, Object bean) {
        super(prefix, bean);
        this.fields = CLASS_FIELDS.get(bean.getClass());
    }

    @Override
    Optional<ObjectPropertyNamedArgumentFinder.TypedValue> getValue(String name, StatementContext ctx) {
        Field field = this.fields.get(name);
        if (field == null) {
            return Optional.empty();
        }
        try {
            Type type = field.getGenericType();
            Object value = field.get(this.object);
            return Optional.of(new ObjectPropertyNamedArgumentFinder.TypedValue(type, value));
        }
        catch (IllegalAccessException e) {
            throw new UnableToCreateStatementException(String.format("Access exception getting field for bean property [%s] on [%s]", name, this.object), e, ctx);
        }
    }

    @Override
    NamedArgumentFinder getNestedArgumentFinder(Object obj) {
        return new ObjectFieldArguments(null, obj);
    }

    public String toString() {
        return "{lazy bean field arguments \"" + this.object + "\"";
    }
}

