/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.TaskQueryService;
import org.kie.internal.task.api.model.InternalTaskSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueryServiceImpl
implements TaskQueryService {
    private static final Logger logger = LoggerFactory.getLogger(TaskQueryServiceImpl.class);
    private TaskPersistenceContext persistenceContext;
    private static String VARIOUS_FIELDS_TASKSUM_QUERY = "select distinct  new org.jbpm.services.task.query.TaskSummaryImpl(t.id,  t.taskData.processInstanceId,  name.shortText,subject.shortText,description.shortText,  t.taskData.status,  t.priority,  t.taskData.skipable,  actualOwner,createdBy,  t.taskData.createdOn,t.taskData.activationTime,t.taskData.expirationTime,  t.taskData.processId,t.taskData.processSessionId,  t.subTaskStrategy,  t.taskData.parentId ) from  TaskImpl t   left join t.taskData.actualOwner as actualOwner              left join t.taskData.createdBy as createdBy  left join t.subjects as subject  left join t.descriptions as description  left join t.names as name,   OrganizationalEntityImpl businessAdministrator,   OrganizationalEntityImpl potentialOwners where t.archived = 0 AND ";

    public TaskQueryServiceImpl() {
    }

    public TaskQueryServiceImpl(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void setPersistenceContext(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, String language) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsBusinessAdministrator", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "language", language}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId, String language) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsExcludedOwner", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "language", language}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwner", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "language", language}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerWithGroups", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "groupIds", groupIds, "language", language}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedByGroup(String groupId, String language) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroup", (Map)this.persistenceContext.addParametersToMap(new Object[]{"groupId", groupId, "language", language}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedByGroupsByExpirationDateOptional(List<String> groupIds, String language, Date expirationDate) {
        List tasksByGroups = (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroupsByExpirationDateOptional", (Map)this.persistenceContext.addParametersToMap(new Object[]{"groupIds", groupIds, "expirationDate", expirationDate}), ClassUtil.castClass(List.class));
        return this.collectTasksByPotentialOwners(tasksByGroups, language);
    }

    protected List<TaskSummary> collectTasksByPotentialOwners(List<Object[]> tasksByGroups, String language) {
        Set<Long> tasksIds = Collections.synchronizedSet(new HashSet());
        Map potentialOwners = Collections.synchronizedMap(new HashMap());
        Iterator<Object[]> i$ = tasksByGroups.iterator();
        while (i$.hasNext()) {
            Object[] o;
            Object[] get = o = i$.next();
            tasksIds.add((Long)get[0]);
            if (potentialOwners.get((Long)get[0]) == null) {
                potentialOwners.put((Long)get[0], new ArrayList());
            }
            ((List)potentialOwners.get((Long)get[0])).add((String)get[1]);
        }
        if (!tasksIds.isEmpty()) {
            List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TaskSummariesByIds", (Map)this.persistenceContext.addParametersToMap(new Object[]{"taskIds", tasksIds, "language", language}), ClassUtil.castClass(List.class));
            for (TaskSummary ts : tasks) {
                ((InternalTaskSummary)ts).setPotentialOwners((List)potentialOwners.get(ts.getId()));
            }
            return tasks;
        }
        return new ArrayList<TaskSummary>();
    }

    public List<TaskSummary> getTasksAssignedByGroupsByExpirationDate(List<String> groupIds, String language, Date expirationDate) {
        List tasksByGroups = (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroupsByExpirationDate", (Map)this.persistenceContext.addParametersToMap(new Object[]{"groupIds", groupIds, "expirationDate", expirationDate}), ClassUtil.castClass(List.class));
        return this.collectTasksByPotentialOwners(tasksByGroups, language);
    }

    public List<TaskSummary> getTasksAssignedByGroups(List<String> groupIds, String language) {
        List tasksByGroups = (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroups", (Map)this.persistenceContext.addParametersToMap(new Object[]{"groupIds", groupIds}), ClassUtil.castClass(List.class));
        Set<Long> tasksIds = Collections.synchronizedSet(new HashSet());
        Map potentialOwners = Collections.synchronizedMap(new HashMap());
        Iterator i$ = tasksByGroups.iterator();
        while (i$.hasNext()) {
            Object[] o;
            Object[] get = o = (Object[])i$.next();
            tasksIds.add((Long)get[0]);
            if (potentialOwners.get((Long)get[0]) == null) {
                potentialOwners.put((Long)get[0], new ArrayList());
            }
            ((List)potentialOwners.get((Long)get[0])).add((String)get[1]);
        }
        if (!tasksIds.isEmpty()) {
            List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TaskSummariesByIds", (Map)this.persistenceContext.addParametersToMap(new Object[]{"taskIds", tasksIds, "language", language}), ClassUtil.castClass(List.class));
            for (TaskSummary ts : tasks) {
                ((InternalTaskSummary)ts).setPotentialOwners((List)potentialOwners.get(ts.getId()));
            }
            return tasks;
        }
        return new ArrayList<TaskSummary>();
    }

    public Map<Long, List<OrganizationalEntity>> getPotentialOwnersForTaskIds(List<Long> taskIds) {
        List potentialOwners = (List)this.persistenceContext.queryWithParametersInTransaction("GetPotentialOwnersForTaskIds", (Map)this.persistenceContext.addParametersToMap(new Object[]{"taskIds", taskIds}), ClassUtil.castClass(List.class));
        HashMap<Long, List<OrganizationalEntity>> potentialOwnersMap = new HashMap<Long, List<OrganizationalEntity>>();
        Long currentTaskId = 0L;
        for (Object[] item : potentialOwners) {
            Long taskId = (Long)item[0];
            OrganizationalEntity potentialOwner = (OrganizationalEntity)item[1];
            if (currentTaskId != taskId) {
                currentTaskId = taskId;
            }
            if (potentialOwnersMap.get(currentTaskId) == null) {
                potentialOwnersMap.put(currentTaskId, new ArrayList());
            }
            ((List)potentialOwnersMap.get(currentTaskId)).add(potentialOwner);
        }
        return potentialOwnersMap;
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, int firstResult, int maxResults) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerWithGroups", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "groupIds", groupIds, "language", language, "firstResult", firstResult, "maxResults", maxResults}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsRecipient(String userId, String language) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsRecipient", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "language", language}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId, String language) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsTaskInitiator", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "language", language}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId, String language) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsTaskStakeholder", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "language", language}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksOwned(String userId, String language) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksOwned", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "language", language}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksOwnedByStatus(String userId, List<Status> status, String language) {
        List taskOwned = (List)this.persistenceContext.queryWithParametersInTransaction("TasksOwnedWithParticularStatus", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "status", status, "language", language}), ClassUtil.castClass(List.class));
        if (!taskOwned.isEmpty()) {
            HashSet<Long> tasksIds = new HashSet<Long>();
            for (TaskSummary ts : taskOwned) {
                tasksIds.add(ts.getId());
            }
            List tasksPotentialOwners = (List)this.persistenceContext.queryWithParametersInTransaction("TasksOwnedPotentialOwnersByTaskIds", (Map)this.persistenceContext.addParametersToMap(new Object[]{"taskIds", tasksIds}), ClassUtil.castClass(List.class));
            HashMap potentialOwners = new HashMap();
            Iterator i$ = tasksPotentialOwners.iterator();
            while (i$.hasNext()) {
                Object[] o;
                Object[] get = o = (Object[])i$.next();
                tasksIds.add((Long)get[0]);
                if (potentialOwners.get((Long)get[0]) == null) {
                    potentialOwners.put((Long)get[0], new ArrayList());
                }
                ((List)potentialOwners.get((Long)get[0])).add((String)get[1]);
            }
            for (TaskSummary ts : taskOwned) {
                ((InternalTaskSummary)ts).setPotentialOwners((List)potentialOwners.get(ts.getId()));
            }
        } else {
            return new ArrayList<TaskSummary>(0);
        }
        return taskOwned;
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status, String language) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByStatus", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "language", language, "status", status}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatusByGroup(String userId, List<String> groupIds, List<Status> status, String language) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByStatusByGroup", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "groupIds", groupIds, "status", status, "language", language}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("SubTasksAssignedAsPotentialOwner", (Map)this.persistenceContext.addParametersToMap(new Object[]{"parentId", parentId, "userId", userId, "language", language}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getSubTasksByParent(long parentId) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("GetSubTasksByParentTaskId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"parentId", parentId, "language", "en-UK"}), ClassUtil.castClass(List.class));
    }

    public int getPendingSubTasksByParent(long parentId) {
        return ((List)this.persistenceContext.queryWithParametersInTransaction("GetSubTasksByParentTaskId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"parentId", parentId, "language", "en-UK"}), ClassUtil.castClass(List.class))).size();
    }

    public Task getTaskInstanceById(long taskId) {
        Task taskInstance = this.persistenceContext.findTask(Long.valueOf(taskId));
        return taskInstance;
    }

    public Task getTaskByWorkItemId(long workItemId) {
        List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TaskByWorkItemId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"workItemId", workItemId, "maxResults", 1}), ClassUtil.castClass(List.class));
        if (tasks.isEmpty()) {
            return null;
        }
        return (Task)tasks.get(0);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDate(String userId, List<String> groupsIds, List<Status> status, Date expirationDate) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerStatusByExpirationDate", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "groupIds", groupsIds, "status", status, "expirationDate", expirationDate, "language", "en-UK"}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDateOptional(String userId, List<String> groupsIds, List<Status> status, Date expirationDate) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerStatusByExpirationDateOptional", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "groupIds", groupsIds, "status", status, "expirationDate", expirationDate, "language", "en-UK"}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksOwnedByExpirationDate(String userId, List<Status> status, Date expirationDate) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksOwnedWithParticularStatusByExpirationDate", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "status", status, "expirationDate", expirationDate, "language", "en-UK"}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateOptional(String userId, List<Status> status, Date expirationDate) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksOwnedWithParticularStatusByExpirationDateOptional", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "status", status, "expirationDate", expirationDate, "language", "en-UK"}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateBeforeSpecifiedDate(String userId, List<Status> status, Date date) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksOwnedWithParticularStatusByExpirationDateBeforeSpecifiedDate", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "status", status, "date", date, "language", "en-UK"}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksByStatusByProcessInstanceId(long processInstanceId, List<Status> status, String language) {
        List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TasksByStatusByProcessId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"processInstanceId", processInstanceId, "status", status, "language", language}), ClassUtil.castClass(List.class));
        return tasks;
    }

    public List<TaskSummary> getTasksByStatusByProcessInstanceIdByTaskName(long processInstanceId, List<Status> status, String taskName, String language) {
        List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TasksByStatusByProcessIdByTaskName", (Map)this.persistenceContext.addParametersToMap(new Object[]{"processInstanceId", processInstanceId, "status", status, "taskName", taskName, "language", language}), ClassUtil.castClass(List.class));
        return tasks;
    }

    public List<Long> getTasksByProcessInstanceId(long processInstanceId) {
        List tasks = (List)this.persistenceContext.queryWithParametersInTransaction("TasksByProcessInstanceId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"processInstanceId", processInstanceId}), ClassUtil.castClass(List.class));
        return tasks;
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDate(String userId, List<Status> status, Date expirationDate) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerStatusByExpirationDate", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "groupIds", "", "status", status, "expirationDate", expirationDate, "language", "en-UK"}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDateOptional(String userId, List<Status> status, Date expirationDate) {
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerStatusByExpirationDateOptional", (Map)this.persistenceContext.addParametersToMap(new Object[]{"userId", userId, "groupIds", "", "status", status, "expirationDate", expirationDate, "language", "en-UK"}), ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getTasksByVariousFields(List<Long> workItemIds, List<Long> taskIds, List<Long> procInstIds, List<String> busAdmins, List<String> potOwners, List<String> taskOwners, List<Status> status, List<String> language, boolean union) {
        HashMap params = new HashMap();
        params.put("Work item id list", workItemIds);
        params.put("task id list", taskIds);
        params.put("process instance id list", procInstIds);
        params.put("business admin id list", busAdmins);
        params.put("potential owner id list", potOwners);
        params.put("task owner id list", taskOwners);
        params.put("status list", status);
        params.put("language", language);
        return this.getTasksByVariousFields(params, union);
    }

    public List<TaskSummary> getTasksByVariousFields(Map<String, List<?>> parameters, boolean union) {
        String query;
        String paramName;
        StringBuilder queryBuilder = new StringBuilder(VARIOUS_FIELDS_TASKSUM_QUERY);
        HashMap<String, Object> params = new HashMap<String, Object>();
        WhereClauseWithListParamAppender longQueryAdder = new WhereClauseWithListParamAppender(Long.class, queryBuilder, params, union);
        WhereClauseWithListParamAppender stringQueryAdder = new WhereClauseWithListParamAppender(String.class, queryBuilder, params, union);
        WhereClauseWithListParamAppender statusQueryAdder = new WhereClauseWithListParamAppender(Status.class, queryBuilder, params, union);
        List workItemIds = longQueryAdder.checkNullAndInstanceOf(parameters, "Work item id list");
        List taskIds = longQueryAdder.checkNullAndInstanceOf(parameters, "task id list");
        List procInstIds = longQueryAdder.checkNullAndInstanceOf(parameters, "process instance id list");
        List busAdmins = stringQueryAdder.checkNullAndInstanceOf(parameters, "business admin id list");
        List potOwners = stringQueryAdder.checkNullAndInstanceOf(parameters, "potential owner id list");
        List taskOwners = stringQueryAdder.checkNullAndInstanceOf(parameters, "task owner id list");
        List language = stringQueryAdder.checkNullAndInstanceOf(parameters, "language");
        List status = statusQueryAdder.checkNullAndInstanceOf(parameters, "status list");
        if (workItemIds != null && workItemIds.size() > 0) {
            paramName = "workItemIds";
            longQueryAdder.addToQueryBuilder("( t.taskData.workItemId in ( :" + paramName + " ) ) ", paramName, workItemIds);
        }
        if (taskIds != null && taskIds.size() > 0) {
            paramName = "taskIds";
            longQueryAdder.addToQueryBuilder("( t.id in ( :" + paramName + " ) ) ", paramName, taskIds);
        }
        if (procInstIds != null && procInstIds.size() > 0) {
            paramName = "procInstIds";
            longQueryAdder.addToQueryBuilder("( t.taskData.processInstanceId in ( :" + paramName + " ) ) ", paramName, procInstIds);
        }
        stringQueryAdder.setAlreadyUsed(longQueryAdder.isAlreadyUsed());
        if (busAdmins != null && busAdmins.size() > 0) {
            paramName = "busAdminIds";
            query = "( businessAdministrator.id in ( :" + paramName + " ) and " + "businessAdministrator in elements ( t.peopleAssignments.businessAdministrators ) ) ";
            stringQueryAdder.addToQueryBuilder(query, paramName, busAdmins);
        }
        if (potOwners != null && potOwners.size() > 0) {
            paramName = "potOwnerIds";
            query = "( potentialOwners.id in ( :" + paramName + " ) and " + "potentialOwners in elements ( t.peopleAssignments.potentialOwners ) ) ";
            stringQueryAdder.addToQueryBuilder(query, paramName, potOwners);
        }
        if (taskOwners != null && taskOwners.size() > 0) {
            paramName = "taskOwnerIds";
            query = "( t.taskData.actualOwner.id in ( :" + paramName + " ) ) ";
            stringQueryAdder.addToQueryBuilder(query, paramName, taskOwners);
        }
        if (language != null && language.size() > 0) {
            paramName = "language";
            query = "( name.language in ( :" + paramName + " ) or t.names.size = 0 ) and" + "( subject.language in ( :" + paramName + " ) or t.subjects.size = 0 ) and" + "( description.language in ( :" + paramName + " ) or t.descriptions.size = 0 )";
            stringQueryAdder.addToQueryBuilder(query, paramName, language);
        }
        statusQueryAdder.setAlreadyUsed(stringQueryAdder.isAlreadyUsed());
        if (status != null && status.size() > 0) {
            paramName = "statuses";
            query = "( t.taskData.status in (:" + paramName + ") ) ";
            statusQueryAdder.addToQueryBuilder(query, paramName, status);
        }
        String query2 = queryBuilder.toString();
        logger.debug("QUERY: " + query2);
        return (List)this.persistenceContext.queryStringWithParametersInTransaction(query2, params, ClassUtil.castClass(List.class));
    }

    public int getCompletedTaskByUserId(String userId) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Completed);
        List<TaskSummary> tasksCompleted = this.getTasksAssignedAsPotentialOwnerByStatus(userId, statuses, "en-UK");
        return tasksCompleted.size();
    }

    public int getPendingTaskByUserId(String userId) {
        List<TaskSummary> tasksAssigned = this.getTasksAssignedAsPotentialOwner(userId, "en-UK");
        return tasksAssigned.size();
    }

    private class WhereClauseWithListParamAppender<T> {
        private final String andOr;
        private boolean alreadyUsed = false;
        private final StringBuilder queryBuilder;
        private final Map<String, Object> queryParams;
        private final Class<?> clazz;

        public WhereClauseWithListParamAppender(Class<?> clazz, StringBuilder queryBuilder, Map<String, Object> params, boolean union) {
            this.andOr = union ? " OR " : " AND ";
            this.queryBuilder = queryBuilder;
            this.queryParams = params;
            this.clazz = clazz;
        }

        public void addToQueryBuilder(String query, String paramName, List<T> paramValList) {
            if (this.isAlreadyUsed()) {
                this.queryBuilder.append(this.andOr);
            }
            this.queryBuilder.append(query);
            HashSet<T> paramVals = new HashSet<T>();
            for (T val : paramValList) {
                if (val == null) continue;
                paramVals.add(val);
            }
            this.queryParams.put(paramName, paramVals);
            this.setAlreadyUsed(true);
        }

        public boolean isAlreadyUsed() {
            return this.alreadyUsed;
        }

        public void setAlreadyUsed(boolean alreadyUsed) {
            this.alreadyUsed = alreadyUsed;
        }

        public List<T> checkNullAndInstanceOf(Map<String, List<?>> params, String field) {
            List<T> result = null;
            List<?> inputList = params.get(field);
            if (inputList != null && inputList.size() > 0) {
                Object inputObject = inputList.get(0);
                if (this.clazz.equals(inputObject.getClass())) {
                    return inputList;
                }
                throw new IllegalArgumentException(field + " parameter is an instance of " + "List<" + inputObject.getClass().getSimpleName() + "> instead of " + "List<" + this.clazz.getSimpleName() + ">");
            }
            return result;
        }
    }
}

