/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.service;

import java.util.Date;
import java.util.List;
import org.jbpm.services.task.audit.commands.GetAllGroupAuditTasksAdminCommand;
import org.jbpm.services.task.audit.commands.GetAllGroupAuditTasksByDueDateCommand;
import org.jbpm.services.task.audit.commands.GetAllGroupAuditTasksByStatusByDueDateCommand;
import org.jbpm.services.task.audit.commands.GetAllGroupAuditTasksByStatusCommand;
import org.jbpm.services.task.audit.commands.GetAllGroupAuditTasksCommand;
import org.jbpm.services.task.audit.commands.GetAllHistoryAuditTasksByUserCommand;
import org.jbpm.services.task.audit.commands.GetAllHistoryAuditTasksCommand;
import org.jbpm.services.task.audit.commands.GetAllUserAuditTasksAdminCommand;
import org.jbpm.services.task.audit.commands.GetAllUserAuditTasksByDueDateCommand;
import org.jbpm.services.task.audit.commands.GetAllUserAuditTasksByStatusByDueDateCommand;
import org.jbpm.services.task.audit.commands.GetAllUserAuditTasksByStatusCommand;
import org.jbpm.services.task.audit.commands.GetAllUserAuditTasksCommand;
import org.jbpm.services.task.audit.commands.GetAuditEventsCommand;
import org.jbpm.services.task.audit.impl.model.api.GroupAuditTask;
import org.jbpm.services.task.audit.impl.model.api.HistoryAuditTask;
import org.jbpm.services.task.audit.impl.model.api.UserAuditTask;
import org.jbpm.services.task.audit.service.TaskAuditService;
import org.kie.api.command.Command;
import org.kie.api.task.TaskService;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.model.TaskEvent;

public class TaskAuditServiceImpl
implements TaskAuditService {
    private InternalTaskService taskService;

    @Override
    public List<TaskEvent> getAllTaskEvents(long taskId, int offset, int count) {
        return (List)this.taskService.execute((Command)new GetAuditEventsCommand(taskId, offset, count));
    }

    @Override
    public List<UserAuditTask> getAllUserAuditTasks(String userId, int offset, int count) {
        return (List)this.taskService.execute((Command)new GetAllUserAuditTasksCommand(userId, offset, count));
    }

    @Override
    public List<UserAuditTask> getAllUserAuditTasksByStatus(String userId, List<String> statuses, int offset, int count) {
        List execute = null;
        try {
            execute = (List)this.taskService.execute((Command)new GetAllUserAuditTasksByStatusCommand(userId, statuses, offset, count));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return execute;
    }

    @Override
    public List<UserAuditTask> getAllUserAuditTasksByDueDate(String userId, Date dueDate, int offset, int count) {
        return (List)this.taskService.execute((Command)new GetAllUserAuditTasksByDueDateCommand(userId, dueDate, offset, count));
    }

    @Override
    public List<UserAuditTask> getAllUserAuditTasksByStatusByDueDate(String userId, List<String> statuses, Date dueDate, int offset, int count) {
        return (List)this.taskService.execute((Command)new GetAllUserAuditTasksByStatusByDueDateCommand(userId, statuses, dueDate, offset, count));
    }

    @Override
    public List<UserAuditTask> getAllUserAuditTasksByStatusByDueDateOptional(String userId, List<String> statuses, Date dueDate, int offset, int count) {
        return (List)this.taskService.execute((Command)new GetAllUserAuditTasksByStatusByDueDateCommand(userId, statuses, dueDate, offset, count));
    }

    @Override
    public List<GroupAuditTask> getAllGroupAuditTasks(String groupIds, int offset, int count) {
        return (List)this.taskService.execute((Command)new GetAllGroupAuditTasksCommand(groupIds, offset, count));
    }

    @Override
    public List<GroupAuditTask> getAllGroupAuditTasksByStatus(String groupIds, List<String> statuses, int offset, int count) {
        return (List)this.taskService.execute((Command)new GetAllGroupAuditTasksByStatusCommand(groupIds, statuses, offset, count));
    }

    @Override
    public List<GroupAuditTask> getAllGroupAuditTasksByDueDate(String groupIds, Date dueDate, int offset, int count) {
        return (List)this.taskService.execute((Command)new GetAllGroupAuditTasksByDueDateCommand(groupIds, dueDate, offset, count));
    }

    @Override
    public List<GroupAuditTask> getAllGroupAuditTasksByStatusByDueDate(String groupIds, List<String> statuses, Date dueDate, int offset, int count) {
        return (List)this.taskService.execute((Command)new GetAllGroupAuditTasksByStatusByDueDateCommand(groupIds, statuses, dueDate, offset, count));
    }

    @Override
    public List<GroupAuditTask> getAllGroupAuditTasksByStatusByDueDateOptional(String groupIds, List<String> statuses, Date dueDate, int offset, int count) {
        return (List)this.taskService.execute((Command)new GetAllGroupAuditTasksByStatusByDueDateCommand(groupIds, statuses, dueDate, offset, count));
    }

    @Override
    public List<UserAuditTask> getAllUserAuditTasksAdmin(int offset, int count) {
        return (List)this.taskService.execute((Command)new GetAllUserAuditTasksAdminCommand(offset, count));
    }

    @Override
    public List<GroupAuditTask> getAllGroupAuditTasksAdmin(int offset, int count) {
        return (List)this.taskService.execute((Command)new GetAllGroupAuditTasksAdminCommand(offset, count));
    }

    @Override
    public List<HistoryAuditTask> getAllHistoryAuditTasks(int offset, int count) {
        return (List)this.taskService.execute((Command)new GetAllHistoryAuditTasksCommand(offset, count));
    }

    @Override
    public List<HistoryAuditTask> getAllHistoryAuditTasksByUser(String userId, int offset, int count) {
        return (List)this.taskService.execute((Command)new GetAllHistoryAuditTasksByUserCommand(userId, offset, count));
    }

    @Override
    public void setTaskService(TaskService taskService) {
        this.taskService = (InternalTaskService)taskService;
    }
}

