/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.command;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.command.AbstractHistoryLogCommand;
import org.kie.internal.command.Context;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class FindVariableInstancesByNameCommand
extends AbstractHistoryLogCommand<List<VariableInstanceLog>> {
    private static final long serialVersionUID = 7087452375594067164L;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="String")
    private String variableId;
    @XmlAttribute(required=false)
    @XmlSchemaType(name="String")
    private String value = null;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="boolean")
    private Boolean activeProcesses;

    public FindVariableInstancesByNameCommand() {
    }

    public FindVariableInstancesByNameCommand(String variableId) {
        this.variableId = variableId;
        this.activeProcesses = true;
    }

    public FindVariableInstancesByNameCommand(String variableId, boolean onlyFromActiveProcesses) {
        this.variableId = variableId;
        this.activeProcesses = onlyFromActiveProcesses;
    }

    public FindVariableInstancesByNameCommand(String variableId, String value) {
        if (variableId == null || variableId.isEmpty()) {
            throw new IllegalArgumentException("The variableId field may not be null or empty.");
        }
        this.variableId = variableId;
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("The value field may not be null or empty.");
        }
        this.value = value;
        this.activeProcesses = true;
    }

    public FindVariableInstancesByNameCommand(String variableId, String value, boolean onlyFromActiveProcesses) {
        this(variableId, value);
        this.activeProcesses = onlyFromActiveProcesses;
    }

    public List<VariableInstanceLog> execute(Context cntxt) {
        this.setLogEnvironment(cntxt);
        if (this.value == null || this.value.isEmpty()) {
            return this.auditLogService.findVariableInstancesByName(this.variableId, this.activeProcesses);
        }
        return this.auditLogService.findVariableInstancesByNameAndValue(this.variableId, this.value, this.activeProcesses);
    }

    public String toString() {
        if (this.variableId == null || this.variableId.isEmpty()) {
            return AuditLogService.class.getSimpleName() + ".findVariableInstancesByName(" + this.variableId + ", " + this.activeProcesses + ")";
        }
        return AuditLogService.class.getSimpleName() + ".findNodeInstancesByNameAndValue(" + this.variableId + ", " + this.value + ", " + this.activeProcesses + ")";
    }
}

