/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.tools.ant;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteJava;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jboss.wsf.spi.tools.WSContractProvider;
import org.jboss.wsf.spi.tools.ant.AntTaskHelper;
import org.jboss.wsf.spi.tools.ant.SecurityActions;
import org.jboss.wsf.spi.tools.cmd.WSProvide;

public class WSProvideTask
extends Task {
    private Path classpath = new Path(this.getProject());
    private CommandlineJava command = new CommandlineJava();
    private String sei;
    private File destdir;
    private File resourcedestdir;
    private File sourcedestdir;
    private boolean keep;
    private boolean extension;
    private boolean genwsdl;
    private boolean verbose;
    private boolean fork;
    private boolean debug;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Commandline.Argument createJvmarg() {
        return this.command.createVmArgument();
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public void setClasspathRef(Reference ref) {
        this.createClasspath().setRefid(ref);
    }

    public Path createClasspath() {
        return this.classpath;
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public void setProtocol(String protocol) {
        if (protocol != null) {
            this.extension = protocol.toLowerCase().indexOf("Xsoap1.2") != -1;
        }
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public void setSei(String sei) {
        this.sei = sei;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public void setResourcedestdir(File resourcedestdir) {
        this.resourcedestdir = resourcedestdir;
    }

    public void setSourcedestdir(File sourcedestdir) {
        this.sourcedestdir = sourcedestdir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setGenwsdl(boolean genwsdl) {
        this.genwsdl = genwsdl;
    }

    private ClassLoader getClasspathLoader(ClassLoader parent) {
        AntClassLoader antLoader = new AntClassLoader(parent, this.getProject(), this.classpath, false);
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tok = new StringTokenizer(antLoader.getClasspath(), File.separator);
        while (tok.hasMoreTokens()) {
            try {
                String path = tok.nextToken();
                if (!path.startsWith("file://")) {
                    path = "file://" + path;
                }
                urls.add(new URL(path));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Failed to wrap classloader", e);
            }
        }
        URLClassLoader wrapper = new URLClassLoader(urls.toArray(new URL[0]), (ClassLoader)antLoader);
        return wrapper;
    }

    public void executeNonForked() {
        ClassLoader prevCL = SecurityActions.getContextClassLoader();
        ClassLoader antLoader = SecurityActions.getClassLoader(((Object)((Object)this)).getClass());
        SecurityActions.setContextClassLoader(antLoader);
        try {
            WSContractProvider gen = WSContractProvider.newInstance((ClassLoader)this.getClasspathLoader(antLoader));
            if (this.verbose) {
                gen.setMessageStream(new PrintStream((OutputStream)new LogOutputStream((Task)this, 2)));
            }
            gen.setGenerateSource(this.keep);
            gen.setGenerateWsdl(this.genwsdl);
            gen.setExtension(this.extension);
            if (this.destdir != null) {
                gen.setOutputDirectory(this.destdir);
            }
            if (this.resourcedestdir != null) {
                gen.setResourceDirectory(this.resourcedestdir);
            }
            if (this.sourcedestdir != null) {
                gen.setSourceDirectory(this.sourcedestdir);
            }
            this.log("Generating from endpoint: " + this.sei, 2);
            gen.provide(this.sei);
        }
        catch (Throwable t) {
            throw new BuildException(t, this.getLocation());
        }
        finally {
            SecurityActions.setContextClassLoader(prevCL);
        }
    }

    public void execute() throws BuildException {
        if (this.sei == null) {
            throw new BuildException("The sei attribute must be specified!", this.getLocation());
        }
        if (this.fork) {
            this.executeForked();
        } else {
            this.executeNonForked();
        }
    }

    private Path getTaskClassPath() {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        if (cl instanceof AntClassLoader) {
            return new Path(this.getProject(), ((AntClassLoader)cl).getClasspath());
        }
        return new Path(this.getProject());
    }

    private void executeForked() throws BuildException {
        this.command.setClassname(WSProvide.class.getName());
        Path path = this.command.createClasspath(this.getProject());
        path.append(this.getTaskClassPath());
        path.append(this.classpath);
        if (this.keep) {
            this.command.createArgument().setValue("-k");
        }
        if (this.genwsdl) {
            this.command.createArgument().setValue("-w");
        }
        if (this.extension) {
            this.command.createArgument().setValue("-e");
        }
        if (this.destdir != null) {
            this.command.createArgument().setValue("-o");
            this.command.createArgument().setFile(this.destdir);
        }
        if (this.resourcedestdir != null) {
            this.command.createArgument().setValue("-r");
            this.command.createArgument().setFile(this.resourcedestdir);
        }
        if (this.sourcedestdir != null) {
            this.command.createArgument().setValue("-s");
            this.command.createArgument().setFile(this.sourcedestdir);
        }
        if (!this.verbose) {
            this.command.createArgument().setValue("-q");
        }
        this.command.createArgument().setValue("-t");
        this.command.createArgument().setValue(this.sei);
        if (this.verbose) {
            this.log("Command invoked: " + this.command.getJavaCommand().toString());
        }
        ExecuteJava execute = new ExecuteJava();
        execute.setClasspath(path);
        execute.setJavaCommand(this.command.getJavaCommand());
        String[] arguments = this.command.getVmCommand().getArguments();
        CommandlineJava.SysProperties properties = AntTaskHelper.toSystemProperties(arguments);
        execute.setSystemProperties(properties);
        if (execute.fork((ProjectComponent)this) != 0) {
            throw new BuildException("Could not invoke WSProvideTask", this.getLocation());
        }
    }
}

