/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.injection.finders;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.jboss.wsf.common.injection.InjectionException;

final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static void assertNoPrimitiveParameters(Method method, Class<? extends Annotation> annotation) {
        for (Class<?> type : method.getParameterTypes()) {
            if (!type.isPrimitive()) continue;
            throw new InjectionException("Method " + ReflectionUtils.getAnnotationMessage(annotation) + "can't declare primitive parameters: " + method);
        }
    }

    public static void assertNoPrimitiveParameters(Method method) {
        ReflectionUtils.assertNoPrimitiveParameters(method, null);
    }

    public static void assertNotPrimitiveType(Field field, Class<? extends Annotation> annotation) {
        if (field.getType().isPrimitive()) {
            throw new InjectionException("Field " + ReflectionUtils.getAnnotationMessage(annotation) + "can't be of primitive type: " + field);
        }
    }

    public static void assertNotPrimitiveType(Field field) {
        ReflectionUtils.assertNotPrimitiveType(field, null);
    }

    public static void assertNoParameters(Method method, Class<? extends Annotation> annotation) {
        if (method.getParameterTypes().length != 0) {
            throw new InjectionException("Method " + ReflectionUtils.getAnnotationMessage(annotation) + "have to have no parameters: " + method);
        }
    }

    public static void assertNoParameters(Method method) {
        ReflectionUtils.assertNoParameters(method, null);
    }

    public static void assertVoidReturnType(Method method, Class<? extends Annotation> annotation) {
        if (!method.getReturnType().equals(Void.class) && !method.getReturnType().equals(Void.TYPE)) {
            throw new InjectionException("Method " + ReflectionUtils.getAnnotationMessage(annotation) + "have to return void: " + method);
        }
    }

    public static void assertVoidReturnType(Method method) {
        ReflectionUtils.assertVoidReturnType(method, null);
    }

    public static void assertNotVoidType(Field field, Class<? extends Annotation> annotation) {
        if (field.getClass().equals(Void.class) && field.getClass().equals(Void.TYPE)) {
            throw new InjectionException("Field " + ReflectionUtils.getAnnotationMessage(annotation) + "cannot be of void type: " + field);
        }
    }

    public static void assertNotVoidType(Field field) {
        ReflectionUtils.assertNotVoidType(field, null);
    }

    public static void assertNoCheckedExceptionsAreThrown(Method method, Class<? extends Annotation> annotation) {
        Class<?>[] declaredExceptions = method.getExceptionTypes();
        for (int i = 0; i < declaredExceptions.length; ++i) {
            Class<RuntimeException> exception = declaredExceptions[i];
            if (exception.isAssignableFrom(RuntimeException.class)) continue;
            throw new InjectionException("Method " + ReflectionUtils.getAnnotationMessage(annotation) + "cannot throw checked exceptions: " + method);
        }
    }

    public static void assertNoCheckedExceptionsAreThrown(Method method) {
        ReflectionUtils.assertNoCheckedExceptionsAreThrown(method, null);
    }

    public static void assertNotStatic(Method method, Class<? extends Annotation> annotation) {
        if (Modifier.isStatic(method.getModifiers())) {
            throw new InjectionException("Method " + ReflectionUtils.getAnnotationMessage(annotation) + "cannot be static: " + method);
        }
    }

    public static void assertNotStatic(Method method) {
        ReflectionUtils.assertNotStatic(method, null);
    }

    public static void assertNotStatic(Field field, Class<? extends Annotation> annotation) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new InjectionException("Field " + ReflectionUtils.getAnnotationMessage(annotation) + "cannot be static: " + field);
        }
    }

    public static void assertNotStatic(Field field) {
        ReflectionUtils.assertNotStatic(field, null);
    }

    public static void assertNotFinal(Field field, Class<? extends Annotation> annotation) {
        if (Modifier.isFinal(field.getModifiers())) {
            throw new InjectionException("Field " + ReflectionUtils.getAnnotationMessage(annotation) + "cannot be final: " + field);
        }
    }

    public static void assertNotFinal(Field field) {
        ReflectionUtils.assertNotFinal(field, null);
    }

    public static void assertOneParameter(Method method, Class<? extends Annotation> annotation) {
        if (method.getParameterTypes().length != 1) {
            throw new InjectionException("Method " + ReflectionUtils.getAnnotationMessage(annotation) + "have to declare exactly one parameter: " + method);
        }
    }

    public static void assertOneParameter(Method method) {
        ReflectionUtils.assertOneParameter(method, null);
    }

    public static void assertValidSetterName(Method method, Class<? extends Annotation> annotation) {
        boolean isUpperCasedPropertyName;
        String methodName = method.getName();
        boolean correctMethodNameLength = methodName.length() > 3;
        boolean isSetterMethodName = methodName.startsWith("set");
        boolean bl = isUpperCasedPropertyName = correctMethodNameLength ? Character.isUpperCase(methodName.charAt(3)) : false;
        if (!(correctMethodNameLength && isSetterMethodName && isUpperCasedPropertyName)) {
            throw new InjectionException("Method " + ReflectionUtils.getAnnotationMessage(annotation) + "doesn't follow Java Beans setter method name: " + method);
        }
    }

    public static void assertValidSetterName(Method method) {
        ReflectionUtils.assertValidSetterName(method, null);
    }

    public static void assertOnlyOneMethod(Collection<Method> methods, Class<? extends Annotation> annotation) {
        if (methods.size() > 1) {
            throw new InjectionException("Only one method " + ReflectionUtils.getAnnotationMessage(annotation) + "can exist");
        }
    }

    public static void assertOnlyOneMethod(Collection<Method> methods) {
        ReflectionUtils.assertOnlyOneMethod(methods, null);
    }

    private static String getAnnotationMessage(Class<? extends Annotation> annotation) {
        return annotation == null ? "" : "annotated with @" + annotation + " annotation ";
    }
}

