/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.logging.jdk;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jboss.test.logging.jdk.PatternConverter;
import org.jboss.test.logging.jdk.PatternParser;

public class PatternFormatter
extends Formatter {
    public static final String DEFAULT_CONVERSION_PATTERN = "%m%n";
    public static final String TTCC_CONVERSION_PATTERN = "%r [%t] %p %c %x - %m%n";
    protected final int BUF_SIZE = 256;
    protected final int MAX_CAPACITY = 1024;
    private String pattern;
    private PatternConverter head;

    public PatternFormatter() {
        this(DEFAULT_CONVERSION_PATTERN);
    }

    public PatternFormatter(String pattern) {
        this.pattern = pattern;
        this.head = this.createPatternParser(pattern == null ? DEFAULT_CONVERSION_PATTERN : pattern).parse();
    }

    public void setConversionPattern(String conversionPattern) {
        this.pattern = conversionPattern;
        this.head = this.createPatternParser(conversionPattern).parse();
    }

    public String getConversionPattern() {
        return this.pattern;
    }

    public void activateOptions() {
    }

    public boolean ignoresThrowable() {
        return true;
    }

    protected PatternParser createPatternParser(String pattern) {
        return new PatternParser(pattern);
    }

    public String format(LogRecord event) {
        StringBuffer sbuf = new StringBuffer(256);
        PatternConverter c = this.head;
        while (c != null) {
            c.format(sbuf, event);
            c = c.next;
        }
        return sbuf.toString();
    }
}

