/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.MavenRepositorySystem;
import org.jboss.shrinkwrap.resolver.impl.maven.convert.MavenConverter;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenModelResolver
implements ModelResolver {
    private final List<RemoteRepository> repositories;
    private final Set<String> repositoryIds;
    private final MavenRepositorySystem system;
    private final RepositorySystemSession session;

    public MavenModelResolver(MavenRepositorySystem system, RepositorySystemSession session, List<RemoteRepository> remoteRepositories) {
        this.system = system;
        this.session = session;
        this.repositories = new ArrayList<RemoteRepository>(remoteRepositories);
        this.repositoryIds = new HashSet<String>();
        for (RemoteRepository repository : this.repositories) {
            this.repositoryIds.add(repository.getId());
        }
    }

    private MavenModelResolver(MavenModelResolver clone) {
        this.system = clone.system;
        this.session = clone.session;
        this.repositories = new ArrayList<RemoteRepository>(clone.repositories);
        this.repositoryIds = new HashSet<String>(clone.repositoryIds);
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
        if (this.repositoryIds.contains(repository.getId())) {
            return;
        }
        this.repositoryIds.add(repository.getId());
        this.repositories.add(MavenConverter.asRemoteRepository(repository));
    }

    public ModelResolver newCopy() {
        return new MavenModelResolver(this);
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        DefaultArtifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
        try {
            ArtifactRequest request = new ArtifactRequest((Artifact)pomArtifact, this.repositories, null);
            pomArtifact = this.system.resolveArtifact(this.session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new UnresolvableModelException("Failed to resolve POM for " + groupId + ":" + artifactId + ":" + version + " due to " + e.getMessage(), groupId, artifactId, version, (Throwable)e);
        }
        File pomFile = pomArtifact.getFile();
        return new FileModelSource(pomFile);
    }
}

