/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.Collection;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyBuilder;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.impl.maven.AbstractMavenDependencyResolverBase;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyBuilderForArtifacts;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyResolverImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenEnvironment;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MavenDependencyBuilderForArtifact
extends AbstractMavenDependencyResolverBase
implements MavenDependencyBuilder {
    MavenDependencyBuilderForArtifact(MavenEnvironment maven, String coordinates) {
        super(maven);
        MavenDependency dependency = MavenConverter.asDepedencyWithVersionManagement(maven.getVersionManagement(), coordinates);
        maven.getDependencies().push(dependency);
    }

    public MavenDependencyResolver up() {
        return new MavenDependencyResolverImpl(this.maven);
    }

    public MavenDependencyBuilder artifact(String coordinates) throws ResolutionException {
        Validate.notNullOrEmpty(coordinates, "Artifact coordinates must not be null or empty");
        MavenDependencyBuilderForArtifact builder = new MavenDependencyBuilderForArtifact(this.maven, coordinates);
        return builder;
    }

    public MavenDependencyBuilder artifacts(String ... coordinates) throws ResolutionException {
        Validate.notNullAndNoNullValues(coordinates, "Artifacts coordinates must not be null or empty");
        MavenDependencyBuilderForArtifacts builder = new MavenDependencyBuilderForArtifacts(this.maven, coordinates);
        return builder;
    }

    public MavenDependencyBuilder scope(String scope) {
        MavenDependency dependency = this.maven.getDependencies().peek();
        dependency.scope(scope);
        return this;
    }

    public MavenDependencyBuilder optional(boolean optional) {
        MavenDependency dependency = this.maven.getDependencies().peek();
        dependency.optional(optional);
        return this;
    }

    public MavenDependencyBuilder exclusion(String exclusion) {
        MavenDependency dependency = this.maven.getDependencies().peek();
        dependency.exclusions(new String[]{exclusion});
        return this;
    }

    public MavenDependencyBuilder exclusions(String ... exclusions) {
        MavenDependency dependency = this.maven.getDependencies().peek();
        dependency.exclusions(exclusions);
        return this;
    }

    public MavenDependencyBuilder exclusions(Collection<String> exclusions) {
        MavenDependency dependency = this.maven.getDependencies().peek();
        dependency.exclusions(exclusions.toArray(new String[0]));
        return this;
    }
}

