/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.jboss.shrinkwrap.resolver.impl.maven.LogRepositoryListener;
import org.jboss.shrinkwrap.resolver.impl.maven.LogTransferListerer;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.SecurityActions;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.transfer.TransferListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenRepositorySettings {
    public static final String ALT_USER_SETTINGS_XML_LOCATION = "org.apache.maven.user-settings";
    public static final String ALT_GLOBAL_SETTINGS_XML_LOCATION = "org.apache.maven.global-settings";
    public static final String ALT_LOCAL_REPOSITORY_LOCATION = "maven.repo.local";
    private static final String DEFAULT_USER_SETTINGS_PATH = SecurityActions.getProperty("user.home").concat("/.m2/settings.xml");
    private static final String DEFAULT_REPOSITORY_PATH = SecurityActions.getProperty("user.home").concat("/.m2/repository");
    private List<RemoteRepository> repositories;
    private Settings settings;

    public MavenRepositorySettings() {
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        String altUserSettings = SecurityActions.getProperty(ALT_USER_SETTINGS_XML_LOCATION);
        String altGlobalSettings = SecurityActions.getProperty(ALT_GLOBAL_SETTINGS_XML_LOCATION);
        request.setUserSettingsFile(new File(DEFAULT_USER_SETTINGS_PATH));
        if (altUserSettings != null && altUserSettings.length() > 0) {
            request.setUserSettingsFile(new File(altUserSettings));
        }
        if (altGlobalSettings != null && altGlobalSettings.length() > 0) {
            request.setUserSettingsFile(new File(altGlobalSettings));
        }
        this.buildSettings((SettingsBuildingRequest)request);
    }

    public void setRemoteRepositories(Model model) {
        ArrayList<RemoteRepository> newRepositories = new ArrayList<RemoteRepository>();
        newRepositories.addAll(this.settingsRepositories());
        for (org.apache.maven.model.Repository repository : model.getRepositories()) {
            newRepositories.add(MavenConverter.asRemoteRepository(repository));
        }
        this.repositories = newRepositories;
    }

    public List<RemoteRepository> getRemoteRepositories() {
        return this.repositories;
    }

    public LocalRepository getLocalRepository() {
        return new LocalRepository(this.settings.getLocalRepository());
    }

    public RepositoryListener getRepositoryListener() {
        return new LogRepositoryListener();
    }

    public TransferListener getTransferListener() {
        return new LogTransferListerer();
    }

    public void buildSettings(SettingsBuildingRequest request) {
        SettingsBuildingResult result;
        try {
            DefaultSettingsBuilder builder = new DefaultSettingsBuilderFactory().newInstance();
            result = builder.build(request);
        }
        catch (SettingsBuildingException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to parse Maven configuration", e);
        }
        Settings settings = result.getEffectiveSettings();
        if (settings.getLocalRepository() == null) {
            String altLocalRepository = SecurityActions.getProperty(ALT_LOCAL_REPOSITORY_LOCATION);
            settings.setLocalRepository(DEFAULT_REPOSITORY_PATH);
            if (altLocalRepository != null && altLocalRepository.length() > 0) {
                settings.setLocalRepository(altLocalRepository);
            }
        }
        this.settings = settings;
        this.repositories = this.settingsRepositories();
    }

    private List<RemoteRepository> settingsRepositories() {
        List actives = this.settings.getActiveProfiles();
        ArrayList<RemoteRepository> settingsRepos = new ArrayList<RemoteRepository>();
        settingsRepos.add(this.centralRepository());
        for (Map.Entry profile : this.settings.getProfilesAsMap().entrySet()) {
            Activation activation = ((Profile)profile.getValue()).getActivation();
            if (!actives.contains(profile.getKey()) && (activation == null || !activation.isActiveByDefault())) continue;
            for (Repository repo : ((Profile)profile.getValue()).getRepositories()) {
                settingsRepos.add(MavenConverter.asRemoteRepository(repo));
            }
        }
        return settingsRepos;
    }

    private RemoteRepository centralRepository() {
        return new RemoteRepository("central", "default", "http://repo1.maven.org/maven2");
    }
}

