/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging.AbstractCompilingProcessor;
import org.jboss.shrinkwrap.resolver.impl.maven.task.AddAllDeclaredDependenciesTask;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.jboss.shrinkwrap.resolver.spi.maven.archive.packaging.PackagingProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarPackagingProcessor
extends AbstractCompilingProcessor<WebArchive>
implements PackagingProcessor<WebArchive> {
    public static final String MAVEN_WAR_PLUGIN_KEY = "org.apache.maven.plugins:maven-war-plugin";
    private WebArchive archive;

    public boolean handles(PackagingType packagingType) {
        return PackagingType.WAR.equals((Object)packagingType);
    }

    public WarPackagingProcessor configure(Archive<?> archive, MavenWorkingSession session) {
        super.configure(session);
        this.archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)session.getParsedPomFile().getFinalName());
        return this;
    }

    public WebArchive getResultingArchive() {
        return this.archive;
    }

    public WarPackagingProcessor importBuildOutput(MavenResolutionStrategy strategy) throws IllegalArgumentException, UnsupportedOperationException {
        ParsedPomFile pomFile = this.session.getParsedPomFile();
        if (Validate.isReadable((File)pomFile.getSourceDirectory())) {
            this.compile(pomFile.getSourceDirectory(), pomFile.getBuildOutputDirectory(), ScopeType.COMPILE, ScopeType.IMPORT, ScopeType.RUNTIME, ScopeType.SYSTEM);
            JavaArchive classes = (JavaArchive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"sources.jar")).importDirectory(pomFile.getBuildOutputDirectory()).as(JavaArchive.class);
            this.archive = (WebArchive)this.archive.merge((Archive)classes, "WEB-INF/classes");
        }
        for (File resource : pomFile.getProjectResources()) {
            this.archive.addAsResource(resource);
        }
        Map warConfiguration = pomFile.getPluginConfiguration(MAVEN_WAR_PLUGIN_KEY);
        File warSourceDirectory = null;
        warSourceDirectory = warConfiguration.isEmpty() || !warConfiguration.containsKey("warSourceDirectory") ? new File(pomFile.getBaseDirectory(), "src/main/webapp") : new File(warConfiguration.get("warSourceDirectory").toString());
        if (Validate.isReadable((File)warSourceDirectory)) {
            WebArchive webapp = (WebArchive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"webapp.war")).importDirectory(warSourceDirectory).as(WebArchive.class);
            this.archive = (WebArchive)this.archive.merge((Archive)webapp);
        }
        this.session = AddAllDeclaredDependenciesTask.INSTANCE.execute(this.session);
        Collection artifacts = this.session.resolveDependencies(strategy);
        for (MavenResolvedArtifact artifact : artifacts) {
            this.archive.addAsLibrary(artifact.asFile());
        }
        return this;
    }
}

