/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.config.BaseSecurityInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationInfo
extends BaseAuthenticationInfo {
    public static final AuthPermission GET_CONFIG_ENTRY_PERM = new AuthPermission("getLoginConfiguration");
    public static final AuthPermission SET_CONFIG_ENTRY_PERM = new AuthPermission("setLoginConfiguration");
    private CallbackHandler callbackHandler;

    public AuthenticationInfo() {
        this(null);
    }

    public AuthenticationInfo(String name) {
        this.name = name;
    }

    public void addAppConfigurationEntry(AppConfigurationEntry entry) {
        this.moduleEntries.add(entry);
    }

    public void setAppConfigurationEntry(AppConfigurationEntry[] loginModules) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONFIG_ENTRY_PERM);
        }
        this.moduleEntries.addAll(Arrays.asList(loginModules));
    }

    public void setAppConfigurationEntry(List<AppConfigurationEntry> listOfEntries) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONFIG_ENTRY_PERM);
        }
        this.moduleEntries.addAll(listOfEntries);
    }

    public CallbackHandler getAppCallbackHandler() {
        return this.callbackHandler;
    }

    public void setAppCallbackHandler(CallbackHandler handler) {
        this.callbackHandler = handler;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("AppConfigurationEntry[]:\n");
        for (int i = 0; i < this.moduleEntries.size(); ++i) {
            AppConfigurationEntry entry = (AppConfigurationEntry)this.moduleEntries.get(i);
            buffer.append("[" + i + "]");
            buffer.append("\nLoginModule Class: " + entry.getLoginModuleName());
            buffer.append("\nControlFlag: " + entry.getControlFlag());
            buffer.append("\nOptions:\n");
            Map<String, ?> options = entry.getOptions();
            for (Map.Entry<String, ?> e : options.entrySet()) {
                String name = e.getKey();
                String value = e.getValue().toString();
                if (name.toLowerCase().equals("password") || name.toLowerCase().equals("bindcredential") || name.toLowerCase().equals("java.naming.security.credentials")) {
                    value = "****";
                }
                buffer.append("name=" + name);
                buffer.append(", value=" + value);
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    @Override
    protected BaseSecurityInfo<Object> create(String name) {
        return new AuthenticationInfo(name);
    }
}

