/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.wrapper;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import org.jboss.seam.remoting.wrapper.BaseWrapper;
import org.jboss.seam.remoting.wrapper.ConversionException;
import org.jboss.seam.remoting.wrapper.ConversionScore;
import org.jboss.seam.remoting.wrapper.Wrapper;

public class NumberWrapper
extends BaseWrapper
implements Wrapper {
    private static final byte[] NUMBER_TAG_OPEN = "<number>".getBytes();
    private static final byte[] NUMBER_TAG_CLOSE = "</number>".getBytes();

    public Object convert(Type type) throws ConversionException {
        String val = this.element.getStringValue().trim();
        if (type.equals(Short.class)) {
            this.value = !"".equals(val) ? Short.valueOf(val) : null;
        } else if (type.equals(Short.TYPE)) {
            this.value = Short.parseShort(val);
        } else if (type.equals(Integer.class)) {
            this.value = !"".equals(val) ? Integer.valueOf(val) : null;
        } else if (type.equals(Integer.TYPE)) {
            this.value = Integer.parseInt(val);
        } else if (type.equals(Long.class) || type.equals(Object.class)) {
            this.value = !"".equals(val) ? Long.valueOf(val) : null;
        } else if (type.equals(Long.TYPE)) {
            this.value = Long.parseLong(val);
        } else if (type.equals(Float.class)) {
            this.value = !"".equals(val) ? Float.valueOf(val) : null;
        } else if (type.equals(Float.TYPE)) {
            this.value = Float.valueOf(Float.parseFloat(val));
        } else if (type.equals(Double.class)) {
            this.value = !"".equals(val) ? Double.valueOf(val) : null;
        } else if (type.equals(Double.TYPE)) {
            this.value = Double.parseDouble(val);
        } else if (type.equals(Byte.class)) {
            this.value = !"".equals(val) ? Byte.valueOf(val) : null;
        } else if (type.equals(Byte.TYPE)) {
            this.value = Byte.parseByte(val);
        } else if (type.equals(String.class)) {
            this.value = val;
        } else {
            throw new ConversionException(String.format("Value [%s] cannot be converted to type [%s].", this.element.getStringValue(), type));
        }
        return this.value;
    }

    public void marshal(OutputStream out) throws IOException {
        out.write(NUMBER_TAG_OPEN);
        out.write(this.value.toString().getBytes());
        out.write(NUMBER_TAG_CLOSE);
    }

    public ConversionScore conversionScore(Class cls) {
        if (cls.equals(Integer.class) || cls.equals(Integer.TYPE) || cls.equals(Long.class) || cls.equals(Long.TYPE) || cls.equals(Short.class) || cls.equals(Short.TYPE) || cls.equals(Double.class) || cls.equals(Double.TYPE) || cls.equals(Float.class) || cls.equals(Float.TYPE) || cls.equals(Byte.class) || cls.equals(Byte.TYPE)) {
            return ConversionScore.exact;
        }
        if (cls.equals(String.class) || cls.equals(Object.class)) {
            return ConversionScore.compatible;
        }
        return ConversionScore.nomatch;
    }
}

