/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.wrapper;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.dom4j.Element;
import org.jboss.seam.Component;
import org.jboss.seam.Seam;
import org.jboss.seam.remoting.InterfaceGenerator;
import org.jboss.seam.remoting.wrapper.BaseWrapper;
import org.jboss.seam.remoting.wrapper.ConversionException;
import org.jboss.seam.remoting.wrapper.ConversionScore;
import org.jboss.seam.remoting.wrapper.Wrapper;
import org.jboss.seam.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanWrapper
extends BaseWrapper
implements Wrapper {
    private static final byte[] REF_START_TAG_OPEN = "<ref id=\"".getBytes();
    private static final byte[] REF_START_TAG_END = "\"/>".getBytes();
    private static final byte[] BEAN_START_TAG_OPEN = "<bean type=\"".getBytes();
    private static final byte[] BEAN_START_TAG_CLOSE = "\">".getBytes();
    private static final byte[] BEAN_CLOSE_TAG = "</bean>".getBytes();
    private static final byte[] MEMBER_START_TAG_OPEN = "<member name=\"".getBytes();
    private static final byte[] MEMBER_START_TAG_CLOSE = "\">".getBytes();
    private static final byte[] MEMBER_CLOSE_TAG = "</member>".getBytes();

    @Override
    public void setElement(Element element) {
        super.setElement(element);
        String beanType = element.attributeValue("type");
        Component component = Component.forName((String)beanType);
        if (component != null) {
            this.value = component.newInstance();
        } else {
            try {
                this.value = Reflections.classForName((String)beanType).newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not unmarshal bean element: " + element.getText(), ex);
            }
        }
    }

    @Override
    public void unmarshal() {
        List members = this.element.elements("member");
        for (Element member : members) {
            String name = member.attributeValue("name");
            Wrapper w = this.context.createWrapperFromElement((Element)member.elementIterator().next());
            Class<?> cls = this.value.getClass();
            Method method = null;
            Field field = null;
            String setter = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            ConversionScore score = ConversionScore.nomatch;
            for (Method m : cls.getMethods()) {
                ConversionScore s;
                if (!setter.equals(m.getName()) || m.getParameterTypes().length != 1 || (s = w.conversionScore(m.getParameterTypes()[0])).getScore() <= score.getScore()) continue;
                method = m;
                score = s;
            }
            if (method == null) {
                while (field == null && !cls.equals(Object.class)) {
                    try {
                        field = cls.getDeclaredField(name);
                    }
                    catch (NoSuchFieldException ex) {
                        cls = cls.getSuperclass();
                    }
                }
                if (field == null) {
                    throw new RuntimeException(String.format("Error while unmarshalling - property [%s] not found in class [%s]", name, this.value.getClass().getName()));
                }
            }
            Object fieldValue = null;
            try {
                fieldValue = w.convert(method != null ? method.getGenericParameterTypes()[0] : field.getGenericType());
            }
            catch (ConversionException ex) {
                throw new RuntimeException("Could not convert value while unmarshaling", ex);
            }
            if (method != null) {
                try {
                    method.invoke(this.value, fieldValue);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Could not invoke setter method [%s]", method.getName()));
                }
            }
            boolean accessible = field.isAccessible();
            try {
                if (!accessible) {
                    field.setAccessible(true);
                }
                field.set(this.value, fieldValue);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not set field value.", ex);
            }
            finally {
                field.setAccessible(accessible);
            }
        }
    }

    @Override
    public Object convert(Type type) throws ConversionException {
        if (type instanceof Class && ((Class)type).isAssignableFrom(this.value.getClass())) {
            return this.value;
        }
        throw new ConversionException(String.format("Value [%s] cannot be converted to type [%s].", this.value, type));
    }

    @Override
    public void marshal(OutputStream out) throws IOException {
        this.context.addOutRef(this);
        out.write(REF_START_TAG_OPEN);
        out.write(Integer.toString(this.context.getOutRefs().indexOf(this)).getBytes());
        out.write(REF_START_TAG_END);
    }

    @Override
    public void serialize(OutputStream out) throws IOException {
        this.serialize(out, null);
    }

    public void serialize(OutputStream out, List<String> constraints) throws IOException {
        String componentName;
        Component component;
        out.write(BEAN_START_TAG_OPEN);
        Class cls = this.value.getClass();
        if (cls.getName().contains("EnhancerByCGLIB")) {
            cls = cls.getSuperclass();
        }
        if (cls.getName().contains("_$$_javassist_")) {
            cls = cls.getSuperclass();
        }
        Component component2 = component = (componentName = Seam.getComponentName(cls)) != null ? Component.forName((String)componentName) : null;
        if (component != null) {
            cls = component.getBeanClass();
        }
        if (componentName != null) {
            out.write(componentName.getBytes());
        } else {
            out.write(cls.getName().getBytes());
        }
        out.write(BEAN_START_TAG_CLOSE);
        for (String propertyName : InterfaceGenerator.getAccessibleProperties(cls)) {
            block22: {
                String fieldPath = this.path != null && this.path.length() > 0 ? String.format("%s.%s", this.path, propertyName) : propertyName;
                String wildCard = String.format("[%s].%s", componentName != null ? componentName : cls.getName(), propertyName);
                if (constraints != null && (constraints.contains(fieldPath) || constraints.contains(wildCard))) continue;
                out.write(MEMBER_START_TAG_OPEN);
                out.write(propertyName.getBytes());
                out.write(MEMBER_START_TAG_CLOSE);
                Field f = null;
                try {
                    f = cls.getField(propertyName);
                }
                catch (NoSuchFieldException ex) {
                    // empty catch block
                }
                boolean accessible = false;
                try {
                    if (f != null) {
                        accessible = f.isAccessible();
                        f.setAccessible(true);
                        this.context.createWrapperFromObject(f.get(this.value), fieldPath).marshal(out);
                        break block22;
                    }
                    Method accessor = null;
                    try {
                        accessor = cls.getMethod(String.format("get%s%s", Character.valueOf(Character.toUpperCase(propertyName.charAt(0))), propertyName.substring(1)), new Class[0]);
                    }
                    catch (NoSuchMethodException ex) {
                        try {
                            accessor = cls.getMethod(String.format("is%s%s", Character.valueOf(Character.toUpperCase(propertyName.charAt(0))), propertyName.substring(1)), new Class[0]);
                        }
                        catch (NoSuchMethodException ex2) {
                            if (f == null) continue;
                            f.setAccessible(accessible);
                            continue;
                        }
                    }
                    try {
                        this.context.createWrapperFromObject(accessor.invoke(this.value, new Object[0]), fieldPath).marshal(out);
                    }
                    catch (InvocationTargetException ex) {
                        throw new RuntimeException(String.format("Failed to read property [%s] for object [%s]", propertyName, this.value));
                    }
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("Error reading value from field.");
                }
                finally {
                    if (f != null) {
                        f.setAccessible(accessible);
                    }
                }
            }
            out.write(MEMBER_CLOSE_TAG);
        }
        out.write(BEAN_CLOSE_TAG);
    }

    @Override
    public ConversionScore conversionScore(Class cls) {
        if (cls.equals(this.value.getClass())) {
            return ConversionScore.exact;
        }
        if (cls.isAssignableFrom(this.value.getClass()) || cls.equals(Object.class)) {
            return ConversionScore.compatible;
        }
        return ConversionScore.nomatch;
    }
}

