/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.remoting.RequestHandler;
import org.jboss.seam.remoting.RequestHandlerFactory;
import org.jboss.seam.web.AbstractResource;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.remoting.remoting")
@Install(precedence=0)
@BypassInterceptors
public class Remoting
extends AbstractResource {
    public static final int DEFAULT_POLL_TIMEOUT = 10;
    public static final int DEFAULT_POLL_INTERVAL = 1;
    private int pollTimeout = 10;
    private int pollInterval = 1;
    private boolean debug = false;
    private Map<String, byte[]> cachedConfig = new HashMap<String, byte[]>();
    private static final LogProvider log = Logging.getLogProvider(Remoting.class);
    private static final Pattern pathPattern = Pattern.compile("/(.*?)/([^/]+)");
    private static final String REMOTING_RESOURCE_PATH = "resource";

    public String getResourcePath() {
        return "/remoting";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initConfig(String contextPath, HttpServletRequest request) {
        if (!this.cachedConfig.containsKey(contextPath)) {
            try {
                ServletLifecycle.beginRequest((HttpServletRequest)request);
                StringBuilder sb = new StringBuilder();
                sb.append("\nSeam.Remoting.resourcePath = \"");
                sb.append(contextPath);
                sb.append(request.getServletPath());
                sb.append(this.getResourcePath());
                sb.append("\";");
                sb.append("\nSeam.Remoting.debug = ");
                sb.append(this.getDebug() ? "true" : "false");
                sb.append(";");
                sb.append("\nSeam.Remoting.pollInterval = ");
                sb.append(this.getPollInterval());
                sb.append(";");
                sb.append("\nSeam.Remoting.pollTimeout = ");
                sb.append(this.getPollTimeout());
                sb.append(";");
                this.cachedConfig.put(contextPath, sb.toString().getBytes());
            }
            finally {
                ServletLifecycle.endRequest((HttpServletRequest)request);
            }
        }
    }

    public void getResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String pathInfo = request.getPathInfo().substring(this.getResourcePath().length());
            RequestHandler handler = RequestHandlerFactory.getInstance().getRequestHandler(pathInfo);
            if (handler != null) {
                handler.setServletContext(this.getServletContext());
                handler.handle(request, response);
            } else {
                Matcher m = pathPattern.matcher(pathInfo);
                if (m.matches()) {
                    String path = m.group(1);
                    String resource = m.group(2);
                    if (REMOTING_RESOURCE_PATH.equals(path)) {
                        this.writeResource(resource, response);
                        if ("remote.js".equals(resource)) {
                            this.appendConfig((OutputStream)response.getOutputStream(), request.getContextPath(), request);
                        }
                    }
                    response.getOutputStream().flush();
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error", (Throwable)ex);
        }
    }

    private void appendConfig(OutputStream out, String contextPath, HttpServletRequest request) throws IOException {
        if (!this.cachedConfig.containsKey(contextPath)) {
            this.initConfig(contextPath, request);
        }
        out.write(this.cachedConfig.get(contextPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResource(String resourceName, HttpServletResponse response) throws IOException {
        if (resourceName.endsWith(".js")) {
            InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/jboss/seam/remoting/" + resourceName);
            try {
                if (in != null) {
                    response.setContentType("text/javascript");
                    byte[] buffer = new byte[1024];
                    int read = in.read(buffer);
                    while (read != -1) {
                        response.getOutputStream().write(buffer, 0, read);
                        read = in.read(buffer);
                    }
                } else {
                    log.error((Object)String.format("Resource [%s] not found.", resourceName));
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    public int getPollTimeout() {
        return this.pollTimeout;
    }

    public void setPollTimeout(int pollTimeout) {
        this.pollTimeout = pollTimeout;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

